/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.lib;

import com.cloudera.sqoop.io.LobFile;
import com.cloudera.sqoop.lib.LobRef;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Matcher;
import org.apache.hadoop.io.Text;

public class ClobRef
extends LobRef<String, String, Reader> {
    public ClobRef() {
    }

    public ClobRef(String chars) {
        super(chars);
    }

    public ClobRef(String file, long offset, long length) {
        super(file, offset, length);
    }

    @Override
    protected Reader getExternalSource(LobFile.Reader reader) throws IOException {
        return reader.readClobRecord();
    }

    @Override
    protected Reader getInternalSource(String data) {
        return new StringReader(data);
    }

    @Override
    protected String deepCopyData(String data) {
        return data;
    }

    @Override
    protected String getInternalData(String data) {
        return data;
    }

    @Override
    public void readFieldsInternal(DataInput in) throws IOException {
        this.setDataObj(Text.readString((DataInput)in));
    }

    @Override
    public void writeInternal(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)((String)this.getDataObj()));
    }

    public static ClobRef parse(String inputString) {
        Matcher m = (Matcher)EXTERNAL_MATCHER.get();
        m.reset(inputString);
        if (m.matches()) {
            return new ClobRef(m.group(1), Long.valueOf(m.group(2)), Long.valueOf(m.group(3)));
        }
        return new ClobRef(inputString);
    }
}

