/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.manager.Db2Manager;
import com.cloudera.sqoop.manager.DirectMySQLManager;
import com.cloudera.sqoop.manager.DirectPostgresqlManager;
import com.cloudera.sqoop.manager.GenericJdbcManager;
import com.cloudera.sqoop.manager.HsqldbManager;
import com.cloudera.sqoop.manager.ManagerFactory;
import com.cloudera.sqoop.manager.MySQLManager;
import com.cloudera.sqoop.manager.OracleManager;
import com.cloudera.sqoop.manager.PostgresqlManager;
import com.cloudera.sqoop.manager.SQLServerManager;
import com.cloudera.sqoop.metastore.JobData;
import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DefaultManagerFactory
extends ManagerFactory {
    public static final Log LOG = LogFactory.getLog((String)DefaultManagerFactory.class.getName());

    @Override
    public ConnManager accept(JobData data) {
        String scheme;
        SqoopOptions options = data.getSqoopOptions();
        String manualDriver = options.getDriverClassName();
        if (manualDriver != null) {
            return new GenericJdbcManager(manualDriver, options);
        }
        if (null != options.getConnManagerClassName()) {
            String className = options.getConnManagerClassName();
            ConnManager connManager = null;
            try {
                Class<?> cls = Class.forName(className);
                Constructor<?> constructor = cls.getDeclaredConstructor(SqoopOptions.class);
                connManager = (ConnManager)constructor.newInstance(options);
            }
            catch (Exception e) {
                System.err.println("problem finding the connection manager for class name :" + className);
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                System.err.println(e.getMessage());
            }
            return connManager;
        }
        String connectStr = options.getConnectString();
        int schemeStopIdx = connectStr.indexOf("//");
        if (-1 == schemeStopIdx && -1 == (schemeStopIdx = connectStr.lastIndexOf(58))) {
            LOG.warn((Object)"Could not determine scheme component of connect string");
            schemeStopIdx = connectStr.length();
        }
        if (null == (scheme = connectStr.substring(0, schemeStopIdx))) {
            LOG.warn((Object)"Null scheme associated with connect string.");
            return null;
        }
        LOG.debug((Object)("Trying with scheme: " + scheme));
        if (scheme.equals("jdbc:mysql:")) {
            if (options.isDirect()) {
                return new DirectMySQLManager(options);
            }
            return new MySQLManager(options);
        }
        if (scheme.equals("jdbc:postgresql:")) {
            if (options.isDirect()) {
                return new DirectPostgresqlManager(options);
            }
            return new PostgresqlManager(options);
        }
        if (scheme.startsWith("jdbc:hsqldb:")) {
            return new HsqldbManager(options);
        }
        if (scheme.startsWith("jdbc:oracle:")) {
            return new OracleManager(options);
        }
        if (scheme.startsWith("jdbc:sqlserver:")) {
            return new SQLServerManager(options);
        }
        if (scheme.startsWith("jdbc:db2:")) {
            return new Db2Manager(options);
        }
        return null;
    }
}

