/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.mapreduce;

import com.cloudera.sqoop.mapreduce.AvroRecordReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class AvroInputFormat<T>
extends FileInputFormat<AvroWrapper<T>, NullWritable> {
    protected List<FileStatus> listStatus(JobContext job) throws IOException {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        for (FileStatus file : super.listStatus(job)) {
            if (!file.getPath().getName().endsWith(".avro")) continue;
            result.add(file);
        }
        return result;
    }

    public RecordReader<AvroWrapper<T>, NullWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        context.setStatus(split.toString());
        return new AvroRecordReader();
    }
}

