/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.mapreduce;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.config.ConfigurationHelper;
import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.mapreduce.AvroImportMapper;
import com.cloudera.sqoop.mapreduce.AvroJob;
import com.cloudera.sqoop.mapreduce.AvroOutputFormat;
import com.cloudera.sqoop.mapreduce.ImportJobBase;
import com.cloudera.sqoop.mapreduce.RawKeyTextOutputFormat;
import com.cloudera.sqoop.mapreduce.SequenceFileImportMapper;
import com.cloudera.sqoop.mapreduce.TextImportMapper;
import com.cloudera.sqoop.mapreduce.db.DBConfiguration;
import com.cloudera.sqoop.mapreduce.db.DataDrivenDBInputFormat;
import com.cloudera.sqoop.orm.AvroSchemaGenerator;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.avro.Schema;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;

public class DataDrivenImportJob
extends ImportJobBase {
    public static final Log LOG = LogFactory.getLog((String)DataDrivenImportJob.class.getName());

    public DataDrivenImportJob(SqoopOptions opts) {
        super(opts, null, DataDrivenDBInputFormat.class, null, null);
    }

    public DataDrivenImportJob(SqoopOptions opts, Class<? extends InputFormat> inputFormatClass, ImportJobContext context) {
        super(opts, null, inputFormatClass, null, context);
    }

    @Override
    protected void configureMapper(Job job, String tableName, String tableClassName) throws IOException {
        if (this.options.getFileLayout() == SqoopOptions.FileLayout.TextFile) {
            job.setOutputKeyClass(Text.class);
            job.setOutputValueClass(NullWritable.class);
        } else if (this.options.getFileLayout() == SqoopOptions.FileLayout.AvroDataFile) {
            ConnManager connManager = this.getContext().getConnManager();
            AvroSchemaGenerator generator = new AvroSchemaGenerator(this.options, connManager, tableName);
            Schema schema = generator.generate();
            AvroJob.setMapOutputSchema(job.getConfiguration(), schema);
        }
        job.setMapperClass(this.getMapperClass());
    }

    @Override
    protected Class<? extends Mapper> getMapperClass() {
        if (this.options.getFileLayout() == SqoopOptions.FileLayout.TextFile) {
            return TextImportMapper.class;
        }
        if (this.options.getFileLayout() == SqoopOptions.FileLayout.SequenceFile) {
            return SequenceFileImportMapper.class;
        }
        if (this.options.getFileLayout() == SqoopOptions.FileLayout.AvroDataFile) {
            return AvroImportMapper.class;
        }
        return null;
    }

    @Override
    protected Class<? extends OutputFormat> getOutputFormatClass() throws ClassNotFoundException {
        if (this.options.getFileLayout() == SqoopOptions.FileLayout.TextFile) {
            return RawKeyTextOutputFormat.class;
        }
        if (this.options.getFileLayout() == SqoopOptions.FileLayout.SequenceFile) {
            return SequenceFileOutputFormat.class;
        }
        if (this.options.getFileLayout() == SqoopOptions.FileLayout.AvroDataFile) {
            return AvroOutputFormat.class;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void configureInputFormat(Job job, String tableName, String tableClassName, String splitByCol) throws IOException {
        ConnManager mgr = this.getContext().getConnManager();
        try {
            String username = this.options.getUsername();
            if (null == username || username.length() == 0) {
                DBConfiguration.configureDB(job.getConfiguration(), mgr.getDriverClass(), this.options.getConnectString(), this.options.getFetchSize());
            } else {
                DBConfiguration.configureDB(job.getConfiguration(), mgr.getDriverClass(), this.options.getConnectString(), username, this.options.getPassword(), this.options.getFetchSize());
            }
            if (null != tableName) {
                String[] colNames = this.options.getColumns();
                if (null == colNames) {
                    colNames = mgr.getColumnNames(tableName);
                }
                String[] sqlColNames = null;
                if (null != colNames) {
                    sqlColNames = new String[colNames.length];
                    for (int i = 0; i < colNames.length; ++i) {
                        sqlColNames[i] = mgr.escapeColName(colNames[i]);
                    }
                }
                String whereClause = this.options.getWhereClause();
                DataDrivenDBInputFormat.setInput(job, DBWritable.class, mgr.escapeTableName(tableName), whereClause, mgr.escapeColName(splitByCol), sqlColNames);
                if (this.options.getBoundaryQuery() != null) {
                    DataDrivenDBInputFormat.setBoundingQuery(job.getConfiguration(), this.options.getBoundaryQuery());
                }
            } else {
                String inputQuery = this.options.getSqlQuery();
                String sanitizedQuery = inputQuery.replace("$CONDITIONS", " (1 = 1) ");
                String inputBoundingQuery = this.options.getBoundaryQuery();
                if (inputBoundingQuery == null && (inputBoundingQuery = mgr.getInputBoundsQuery(splitByCol, sanitizedQuery)) == null) {
                    inputBoundingQuery = splitByCol != null ? "SELECT MIN(" + splitByCol + "), MAX(" + splitByCol + ") FROM (" + sanitizedQuery + ") AS t1" : "";
                }
                DataDrivenDBInputFormat.setInput(job, DBWritable.class, inputQuery, inputBoundingQuery);
                new DBConfiguration(job.getConfiguration()).setInputOrderBy(splitByCol);
            }
            LOG.debug((Object)("Using table class: " + tableClassName));
            job.getConfiguration().set(ConfigurationHelper.getDbInputClassProperty(), tableClassName);
            job.getConfiguration().setLong("sqoop.inline.lob.length.max", this.options.getInlineLobLimit());
            LOG.debug((Object)("Using InputFormat: " + this.inputFormatClass));
            job.setInputFormatClass(this.inputFormatClass);
        }
        finally {
            try {
                mgr.close();
            }
            catch (SQLException sqlE) {
                LOG.warn((Object)("Error closing connection: " + sqlE));
            }
        }
    }
}

