/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.mapreduce;

import com.cloudera.sqoop.mapreduce.CombineShimRecordReader;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.CombineFileRecordReader;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;

public class ExportInputFormat
extends CombineFileInputFormat<LongWritable, Object> {
    public static final Log LOG = LogFactory.getLog((String)ExportInputFormat.class.getName());
    public static final int DEFAULT_NUM_MAP_TASKS = 4;

    private long getJobSize(JobContext job) throws IOException {
        List stats = this.listStatus(job);
        long count = 0L;
        for (FileStatus stat : stats) {
            count += stat.getLen();
        }
        return count;
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        long numTasks = ExportInputFormat.getNumMapTasks(job);
        long numFileBytes = this.getJobSize(job);
        long maxSplitSize = numFileBytes / numTasks;
        this.setMaxSplitSize(maxSplitSize);
        LOG.debug((Object)("Target numMapTasks=" + numTasks));
        LOG.debug((Object)("Total input bytes=" + numFileBytes));
        LOG.debug((Object)("maxSplitSize=" + maxSplitSize));
        List splits = super.getSplits(job);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Generated splits:");
            for (InputSplit split : splits) {
                LOG.debug((Object)("  " + split));
            }
        }
        return splits;
    }

    public RecordReader createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
        CombineFileSplit combineSplit = (CombineFileSplit)split;
        CombineFileRecordReader rr = new CombineFileRecordReader(combineSplit, context, CombineShimRecordReader.class);
        return rr;
    }

    public static void setNumMapTasks(JobContext job, int numTasks) {
        job.getConfiguration().setInt("sqoop.mapreduce.export.map.tasks", numTasks);
    }

    public static int getNumMapTasks(JobContext job) {
        return job.getConfiguration().getInt("sqoop.mapreduce.export.map.tasks", 4);
    }
}

