/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.mapreduce;

import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.mapreduce.MergeRecord;
import java.io.IOException;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class MergeReducer
extends Reducer<Text, MergeRecord, SqoopRecord, NullWritable> {
    public void reduce(Text key, Iterable<MergeRecord> vals, Reducer.Context c) throws IOException, InterruptedException {
        SqoopRecord bestRecord = null;
        try {
            for (MergeRecord val : vals) {
                if (null == bestRecord && !val.isNewRecord()) {
                    bestRecord = (SqoopRecord)val.getSqoopRecord().clone();
                    continue;
                }
                if (!val.isNewRecord()) continue;
                bestRecord = (SqoopRecord)val.getSqoopRecord().clone();
            }
        }
        catch (CloneNotSupportedException cnse) {
            throw new IOException(cnse);
        }
        if (null != bestRecord) {
            c.write(bestRecord, (Object)NullWritable.get());
        }
    }
}

