/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.mapreduce;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;

public class RawKeyTextOutputFormat<K, V>
extends FileOutputFormat<K, V> {
    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException {
        FSDataOutputStream fileOut;
        boolean isCompressed = RawKeyTextOutputFormat.getCompressOutput((JobContext)context);
        Configuration conf = context.getConfiguration();
        String ext = "";
        CompressionCodec codec = null;
        if (isCompressed) {
            Class codecClass = RawKeyTextOutputFormat.getOutputCompressorClass((JobContext)context, GzipCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)conf);
            ext = codec.getDefaultExtension();
        }
        Path file = this.getDefaultWorkFile(context, ext);
        FileSystem fs = file.getFileSystem(conf);
        Object ostream = fileOut = fs.create(file, false);
        if (isCompressed) {
            ostream = new DataOutputStream((OutputStream)codec.createOutputStream((OutputStream)fileOut));
        }
        return new RawKeyRecordWriter((DataOutputStream)ostream);
    }

    protected static class RawKeyRecordWriter<K, V>
    extends RecordWriter<K, V> {
        private static final String UTF8 = "UTF-8";
        protected DataOutputStream out;

        public RawKeyRecordWriter(DataOutputStream out) {
            this.out = out;
        }

        private void writeObject(Object o) throws IOException {
            if (o instanceof Text) {
                Text to = (Text)o;
                this.out.write(to.getBytes(), 0, to.getLength());
            } else {
                this.out.write(o.toString().getBytes(UTF8));
            }
        }

        public synchronized void write(K key, V value) throws IOException {
            this.writeObject(key);
        }

        public synchronized void close(TaskAttemptContext context) throws IOException {
            this.out.close();
        }
    }
}

