/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.tool;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.cli.RelatedOptions;
import com.cloudera.sqoop.cli.ToolOptions;
import com.cloudera.sqoop.tool.BaseSqoopTool;
import com.cloudera.sqoop.util.ResultSetPrinter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;

public class EvalSqlTool
extends BaseSqoopTool {
    public static final Log LOG = LogFactory.getLog((String)EvalSqlTool.class.getName());

    public EvalSqlTool() {
        super("eval");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(SqoopOptions options) {
        if (!this.init(options)) {
            return 1;
        }
        Statement stmt = null;
        ResultSet rs = null;
        PrintWriter pw = null;
        try {
            Connection c = this.manager.getConnection();
            String query = options.getSqlQuery();
            LOG.debug((Object)("SQL query: " + query));
            stmt = c.prepareStatement(query);
            boolean resultType = stmt.execute();
            while (true) {
                LOG.debug((Object)("resultType=" + resultType));
                if (!resultType) {
                    int updateCount = stmt.getUpdateCount();
                    LOG.debug((Object)("updateCount=" + updateCount));
                    if (updateCount == -1) {
                        c.commit();
                        break;
                    }
                    LOG.info((Object)(updateCount + " row(s) updated."));
                } else {
                    rs = stmt.getResultSet();
                    pw = new PrintWriter(System.out, true);
                    new ResultSetPrinter().printResultSet(pw, rs);
                    pw.close();
                    pw = null;
                }
                resultType = stmt.getMoreResults();
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)("IOException formatting results: " + StringUtils.stringifyException((Throwable)ioe)));
            int n = 1;
            return n;
        }
        catch (SQLException sqlE) {
            LOG.warn((Object)("SQL exception executing statement: " + StringUtils.stringifyException((Throwable)sqlE)));
            int n = 1;
            return n;
        }
        finally {
            if (null != pw) {
                pw.close();
            }
            if (null != rs) {
                try {
                    rs.close();
                }
                catch (SQLException sqlE) {
                    LOG.warn((Object)("SQL exception closing ResultSet: " + StringUtils.stringifyException((Throwable)sqlE)));
                }
            }
            if (null != stmt) {
                try {
                    stmt.close();
                }
                catch (SQLException sqlE) {
                    LOG.warn((Object)("SQL exception closing statement: " + StringUtils.stringifyException((Throwable)sqlE)));
                }
            }
            this.destroy(options);
        }
        return 0;
    }

    @Override
    public void configureOptions(ToolOptions toolOptions) {
        toolOptions.addUniqueOptions(this.getCommonOptions());
        RelatedOptions evalOpts = new RelatedOptions("SQL evaluation arguments");
        OptionBuilder.withArgName((String)"statement");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Execute 'statement' in SQL and exit");
        OptionBuilder.withLongOpt((String)"query");
        evalOpts.addOption(OptionBuilder.create((String)"e"));
        toolOptions.addUniqueOptions(evalOpts);
    }

    @Override
    public void applyOptions(CommandLine in, SqoopOptions out) throws SqoopOptions.InvalidOptionsException {
        this.applyCommonOptions(in, out);
        if (in.hasOption("query")) {
            out.setSqlQuery(in.getOptionValue("query"));
        }
    }

    @Override
    public void validateOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
        if (this.hasUnrecognizedArgs(this.extraArguments)) {
            throw new SqoopOptions.InvalidOptionsException("\nTry --help for usage instructions.");
        }
        String sqlCmd = options.getSqlQuery();
        if (null == sqlCmd || sqlCmd.length() == 0) {
            throw new SqoopOptions.InvalidOptionsException("This command requires the query argument.\nTry --help for usage instructions.");
        }
        this.validateCommonOptions(options);
    }
}

