/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.tool;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.cli.SqoopParser;
import com.cloudera.sqoop.cli.ToolOptions;
import com.cloudera.sqoop.config.ConfigurationHelper;
import com.cloudera.sqoop.tool.CodeGenTool;
import com.cloudera.sqoop.tool.CreateHiveTableTool;
import com.cloudera.sqoop.tool.EvalSqlTool;
import com.cloudera.sqoop.tool.ExportTool;
import com.cloudera.sqoop.tool.HelpTool;
import com.cloudera.sqoop.tool.ImportAllTablesTool;
import com.cloudera.sqoop.tool.ImportTool;
import com.cloudera.sqoop.tool.JobTool;
import com.cloudera.sqoop.tool.ListDatabasesTool;
import com.cloudera.sqoop.tool.ListTablesTool;
import com.cloudera.sqoop.tool.MergeTool;
import com.cloudera.sqoop.tool.MetastoreTool;
import com.cloudera.sqoop.tool.ToolDesc;
import com.cloudera.sqoop.tool.ToolPlugin;
import com.cloudera.sqoop.tool.VersionTool;
import com.cloudera.sqoop.util.ClassLoaderStack;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.ToolRunner;

public abstract class SqoopTool {
    public static final Log LOG = LogFactory.getLog((String)SqoopTool.class.getName());
    public static final String TOOL_PLUGINS_KEY = "sqoop.tool.plugins";
    private static final Map<String, Class<? extends SqoopTool>> TOOLS = new TreeMap<String, Class<? extends SqoopTool>>();
    private static final Map<String, String> DESCRIPTIONS = new TreeMap<String, String>();
    private String toolName;
    protected String[] extraArguments;

    private static void registerTool(String toolName, Class<? extends SqoopTool> cls, String description) {
        Class<? extends SqoopTool> existing = TOOLS.get(toolName);
        if (null != existing) {
            throw new RuntimeException("A plugin is attempting to register a tool with name " + toolName + ", but this tool already exists (" + existing.getName() + ")");
        }
        TOOLS.put(toolName, cls);
        DESCRIPTIONS.put(toolName, description);
    }

    private static void registerTool(ToolDesc toolDescription) {
        SqoopTool.registerTool(toolDescription.getName(), toolDescription.getToolClass(), toolDescription.getDesc());
    }

    public static Configuration loadPlugins(Configuration conf) {
        conf = SqoopTool.loadPluginsFromConfDir(conf);
        List plugins = conf.getInstances(TOOL_PLUGINS_KEY, ToolPlugin.class);
        for (ToolPlugin plugin : plugins) {
            LOG.debug((Object)("Loading plugin: " + plugin.getClass().getName()));
            List<ToolDesc> descriptions = plugin.getTools();
            for (ToolDesc desc : descriptions) {
                LOG.debug((Object)("  Adding tool: " + desc.getName() + " -> " + desc.getToolClass().getName()));
                SqoopTool.registerTool(desc);
            }
        }
        return conf;
    }

    private static Configuration loadPluginsFromConfDir(Configuration conf) {
        if (conf.get(TOOL_PLUGINS_KEY) != null) {
            LOG.debug((Object)"sqoop.tool.plugins is set; ignoring tools.d");
            return conf;
        }
        String confDirName = System.getenv("SQOOP_CONF_DIR");
        if (null == confDirName) {
            LOG.warn((Object)"$SQOOP_CONF_DIR has not been set in the environment. Cannot check for additional configuration.");
            return conf;
        }
        File confDir = new File(confDirName);
        File toolsDir = new File(confDir, "tools.d");
        if (toolsDir.exists() && toolsDir.isDirectory()) {
            Object[] fileNames = toolsDir.list();
            Arrays.sort(fileNames);
            for (Object fileName : fileNames) {
                File f = new File(toolsDir, (String)fileName);
                if (!f.isFile()) continue;
                SqoopTool.loadPluginsFromFile(conf, f);
            }
        }
        conf.setClassLoader(Thread.currentThread().getContextClassLoader());
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPluginsFromFile(Configuration conf, File f) {
        InputStreamReader r = null;
        try {
            r = new InputStreamReader(new FileInputStream(f));
            Properties props = new Properties();
            props.load(r);
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String plugin = entry.getKey().toString();
                SqoopTool.addPlugin(conf, plugin);
                String jarName = entry.getValue().toString();
                if (jarName.length() > 0) {
                    ClassLoaderStack.addJarFile(jarName, plugin);
                    LOG.debug((Object)("Added plugin " + plugin + " in jar " + jarName + " specified by " + f));
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Added plugin " + plugin + " specified by " + f));
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)("Error loading ToolPlugin information from file " + f + ": " + StringUtils.stringifyException((Throwable)ioe)));
        }
        finally {
            if (null != r) {
                try {
                    ((Reader)r).close();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("Error closing file " + f + ": " + ioe));
                }
            }
        }
    }

    private static void addPlugin(Configuration conf, String pluginName) {
        String existingPlugins = conf.get(TOOL_PLUGINS_KEY);
        String newPlugins = null;
        newPlugins = null == existingPlugins || existingPlugins.length() == 0 ? pluginName : existingPlugins + "," + pluginName;
        conf.set(TOOL_PLUGINS_KEY, newPlugins);
    }

    public static final Set<String> getToolNames() {
        return TOOLS.keySet();
    }

    public static final SqoopTool getTool(String toolName) {
        Class<? extends SqoopTool> cls = TOOLS.get(toolName);
        try {
            if (null != cls) {
                SqoopTool tool = cls.newInstance();
                tool.setToolName(toolName);
                return tool;
            }
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            return null;
        }
        return null;
    }

    public static final String getToolDescription(String toolName) {
        return DESCRIPTIONS.get(toolName);
    }

    public SqoopTool() {
        this.toolName = "<" + this.getClass().getName() + ">";
    }

    public SqoopTool(String name) {
        this.toolName = name;
    }

    public String getToolName() {
        return this.toolName;
    }

    protected void setToolName(String name) {
        this.toolName = name;
    }

    public abstract int run(SqoopOptions var1);

    public void configureOptions(ToolOptions opts) {
    }

    public void printHelp(ToolOptions opts) {
        System.out.println("usage: sqoop " + this.getToolName() + " [GENERIC-ARGS] [TOOL-ARGS]");
        System.out.println("");
        opts.printHelp();
        System.out.println("");
        System.out.println("Generic Hadoop command-line arguments:");
        System.out.println("(must preceed any tool-specific arguments)");
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
    }

    public void applyOptions(CommandLine in, SqoopOptions out) throws SqoopOptions.InvalidOptionsException {
    }

    public void validateOptions(SqoopOptions options) throws SqoopOptions.InvalidOptionsException {
    }

    public SqoopOptions parseArguments(String[] args, Configuration conf, SqoopOptions in, boolean useGenericOptions) throws ParseException, SqoopOptions.InvalidOptionsException {
        SqoopOptions out = in;
        if (null == out) {
            out = new SqoopOptions();
        }
        if (null != conf) {
            out.setConf(conf);
        } else if (null == out.getConf()) {
            out.setConf(new Configuration());
        }
        out.setActiveSqoopTool(this);
        String[] toolArgs = args;
        if (useGenericOptions) {
            try {
                toolArgs = ConfigurationHelper.parseGenericOptions(out.getConf(), args);
            }
            catch (IOException ioe) {
                ParseException pe = new ParseException("Could not parse generic arguments");
                pe.initCause((Throwable)ioe);
                throw pe;
            }
        }
        ToolOptions toolOptions = new ToolOptions();
        this.configureOptions(toolOptions);
        SqoopParser parser = new SqoopParser();
        CommandLine cmdLine = parser.parse(toolOptions.merge(), toolArgs, true);
        this.applyOptions(cmdLine, out);
        this.extraArguments = cmdLine.getArgs();
        return out;
    }

    public void appendArgs(String[] extra) {
        int existingLen = this.extraArguments == null ? 0 : this.extraArguments.length;
        int newLen = extra == null ? 0 : extra.length;
        String[] newExtra = new String[existingLen + newLen];
        if (null != this.extraArguments) {
            System.arraycopy(this.extraArguments, 0, newExtra, 0, existingLen);
        }
        if (null != extra) {
            System.arraycopy(extra, 0, newExtra, existingLen, newLen);
        }
        this.extraArguments = newExtra;
    }

    public List<String> getDependencyJars() {
        return Collections.emptyList();
    }

    protected void loadDependencyJars(SqoopOptions options) throws IOException {
        List<String> deps = this.getDependencyJars();
        if (null == deps) {
            return;
        }
        for (String depFilename : deps) {
            LOG.debug((Object)("Loading dependency: " + depFilename));
            ClassLoaderStack.addJarFile(depFilename, null);
        }
        options.getConf().setClassLoader(Thread.currentThread().getContextClassLoader());
    }

    public String toString() {
        return this.getToolName();
    }

    static {
        SqoopTool.registerTool("codegen", CodeGenTool.class, "Generate code to interact with database records");
        SqoopTool.registerTool("create-hive-table", CreateHiveTableTool.class, "Import a table definition into Hive");
        SqoopTool.registerTool("eval", EvalSqlTool.class, "Evaluate a SQL statement and display the results");
        SqoopTool.registerTool("export", ExportTool.class, "Export an HDFS directory to a database table");
        SqoopTool.registerTool("import", ImportTool.class, "Import a table from a database to HDFS");
        SqoopTool.registerTool("import-all-tables", ImportAllTablesTool.class, "Import tables from a database to HDFS");
        SqoopTool.registerTool("help", HelpTool.class, "List available commands");
        SqoopTool.registerTool("list-databases", ListDatabasesTool.class, "List available databases on a server");
        SqoopTool.registerTool("list-tables", ListTablesTool.class, "List available tables in a database");
        SqoopTool.registerTool("merge", MergeTool.class, "Merge results of incremental imports");
        SqoopTool.registerTool("metastore", MetastoreTool.class, "Run a standalone Sqoop metastore");
        SqoopTool.registerTool("job", JobTool.class, "Work with saved jobs");
        SqoopTool.registerTool("version", VersionTool.class, "Display version information");
    }
}

