/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class FileListing {
    private FileListing() {
    }

    public static void main(String ... aArgs) throws FileNotFoundException {
        File startingDirectory = new File(aArgs[0]);
        List<File> files = FileListing.getFileListing(startingDirectory);
        for (File file : files) {
            System.out.println(file);
        }
    }

    public static List<File> getFileListing(File aStartingDir) throws FileNotFoundException {
        FileListing.validateDirectory(aStartingDir);
        List<File> result = FileListing.getFileListingNoSort(aStartingDir);
        Collections.sort(result);
        return result;
    }

    private static List<File> getFileListingNoSort(File aStartingDir) throws FileNotFoundException {
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = aStartingDir.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        for (File file : filesDirs) {
            result.add(file);
            if (file.isFile()) continue;
            List<File> deeperList = FileListing.getFileListingNoSort(file);
            result.addAll(deeperList);
        }
        return result;
    }

    private static void validateDirectory(File aDirectory) throws FileNotFoundException {
        if (aDirectory == null) {
            throw new IllegalArgumentException("Directory should not be null.");
        }
        if (!aDirectory.exists()) {
            throw new FileNotFoundException("Directory does not exist: " + aDirectory);
        }
        if (!aDirectory.isDirectory()) {
            throw new IllegalArgumentException("Is not a directory: " + aDirectory);
        }
        if (!aDirectory.canRead()) {
            throw new IllegalArgumentException("Directory cannot be read: " + aDirectory);
        }
    }

    public static void recursiveDeleteDir(File dir) throws IOException {
        if (!dir.exists()) {
            throw new FileNotFoundException(dir.toString() + " does not exist");
        }
        if (dir.isDirectory()) {
            File[] children;
            for (File child : children = dir.listFiles()) {
                FileListing.recursiveDeleteDir(child);
            }
        }
        if (!dir.delete()) {
            throw new IOException("Could not remove: " + dir);
        }
    }
}

