/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.cassandra.cql.jdbc.AbstractJdbcUUID;
import org.apache.cassandra.cql.jdbc.MarshalException;
import org.apache.cassandra.utils.UUIDGen;

public class JdbcLexicalUUID
extends AbstractJdbcUUID {
    public static final JdbcLexicalUUID instance = new JdbcLexicalUUID();

    @Override
    public String getString(ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return "";
        }
        if (bytes.remaining() != 16) {
            throw new MarshalException("UUIDs must be exactly 16 bytes");
        }
        return UUIDGen.getUUID(bytes).toString();
    }

    @Override
    public UUID compose(ByteBuffer bytes) {
        return UUIDGen.getUUID(bytes);
    }
}

