/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.utils.FBUtilities;

class CounterMutationSerializer
implements IVersionedSerializer<CounterMutation> {
    CounterMutationSerializer() {
    }

    @Override
    public void serialize(CounterMutation cm, DataOutput dos, int version) throws IOException {
        RowMutation.serializer().serialize(cm.rowMutation(), dos, version);
        dos.writeUTF(cm.consistency().name());
    }

    @Override
    public CounterMutation deserialize(DataInput dis, int version) throws IOException {
        RowMutation rm = RowMutation.serializer().deserialize(dis, version);
        ConsistencyLevel consistency = Enum.valueOf(ConsistencyLevel.class, dis.readUTF());
        return new CounterMutation(rm, consistency);
    }

    @Override
    public long serializedSize(CounterMutation cm, int version) {
        return RowMutation.serializer().serializedSize(cm.rowMutation(), version) + 2L + (long)FBUtilities.encodedUTF8Length(cm.consistency().name());
    }
}

