/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;

class SliceFromReadCommandSerializer
implements IVersionedSerializer<ReadCommand> {
    SliceFromReadCommandSerializer() {
    }

    @Override
    public void serialize(ReadCommand rm, DataOutput dos, int version) throws IOException {
        SliceFromReadCommand realRM = (SliceFromReadCommand)rm;
        dos.writeBoolean(realRM.isDigestQuery());
        dos.writeUTF(realRM.table);
        ByteBufferUtil.writeWithShortLength(realRM.key, dos);
        realRM.queryPath.serialize(dos);
        ByteBufferUtil.writeWithShortLength(realRM.start, dos);
        ByteBufferUtil.writeWithShortLength(realRM.finish, dos);
        dos.writeBoolean(realRM.reversed);
        dos.writeInt(realRM.count);
    }

    @Override
    public ReadCommand deserialize(DataInput dis, int version) throws IOException {
        boolean isDigest = dis.readBoolean();
        SliceFromReadCommand rm = new SliceFromReadCommand(dis.readUTF(), ByteBufferUtil.readWithShortLength(dis), QueryPath.deserialize(dis), ByteBufferUtil.readWithShortLength(dis), ByteBufferUtil.readWithShortLength(dis), dis.readBoolean(), dis.readInt());
        rm.setDigestQuery(isDigest);
        return rm;
    }

    @Override
    public long serializedSize(ReadCommand cmd, int version) {
        SliceFromReadCommand command = (SliceFromReadCommand)cmd;
        int size = 1;
        size += 2 + FBUtilities.encodedUTF8Length(command.table);
        size += 2 + command.key.remaining();
        size += command.queryPath.serializedSize();
        size += 2 + command.start.remaining();
        size += 2 + command.finish.remaining();
        ++size;
        return size += 4;
    }
}

