/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.FastByteArrayOutputStream;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.utils.FBUtilities;

public class TruncateResponse {
    private static TruncateResponseSerializer serializer_ = new TruncateResponseSerializer();
    public final String keyspace;
    public final String columnFamily;
    public final boolean success;

    public static TruncateResponseSerializer serializer() {
        return serializer_;
    }

    public static Message makeTruncateResponseMessage(Message original, TruncateResponse truncateResponseMessage) throws IOException {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        TruncateResponse.serializer().serialize(truncateResponseMessage, (DataOutput)dos, original.getVersion());
        return original.getReply(FBUtilities.getBroadcastAddress(), bos.toByteArray(), original.getVersion());
    }

    public TruncateResponse(String keyspace, String columnFamily, boolean success) {
        this.keyspace = keyspace;
        this.columnFamily = columnFamily;
        this.success = success;
    }

    public static class TruncateResponseSerializer
    implements IVersionedSerializer<TruncateResponse> {
        @Override
        public void serialize(TruncateResponse tr, DataOutput dos, int version) throws IOException {
            dos.writeUTF(tr.keyspace);
            dos.writeUTF(tr.columnFamily);
            dos.writeBoolean(tr.success);
        }

        @Override
        public TruncateResponse deserialize(DataInput dis, int version) throws IOException {
            String keyspace = dis.readUTF();
            String columnFamily = dis.readUTF();
            boolean success = dis.readBoolean();
            return new TruncateResponse(keyspace, columnFamily, success);
        }

        @Override
        public long serializedSize(TruncateResponse truncateResponse, int version) {
            throw new UnsupportedOperationException();
        }
    }
}

