/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableScanner;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.Throttle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompactionIterable
implements Iterable<AbstractCompactedRow>,
CompactionInfo.Holder {
    private static Logger logger = LoggerFactory.getLogger(AbstractCompactionIterable.class);
    protected final OperationType type;
    protected final CompactionController controller;
    protected long totalBytes;
    protected volatile long bytesRead;
    protected final Throttle throttle;

    public AbstractCompactionIterable(CompactionController controller, OperationType type) {
        this.controller = controller;
        this.type = type;
        this.throttle = new Throttle(this.toString(), new Throttle.ThroughputFunction(){

            @Override
            public int targetThroughput() {
                if (DatabaseDescriptor.getCompactionThroughputMbPerSec() < 1 || StorageService.instance.isBootstrapMode()) {
                    return 0;
                }
                int totalBytesPerMS = DatabaseDescriptor.getCompactionThroughputMbPerSec() * 1024 * 1024 / 1000;
                return totalBytesPerMS / Math.max(1, CompactionManager.instance.getActiveCompactions());
            }
        });
    }

    protected static List<SSTableScanner> getScanners(Iterable<SSTableReader> sstables) throws IOException {
        ArrayList<SSTableScanner> scanners = new ArrayList<SSTableScanner>();
        for (SSTableReader sstable : sstables) {
            scanners.add(sstable.getDirectScanner());
        }
        return scanners;
    }

    @Override
    public CompactionInfo getCompactionInfo() {
        return new CompactionInfo(this.hashCode(), this.controller.getKeyspace(), this.controller.getColumnFamily(), this.type, this.bytesRead, this.totalBytes);
    }

    @Override
    public abstract CloseableIterator<AbstractCompactedRow> iterator();
}

