/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.locator.Ec2Snitch;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;

public class Ec2MultiRegionSnitch
extends Ec2Snitch
implements IEndpointStateChangeSubscriber {
    private static final String PUBLIC_IP_QUERY_URL = "http://169.254.169.254/latest/meta-data/public-ipv4";
    private static final String PRIVATE_IP_QUERY_URL = "http://169.254.169.254/latest/meta-data/local-ipv4";
    private final InetAddress public_ip = InetAddress.getByName(this.awsApiCall("http://169.254.169.254/latest/meta-data/public-ipv4"));
    private final String private_ip;

    public Ec2MultiRegionSnitch() throws IOException, ConfigurationException {
        logger.info("EC2Snitch using publicIP as identifier: " + this.public_ip);
        this.private_ip = this.awsApiCall(PRIVATE_IP_QUERY_URL);
        DatabaseDescriptor.setBroadcastAddress(this.public_ip);
    }

    @Override
    public void onJoin(InetAddress endpoint, EndpointState epState) {
        if (epState.getApplicationState(ApplicationState.INTERNAL_IP) != null) {
            this.reConnect(endpoint, epState.getApplicationState(ApplicationState.INTERNAL_IP));
        }
    }

    @Override
    public void onChange(InetAddress endpoint, ApplicationState state, VersionedValue value) {
        if (state == ApplicationState.INTERNAL_IP) {
            this.reConnect(endpoint, value);
        }
    }

    @Override
    public void onAlive(InetAddress endpoint, EndpointState state) {
        if (state.getApplicationState(ApplicationState.INTERNAL_IP) != null) {
            this.reConnect(endpoint, state.getApplicationState(ApplicationState.INTERNAL_IP));
        }
    }

    @Override
    public void onDead(InetAddress endpoint, EndpointState state) {
    }

    @Override
    public void onRestart(InetAddress endpoint, EndpointState state) {
    }

    @Override
    public void onRemove(InetAddress endpoint) {
    }

    private void reConnect(InetAddress endpoint, VersionedValue versionedValue) {
        if (!this.getDatacenter(endpoint).equals(this.getDatacenter(this.public_ip))) {
            return;
        }
        try {
            InetAddress remoteIP = InetAddress.getByName(versionedValue.value);
            MessagingService.instance().getConnectionPool(endpoint).reset(remoteIP);
            logger.debug(String.format("Intiated reconnect to an Internal IP %s for the %s", remoteIP, endpoint));
        }
        catch (UnknownHostException e) {
            logger.error("Error in getting the IP address resolved: ", (Throwable)e);
        }
    }

    @Override
    public void gossiperStarting() {
        super.gossiperStarting();
        Gossiper.instance.addLocalApplicationState(ApplicationState.INTERNAL_IP, StorageService.instance.valueFactory.internalIP(this.private_ip));
        Gossiper.instance.register(this);
    }
}

