/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.security;

import com.google.common.collect.Sets;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SSLFactory {
    private static final Logger logger_ = LoggerFactory.getLogger(SSLFactory.class);

    public static SSLServerSocket getServerSocket(EncryptionOptions options, InetAddress address, int port) throws IOException {
        SSLContext ctx = SSLFactory.createSSLContext(options);
        SSLServerSocket serverSocket = (SSLServerSocket)ctx.getServerSocketFactory().createServerSocket();
        serverSocket.setReuseAddress(true);
        String[] suits = SSLFactory.filterCipherSuites(serverSocket.getSupportedCipherSuites(), options.cipher_suites);
        serverSocket.setEnabledCipherSuites(suits);
        serverSocket.bind(new InetSocketAddress(address, port), 100);
        return serverSocket;
    }

    public static SSLSocket getSocket(EncryptionOptions options, InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLContext ctx = SSLFactory.createSSLContext(options);
        SSLSocket socket = (SSLSocket)ctx.getSocketFactory().createSocket(address, port, localAddress, localPort);
        String[] suits = SSLFactory.filterCipherSuites(socket.getSupportedCipherSuites(), options.cipher_suites);
        socket.setEnabledCipherSuites(suits);
        return socket;
    }

    public static SSLSocket getSocket(EncryptionOptions options) throws IOException {
        SSLContext ctx = SSLFactory.createSSLContext(options);
        SSLSocket socket = (SSLSocket)ctx.getSocketFactory().createSocket();
        String[] suits = SSLFactory.filterCipherSuites(socket.getSupportedCipherSuites(), options.cipher_suites);
        socket.setEnabledCipherSuites(suits);
        return socket;
    }

    private static SSLContext createSSLContext(EncryptionOptions options) throws IOException {
        SSLContext ctx;
        FileInputStream tsf = new FileInputStream(options.truststore);
        FileInputStream ksf = new FileInputStream(options.keystore);
        try {
            ctx = SSLContext.getInstance(options.protocol);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(options.algorithm);
            KeyStore ts = KeyStore.getInstance(options.store_type);
            ts.load(tsf, options.truststore_password.toCharArray());
            tmf.init(ts);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(options.algorithm);
            KeyStore ks = KeyStore.getInstance(options.store_type);
            ks.load(ksf, options.keystore_password.toCharArray());
            kmf.init(ks, options.keystore_password.toCharArray());
            ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        }
        catch (Exception e) {
            throw new IOException("Error creating the initializing the SSL Context", e);
        }
        finally {
            FileUtils.closeQuietly(tsf);
            FileUtils.closeQuietly(ksf);
        }
        return ctx;
    }

    private static String[] filterCipherSuites(String[] supported, String[] desired) {
        HashSet des = Sets.newHashSet((Object[])desired);
        Sets.SetView return_ = Sets.intersection((Set)Sets.newHashSet((Object[])supported), (Set)des);
        if (des.size() > return_.size()) {
            logger_.warn("Filtering out {} as it isnt supported by the socket", (Object)StringUtils.join((Collection)Sets.difference((Set)des, (Set)return_), (String)","));
        }
        return return_.toArray(new String[return_.size()]);
    }
}

