/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.impl.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.CloudFrontServiceException;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.model.cloudfront.Distribution;
import org.jets3t.service.model.cloudfront.DistributionConfig;
import org.jets3t.service.model.cloudfront.LoggingStatus;
import org.jets3t.service.model.cloudfront.OriginAccessIdentity;
import org.jets3t.service.model.cloudfront.OriginAccessIdentityConfig;
import org.jets3t.service.model.cloudfront.StreamingDistribution;
import org.jets3t.service.model.cloudfront.StreamingDistributionConfig;
import org.jets3t.service.utils.ServiceUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class CloudFrontXmlResponsesSaxParser {
    private static final Log log = LogFactory.getLog((Class)CloudFrontXmlResponsesSaxParser.class);
    private XMLReader xr = null;
    private Jets3tProperties properties = null;
    static /* synthetic */ Class class$java$lang$String;

    public CloudFrontXmlResponsesSaxParser(Jets3tProperties properties) throws S3ServiceException {
        this.properties = properties;
        this.xr = ServiceUtils.loadXMLReader();
    }

    protected void parseXmlInputStream(DefaultHandler handler, InputStream inputStream) throws CloudFrontServiceException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing XML response document with handler: " + handler.getClass()));
            }
            BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, Constants.DEFAULT_ENCODING));
            this.xr.setContentHandler(handler);
            this.xr.setErrorHandler(handler);
            this.xr.parse(new InputSource(breader));
        }
        catch (Throwable t) {
            block5: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error((Object)"Unable to close response InputStream up after XML parse failure", (Throwable)e);
                }
            }
            throw new CloudFrontServiceException("Failed to parse XML document with handler " + handler.getClass(), t);
        }
    }

    public ListDistributionListHandler parseDistributionListResponse(InputStream inputStream) throws CloudFrontServiceException {
        ListDistributionListHandler handler = new ListDistributionListHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public DistributionHandler parseDistributionResponse(InputStream inputStream) throws CloudFrontServiceException {
        DistributionHandler handler = new DistributionHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public DistributionConfigHandler parseDistributionConfigResponse(InputStream inputStream) throws CloudFrontServiceException {
        DistributionConfigHandler handler = new DistributionConfigHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public OriginAccessIdentityHandler parseOriginAccessIdentity(InputStream inputStream) throws CloudFrontServiceException {
        OriginAccessIdentityHandler handler = new OriginAccessIdentityHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public OriginAccessIdentityConfigHandler parseOriginAccessIdentityConfig(InputStream inputStream) throws CloudFrontServiceException {
        OriginAccessIdentityConfigHandler handler = new OriginAccessIdentityConfigHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public OriginAccessIdentityListHandler parseOriginAccessIdentityListResponse(InputStream inputStream) throws CloudFrontServiceException {
        OriginAccessIdentityListHandler handler = new OriginAccessIdentityListHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public ErrorHandler parseErrorResponse(InputStream inputStream) throws CloudFrontServiceException {
        ErrorHandler handler = new ErrorHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public class ErrorHandler
    extends SimpleHandler {
        private String type;
        private String code;
        private String message;
        private String detail;
        private String requestId;

        public ErrorHandler() {
            this.type = null;
            this.code = null;
            this.message = null;
            this.detail = null;
            this.requestId = null;
        }

        public String getCode() {
            return this.code;
        }

        public String getDetail() {
            return this.detail;
        }

        public String getMessage() {
            return this.message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public String getType() {
            return this.type;
        }

        public void endType(String text) {
            this.type = text;
        }

        public void endCode(String text) {
            this.code = text;
        }

        public void endMessage(String text) {
            this.message = text;
        }

        public void endDetail(String text) {
            this.detail = text;
        }

        public void endRequestId(String text) {
            this.requestId = text;
        }

        public void endRequestID(String text) {
            this.requestId = text;
        }
    }

    public class OriginAccessIdentityListHandler
    extends SimpleHandler {
        private List originAccessIdentityList;
        private String marker;
        private String nextMarker;
        private int maxItems;
        private boolean isTruncated;

        public OriginAccessIdentityListHandler() {
            this.originAccessIdentityList = new ArrayList();
            this.marker = null;
            this.nextMarker = null;
            this.maxItems = 100;
            this.isTruncated = false;
        }

        public List getOriginAccessIdentityList() {
            return this.originAccessIdentityList;
        }

        public boolean isTruncated() {
            return this.isTruncated;
        }

        public String getMarker() {
            return this.marker;
        }

        public String getNextMarker() {
            return this.nextMarker;
        }

        public int getMaxItems() {
            return this.maxItems;
        }

        public void startCloudFrontOriginAccessIdentitySummary() {
            this.transferControlToHandler(new OriginAccessIdentityHandler());
        }

        public void controlReturned(SimpleHandler childHandler) {
            this.originAccessIdentityList.add(((OriginAccessIdentityHandler)childHandler).getOriginAccessIdentity());
        }

        public void endMarker(String text) {
            this.marker = text;
        }

        public void endNextMarker(String text) {
            this.nextMarker = text;
        }

        public void endMaxItems(String text) {
            this.maxItems = Integer.parseInt(text);
        }

        public void endIsTruncated(String text) {
            this.isTruncated = "true".equalsIgnoreCase(text);
        }
    }

    public class OriginAccessIdentityConfigHandler
    extends SimpleHandler {
        private String callerReference;
        private String comment;
        private OriginAccessIdentityConfig config;

        public OriginAccessIdentityConfigHandler() {
            this.callerReference = null;
            this.comment = null;
            this.config = null;
        }

        public OriginAccessIdentityConfig getOriginAccessIdentityConfig() {
            return this.config;
        }

        public void endCallerReference(String text) {
            this.callerReference = text;
        }

        public void endComment(String text) {
            this.comment = text;
        }

        public void endCloudFrontOriginAccessIdentityConfig(String text) {
            this.config = new OriginAccessIdentityConfig(this.callerReference, this.comment);
            this.returnControlToParentHandler();
        }
    }

    public class OriginAccessIdentityHandler
    extends SimpleHandler {
        private String id;
        private String s3CanonicalUserId;
        private String comment;
        private OriginAccessIdentity originAccessIdentity;
        private OriginAccessIdentityConfig originAccessIdentityConfig;

        public OriginAccessIdentityHandler() {
            this.id = null;
            this.s3CanonicalUserId = null;
            this.comment = null;
            this.originAccessIdentity = null;
            this.originAccessIdentityConfig = null;
        }

        public OriginAccessIdentity getOriginAccessIdentity() {
            return this.originAccessIdentity;
        }

        public void endId(String text) {
            this.id = text;
        }

        public void endS3CanonicalUserId(String text) {
            this.s3CanonicalUserId = text;
        }

        public void endComment(String text) {
            this.comment = text;
        }

        public void startCloudFrontOriginAccessIdentityConfig() {
            this.transferControlToHandler(new OriginAccessIdentityConfigHandler());
        }

        public void controlReturned(SimpleHandler childHandler) {
            this.originAccessIdentityConfig = ((OriginAccessIdentityConfigHandler)childHandler).getOriginAccessIdentityConfig();
        }

        public void endCloudFrontOriginAccessIdentity(String text) {
            this.originAccessIdentity = new OriginAccessIdentity(this.id, this.s3CanonicalUserId, this.originAccessIdentityConfig);
        }

        public void endCloudFrontOriginAccessIdentitySummary(String text) {
            this.originAccessIdentity = new OriginAccessIdentity(this.id, this.s3CanonicalUserId, this.comment);
            this.returnControlToParentHandler();
        }
    }

    public class ListDistributionListHandler
    extends SimpleHandler {
        private List distributions;
        private List cnamesList;
        private String marker;
        private String nextMarker;
        private int maxItems;
        private boolean isTruncated;

        public ListDistributionListHandler() {
            this.distributions = new ArrayList();
            this.cnamesList = new ArrayList();
            this.marker = null;
            this.nextMarker = null;
            this.maxItems = 100;
            this.isTruncated = false;
        }

        public List getDistributions() {
            return this.distributions;
        }

        public boolean isTruncated() {
            return this.isTruncated;
        }

        public String getMarker() {
            return this.marker;
        }

        public String getNextMarker() {
            return this.nextMarker;
        }

        public int getMaxItems() {
            return this.maxItems;
        }

        public void startDistributionSummary() {
            this.transferControlToHandler(new DistributionSummaryHandler());
        }

        public void startStreamingDistributionSummary() {
            this.transferControlToHandler(new DistributionSummaryHandler());
        }

        public void controlReturned(SimpleHandler childHandler) {
            this.distributions.add(((DistributionSummaryHandler)childHandler).getDistribution());
        }

        public void endCNAME(String text) {
            this.cnamesList.add(text);
        }

        public void endMarker(String text) {
            this.marker = text;
        }

        public void endNextMarker(String text) {
            this.nextMarker = text;
        }

        public void endMaxItems(String text) {
            this.maxItems = Integer.parseInt(text);
        }

        public void endIsTruncated(String text) {
            this.isTruncated = "true".equalsIgnoreCase(text);
        }
    }

    public class DistributionSummaryHandler
    extends SimpleHandler {
        private Distribution distribution;
        private String id;
        private String status;
        private Date lastModifiedTime;
        private String domainName;
        private String origin;
        private List cnamesList;
        private String comment;
        private boolean enabled;

        public DistributionSummaryHandler() {
            this.distribution = null;
            this.id = null;
            this.status = null;
            this.lastModifiedTime = null;
            this.domainName = null;
            this.origin = null;
            this.cnamesList = new ArrayList();
            this.comment = null;
            this.enabled = false;
        }

        public Distribution getDistribution() {
            return this.distribution;
        }

        public void endId(String text) {
            this.id = text;
        }

        public void endStatus(String text) {
            this.status = text;
        }

        public void endLastModifiedTime(String text) throws ParseException {
            this.lastModifiedTime = ServiceUtils.parseIso8601Date(text);
        }

        public void endDomainName(String text) {
            this.domainName = text;
        }

        public void endOrigin(String text) {
            this.origin = text;
        }

        public void endCNAME(String text) {
            this.cnamesList.add(text);
        }

        public void endComment(String text) {
            this.comment = text;
        }

        public void endEnabled(String text) {
            this.enabled = "true".equalsIgnoreCase(text);
        }

        public void endDistributionSummary(String text) {
            this.distribution = new Distribution(this.id, this.status, this.lastModifiedTime, this.domainName, this.origin, this.cnamesList.toArray(new String[this.cnamesList.size()]), this.comment, this.enabled);
            this.returnControlToParentHandler();
        }

        public void endStreamingDistributionSummary(String text) {
            this.distribution = new StreamingDistribution(this.id, this.status, this.lastModifiedTime, this.domainName, this.origin, this.cnamesList.toArray(new String[this.cnamesList.size()]), this.comment, this.enabled);
            this.returnControlToParentHandler();
        }
    }

    public class DistributionConfigHandler
    extends SimpleHandler {
        private DistributionConfig distributionConfig;
        private String origin;
        private String callerReference;
        private List cnamesList;
        private String comment;
        private boolean enabled;
        private LoggingStatus loggingStatus;
        private String originAccessIdentity;
        private boolean trustedSignerSelf;
        private List trustedSignerAwsAccountNumberList;
        private List requiredProtocols;

        public DistributionConfigHandler() {
            this.distributionConfig = null;
            this.origin = "";
            this.callerReference = "";
            this.cnamesList = new ArrayList();
            this.comment = "";
            this.enabled = false;
            this.loggingStatus = null;
            this.originAccessIdentity = null;
            this.trustedSignerSelf = false;
            this.trustedSignerAwsAccountNumberList = new ArrayList();
            this.requiredProtocols = new ArrayList();
        }

        public DistributionConfig getDistributionConfig() {
            return this.distributionConfig;
        }

        public void endOrigin(String text) {
            this.origin = text;
        }

        public void endCallerReference(String text) {
            this.callerReference = text;
        }

        public void endCNAME(String text) {
            this.cnamesList.add(text);
        }

        public void endComment(String text) {
            this.comment = text;
        }

        public void endEnabled(String text) {
            this.enabled = "true".equalsIgnoreCase(text);
        }

        public void startLogging() {
            this.loggingStatus = new LoggingStatus();
        }

        public void endBucket(String text) {
            this.loggingStatus.setBucket(text);
        }

        public void endPrefix(String text) {
            this.loggingStatus.setPrefix(text);
        }

        public void endOriginAccessIdentity(String text) {
            this.originAccessIdentity = text;
        }

        public void endSelf(String text) {
            this.trustedSignerSelf = true;
        }

        public void endAwsAccountNumber(String text) {
            this.trustedSignerAwsAccountNumberList.add(text);
        }

        public void endProtocol(String text) {
            this.requiredProtocols.add(text);
        }

        public void endDistributionConfig(String text) {
            this.distributionConfig = new DistributionConfig(this.origin, this.callerReference, this.cnamesList.toArray(new String[this.cnamesList.size()]), this.comment, this.enabled, this.loggingStatus, this.originAccessIdentity, this.trustedSignerSelf, this.trustedSignerAwsAccountNumberList.toArray(new String[this.trustedSignerAwsAccountNumberList.size()]), this.requiredProtocols.toArray(new String[this.requiredProtocols.size()]));
            this.returnControlToParentHandler();
        }

        public void endStreamingDistributionConfig(String text) {
            this.distributionConfig = new StreamingDistributionConfig(this.origin, this.callerReference, this.cnamesList.toArray(new String[this.cnamesList.size()]), this.comment, this.enabled, this.loggingStatus, this.originAccessIdentity, this.trustedSignerSelf, this.trustedSignerAwsAccountNumberList.toArray(new String[this.trustedSignerAwsAccountNumberList.size()]), this.requiredProtocols.toArray(new String[this.requiredProtocols.size()]));
            this.returnControlToParentHandler();
        }
    }

    public class DistributionHandler
    extends SimpleHandler {
        private Distribution distribution;
        private String id;
        private String status;
        private Date lastModifiedTime;
        private String domainName;
        private Map activeTrustedSigners;
        private boolean inSignerElement;
        private String lastSignerIdentifier;

        public DistributionHandler() {
            this.distribution = null;
            this.id = null;
            this.status = null;
            this.lastModifiedTime = null;
            this.domainName = null;
            this.activeTrustedSigners = new HashMap();
            this.lastSignerIdentifier = null;
        }

        public Distribution getDistribution() {
            return this.distribution;
        }

        public void endId(String text) {
            this.id = text;
        }

        public void endStatus(String text) {
            this.status = text;
        }

        public void endLastModifiedTime(String text) throws ParseException {
            this.lastModifiedTime = ServiceUtils.parseIso8601Date(text);
        }

        public void endDomainName(String text) {
            this.domainName = text;
        }

        public void startSigner() {
            this.inSignerElement = true;
        }

        public void endSigner(String text) {
            this.inSignerElement = false;
            this.lastSignerIdentifier = null;
        }

        public void endSelf(String text) {
            if (this.inSignerElement) {
                this.lastSignerIdentifier = "Self";
            }
        }

        public void endAwsAccountNumber(String text) {
            if (this.inSignerElement) {
                this.lastSignerIdentifier = text;
            }
        }

        public void endKeyPairId(String text) {
            if (this.inSignerElement) {
                ArrayList<String> keypairIdList = (ArrayList<String>)this.activeTrustedSigners.get(this.lastSignerIdentifier);
                if (keypairIdList == null) {
                    keypairIdList = new ArrayList<String>();
                    this.activeTrustedSigners.put(this.lastSignerIdentifier, keypairIdList);
                }
                keypairIdList.add(text);
            }
        }

        public void startDistributionConfig() {
            this.transferControlToHandler(new DistributionConfigHandler());
        }

        public void startStreamingDistributionConfig() {
            this.transferControlToHandler(new DistributionConfigHandler());
        }

        public void controlReturned(SimpleHandler childHandler) {
            DistributionConfig config = ((DistributionConfigHandler)childHandler).getDistributionConfig();
            this.distribution = config instanceof StreamingDistributionConfig ? new StreamingDistribution(this.id, this.status, this.lastModifiedTime, this.domainName, this.activeTrustedSigners, config) : new Distribution(this.id, this.status, this.lastModifiedTime, this.domainName, this.activeTrustedSigners, config);
        }

        public void endDistribution(String text) {
            this.returnControlToParentHandler();
        }

        public void endStreamingDistribution(String text) {
            this.returnControlToParentHandler();
        }
    }

    public class SimpleHandler
    extends DefaultHandler {
        private StringBuffer textContent = new StringBuffer();
        protected SimpleHandler currentHandler = this;
        protected SimpleHandler parentHandler = null;

        public void transferControlToHandler(SimpleHandler toHandler) {
            this.currentHandler = toHandler;
            toHandler.parentHandler = this;
        }

        public void returnControlToParentHandler() {
            if (this.isChildHandler()) {
                this.parentHandler.currentHandler = this.parentHandler;
                this.parentHandler.controlReturned(this);
            } else {
                log.debug((Object)("Ignoring call to return control to parent handler, as this class has no parent: " + this.getClass().getName()));
            }
        }

        public boolean isChildHandler() {
            return this.parentHandler != null;
        }

        public void controlReturned(SimpleHandler childHandler) {
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            try {
                Method method = this.currentHandler.getClass().getMethod("start" + name, new Class[0]);
                method.invoke((Object)this.currentHandler, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                log.debug((Object)("Skipped non-existent SimpleHandler subclass's startElement method for '" + name + "' in " + this.getClass().getName()));
            }
            catch (Throwable t) {
                log.error((Object)("Unable to invoke SimpleHandler subclass's startElement method for '" + name + "' in " + this.getClass().getName()), t);
            }
        }

        public void endElement(String uri, String name, String qName) {
            String elementText = this.textContent.toString().trim();
            try {
                Method method = this.currentHandler.getClass().getMethod("end" + name, class$java$lang$String == null ? (class$java$lang$String = CloudFrontXmlResponsesSaxParser.class$("java.lang.String")) : class$java$lang$String);
                method.invoke((Object)this.currentHandler, elementText);
            }
            catch (NoSuchMethodException e) {
                log.debug((Object)("Skipped non-existent SimpleHandler subclass's endElement method for '" + name + "' in " + this.getClass().getName()));
            }
            catch (Throwable t) {
                log.error((Object)("Unable to invoke SimpleHandler subclass's endElement method for '" + name + "' in " + this.getClass().getName()), t);
            }
            this.textContent = new StringBuffer();
        }

        public void characters(char[] ch, int start, int length) {
            this.textContent.append(ch, start, length);
        }
    }
}

