/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Transient;
import org.apache.hadoop.io.Writable;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.rest.JsonWorkflowAction;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.PropertiesUtils;
import org.apache.oozie.util.WritableUtils;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.jdbc.Index;

@Entity
@NamedQueries(value={@NamedQuery(name="UPDATE_ACTION", query="update WorkflowActionBean a set a.conf = :conf, a.consoleUrl = :consoleUrl, a.data = :data, a.errorCode = :errorCode, a.errorMessage = :errorMessage, a.externalId = :externalId, a.externalStatus = :externalStatus, a.name = :name, a.cred = :cred , a.retries = :retries, a.trackerUri = :trackerUri, a.transition = :transition, a.type = :type, a.endTimestamp = :endTime, a.executionPath = :executionPath, a.lastCheckTimestamp = :lastCheckTime, a.logToken = :logToken, a.pending = :pending, a.pendingAgeTimestamp = :pendingAge, a.signalValue = :signalValue, a.slaXml = :slaXml, a.startTimestamp = :startTime, a.status = :status, a.wfId=:wfId where a.id = :id"), @NamedQuery(name="DELETE_ACTION", query="delete from WorkflowActionBean a where a.id = :id"), @NamedQuery(name="DELETE_ACTIONS_FOR_WORKFLOW", query="delete from WorkflowActionBean a where a.wfId = :wfId"), @NamedQuery(name="GET_ACTIONS", query="select OBJECT(a) from WorkflowActionBean a"), @NamedQuery(name="GET_ACTION", query="select OBJECT(a) from WorkflowActionBean a where a.id = :id"), @NamedQuery(name="GET_ACTION_FOR_UPDATE", query="select OBJECT(a) from WorkflowActionBean a where a.id = :id"), @NamedQuery(name="GET_ACTIONS_FOR_WORKFLOW", query="select OBJECT(a) from WorkflowActionBean a where a.wfId = :wfId order by a.startTimestamp"), @NamedQuery(name="GET_ACTIONS_OF_WORKFLOW_FOR_UPDATE", query="select OBJECT(a) from WorkflowActionBean a where a.wfId = :wfId order by a.startTimestamp"), @NamedQuery(name="GET_PENDING_ACTIONS", query="select OBJECT(a) from WorkflowActionBean a where a.pending = 1 AND a.pendingAgeTimestamp < :pendingAge AND a.status <> 'RUNNING'"), @NamedQuery(name="GET_RUNNING_ACTIONS", query="select OBJECT(a) from WorkflowActionBean a where a.pending = 1 AND a.status = 'RUNNING' AND a.lastCheckTimestamp < :lastCheckTime"), @NamedQuery(name="GET_RETRY_MANUAL_ACTIONS", query="select OBJECT(a) from WorkflowActionBean a where a.wfId = :wfId AND (a.status = 'START_RETRY' OR a.status = 'START_MANUAL' OR a.status = 'END_RETRY' OR a.status = 'END_MANUAL')")})
public class WorkflowActionBean
extends JsonWorkflowAction
implements Writable,
PersistenceCapable {
    @Basic
    @Index
    @Column(name="wf_id")
    private String wfId = null;
    @Basic
    @Index
    @Column(name="status")
    private String status = WorkflowAction.Status.PREP.toString();
    @Basic
    @Column(name="last_check_time")
    private Timestamp lastCheckTimestamp;
    @Basic
    @Column(name="end_time")
    private Timestamp endTimestamp = null;
    @Basic
    @Column(name="start_time")
    private Timestamp startTimestamp = null;
    @Basic
    @Column(name="execution_path", length=1024)
    private String executionPath = null;
    @Basic
    @Column(name="pending")
    private int pending = 0;
    @Basic
    @Index
    @Column(name="pending_age")
    private Timestamp pendingAgeTimestamp = null;
    @Basic
    @Column(name="signal_value")
    private String signalValue = null;
    @Basic
    @Column(name="log_token")
    private String logToken = null;
    @Transient
    private Date pendingAge;
    @Column(name="sla_xml")
    @Lob
    private String slaXml = null;
    private static int pcInheritedFieldCount = JsonWorkflowAction.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$oozie$client$rest$JsonWorkflowAction;
    static /* synthetic */ Class class$Ljava$sql$Timestamp;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$oozie$WorkflowActionBean;

    public void write(DataOutput dataOutput) throws IOException {
        WritableUtils.writeStr(dataOutput, this.getId());
        WritableUtils.writeStr(dataOutput, this.getName());
        WritableUtils.writeStr(dataOutput, this.getCred());
        WritableUtils.writeStr(dataOutput, this.getType());
        WritableUtils.writeStr(dataOutput, this.getConf());
        WritableUtils.writeStr(dataOutput, this.getStatusStr());
        dataOutput.writeInt(this.getRetries());
        dataOutput.writeLong(this.getStartTime() != null ? this.getStartTime().getTime() : -1L);
        dataOutput.writeLong(this.getEndTime() != null ? this.getEndTime().getTime() : -1L);
        dataOutput.writeLong(this.getLastCheckTime() != null ? this.getLastCheckTime().getTime() : -1L);
        WritableUtils.writeStr(dataOutput, this.getTransition());
        WritableUtils.writeStr(dataOutput, this.getData());
        WritableUtils.writeStr(dataOutput, this.getExternalId());
        WritableUtils.writeStr(dataOutput, this.getExternalStatus());
        WritableUtils.writeStr(dataOutput, this.getTrackerUri());
        WritableUtils.writeStr(dataOutput, this.getConsoleUrl());
        WritableUtils.writeStr(dataOutput, this.getErrorCode());
        WritableUtils.writeStr(dataOutput, this.getErrorMessage());
        WritableUtils.writeStr(dataOutput, WorkflowActionBean.pcGetwfId(this));
        WritableUtils.writeStr(dataOutput, WorkflowActionBean.pcGetexecutionPath(this));
        dataOutput.writeInt(WorkflowActionBean.pcGetpending(this));
        dataOutput.writeLong(this.pendingAge != null ? this.pendingAge.getTime() : -1L);
        WritableUtils.writeStr(dataOutput, WorkflowActionBean.pcGetsignalValue(this));
        WritableUtils.writeStr(dataOutput, WorkflowActionBean.pcGetlogToken(this));
        dataOutput.writeInt(this.getUserRetryCount());
        dataOutput.writeInt(this.getUserRetryInterval());
        dataOutput.writeInt(this.getUserRetryMax());
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.setId(WritableUtils.readStr(dataInput));
        this.setName(WritableUtils.readStr(dataInput));
        this.setCred(WritableUtils.readStr(dataInput));
        this.setType(WritableUtils.readStr(dataInput));
        this.setConf(WritableUtils.readStr(dataInput));
        this.setStatus(WorkflowAction.Status.valueOf((String)WritableUtils.readStr(dataInput)));
        this.setRetries(dataInput.readInt());
        long d = dataInput.readLong();
        if (d != -1L) {
            this.setStartTime(new Date(d));
        }
        if ((d = dataInput.readLong()) != -1L) {
            this.setEndTime(new Date(d));
        }
        if ((d = dataInput.readLong()) != -1L) {
            this.setLastCheckTime(new Date(d));
        }
        this.setTransition(WritableUtils.readStr(dataInput));
        this.setData(WritableUtils.readStr(dataInput));
        this.setExternalId(WritableUtils.readStr(dataInput));
        this.setExternalStatus(WritableUtils.readStr(dataInput));
        this.setTrackerUri(WritableUtils.readStr(dataInput));
        this.setConsoleUrl(WritableUtils.readStr(dataInput));
        this.setErrorInfo(WritableUtils.readStr(dataInput), WritableUtils.readStr(dataInput));
        WorkflowActionBean.pcSetwfId(this, WritableUtils.readStr(dataInput));
        WorkflowActionBean.pcSetexecutionPath(this, WritableUtils.readStr(dataInput));
        WorkflowActionBean.pcSetpending(this, dataInput.readInt());
        d = dataInput.readLong();
        if (d != -1L) {
            this.pendingAge = new Date(d);
            WorkflowActionBean.pcSetpendingAgeTimestamp(this, DateUtils.convertDateToTimestamp(this.pendingAge));
        }
        WorkflowActionBean.pcSetsignalValue(this, WritableUtils.readStr(dataInput));
        WorkflowActionBean.pcSetlogToken(this, WritableUtils.readStr(dataInput));
        this.setUserRetryCount(dataInput.readInt());
        this.setUserRetryInterval(dataInput.readInt());
        this.setUserRetryMax(dataInput.readInt());
    }

    public boolean isExecutionComplete() {
        return this.getStatus() == WorkflowAction.Status.DONE;
    }

    public boolean isRetryOrManual() {
        return this.getStatus() == WorkflowAction.Status.START_RETRY || this.getStatus() == WorkflowAction.Status.START_MANUAL || this.getStatus() == WorkflowAction.Status.END_RETRY || this.getStatus() == WorkflowAction.Status.END_MANUAL;
    }

    public boolean isUserRetry() {
        return this.getStatus() == WorkflowAction.Status.USER_RETRY;
    }

    public boolean isComplete() {
        return this.getStatus() == WorkflowAction.Status.OK || this.getStatus() == WorkflowAction.Status.KILLED || this.getStatus() == WorkflowAction.Status.ERROR;
    }

    public void setPendingOnly() {
        WorkflowActionBean.pcSetpending(this, 1);
    }

    public void setPending() {
        WorkflowActionBean.pcSetpending(this, 1);
        this.pendingAge = new Date();
        WorkflowActionBean.pcSetpendingAgeTimestamp(this, DateUtils.convertDateToTimestamp(this.pendingAge));
    }

    public void setPendingAge(Date pendingAge) {
        this.pendingAge = pendingAge;
        WorkflowActionBean.pcSetpendingAgeTimestamp(this, DateUtils.convertDateToTimestamp(pendingAge));
    }

    public Date getPendingAge() {
        return DateUtils.toDate(WorkflowActionBean.pcGetpendingAgeTimestamp(this));
    }

    public boolean isPending() {
        return WorkflowActionBean.pcGetpending(this) == 1;
    }

    public void resetPending() {
        WorkflowActionBean.pcSetpending(this, 0);
        this.pendingAge = null;
        WorkflowActionBean.pcSetpendingAgeTimestamp(this, null);
    }

    public void resetPendingOnly() {
        WorkflowActionBean.pcSetpending(this, 0);
    }

    public void incRetries() {
        this.setRetries(this.getRetries() + 1);
    }

    public void setStartData(String externalId, String trackerUri, String consoleUrl) {
        this.setExternalId(ParamChecker.notEmpty(externalId, "externalId"));
        this.setTrackerUri(ParamChecker.notEmpty(trackerUri, "trackerUri"));
        this.setConsoleUrl(ParamChecker.notEmpty(consoleUrl, "consoleUrl"));
        Date now = new Date();
        this.setStartTime(now);
        this.setLastCheckTime(now);
        this.setStatus(WorkflowAction.Status.RUNNING);
    }

    public void setExecutionData(String externalStatus, Properties actionData) {
        this.setStatus(WorkflowAction.Status.DONE);
        this.setExternalStatus(ParamChecker.notEmpty(externalStatus, "externalStatus"));
        if (actionData != null) {
            this.setData(PropertiesUtils.propertiesToString(actionData));
        }
    }

    public void setEndData(WorkflowAction.Status status, String signalValue) {
        if (status == null || status != WorkflowAction.Status.OK && status != WorkflowAction.Status.ERROR && status != WorkflowAction.Status.KILLED) {
            throw new IllegalArgumentException("Action status must be OK, ERROR or KILLED. Received [" + status.toString() + "]");
        }
        if (status == WorkflowAction.Status.OK) {
            this.setErrorInfo(null, null);
        }
        this.setStatus(status);
        this.setSignalValue(ParamChecker.notEmpty(signalValue, "signalValue"));
    }

    public String getJobId() {
        return WorkflowActionBean.pcGetwfId(this);
    }

    public String getWfId() {
        return WorkflowActionBean.pcGetwfId(this);
    }

    public void setJobId(String id) {
        WorkflowActionBean.pcSetwfId(this, id);
    }

    public String getSlaXml() {
        return WorkflowActionBean.pcGetslaXml(this);
    }

    public void setSlaXml(String slaXml) {
        WorkflowActionBean.pcSetslaXml(this, slaXml);
    }

    @Override
    public void setStatus(WorkflowAction.Status val) {
        WorkflowActionBean.pcSetstatus(this, val.toString());
        super.setStatus(val);
    }

    public String getStatusStr() {
        return WorkflowActionBean.pcGetstatus(this);
    }

    @Override
    public WorkflowAction.Status getStatus() {
        return WorkflowAction.Status.valueOf((String)WorkflowActionBean.pcGetstatus(this));
    }

    public String getExecutionPath() {
        return WorkflowActionBean.pcGetexecutionPath(this);
    }

    public void setExecutionPath(String executionPath) {
        WorkflowActionBean.pcSetexecutionPath(this, executionPath);
    }

    public String getSignalValue() {
        return WorkflowActionBean.pcGetsignalValue(this);
    }

    public void setSignalValue(String signalValue) {
        WorkflowActionBean.pcSetsignalValue(this, signalValue);
    }

    public String getLogToken() {
        return WorkflowActionBean.pcGetlogToken(this);
    }

    public void setLogToken(String logToken) {
        WorkflowActionBean.pcSetlogToken(this, logToken);
    }

    public Date getLastCheckTime() {
        return DateUtils.toDate(WorkflowActionBean.pcGetlastCheckTimestamp(this));
    }

    public Timestamp getLastCheckTimestamp() {
        return WorkflowActionBean.pcGetlastCheckTimestamp(this);
    }

    public Timestamp getStartTimestamp() {
        return WorkflowActionBean.pcGetstartTimestamp(this);
    }

    public Timestamp getEndTimestamp() {
        return WorkflowActionBean.pcGetendTimestamp(this);
    }

    public Timestamp getPendingAgeTimestamp() {
        return WorkflowActionBean.pcGetpendingAgeTimestamp(this);
    }

    public void setLastCheckTime(Date lastCheckTime) {
        WorkflowActionBean.pcSetlastCheckTimestamp(this, DateUtils.convertDateToTimestamp(lastCheckTime));
    }

    public boolean getPending() {
        return WorkflowActionBean.pcGetpending(this) == 1;
    }

    @Override
    public Date getStartTime() {
        return DateUtils.toDate(WorkflowActionBean.pcGetstartTimestamp(this));
    }

    @Override
    public void setStartTime(Date startTime) {
        super.setStartTime(startTime);
        WorkflowActionBean.pcSetstartTimestamp(this, DateUtils.convertDateToTimestamp(startTime));
    }

    @Override
    public Date getEndTime() {
        return DateUtils.toDate(WorkflowActionBean.pcGetendTimestamp(this));
    }

    @Override
    public void setEndTime(Date endTime) {
        super.setEndTime(endTime);
        WorkflowActionBean.pcSetendTimestamp(this, DateUtils.convertDateToTimestamp(endTime));
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1055128;
    }

    static {
        Class clazz = class$Lorg$apache$oozie$client$rest$JsonWorkflowAction != null ? class$Lorg$apache$oozie$client$rest$JsonWorkflowAction : (class$Lorg$apache$oozie$client$rest$JsonWorkflowAction = WorkflowActionBean.class$("org.apache.oozie.client.rest.JsonWorkflowAction"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"endTimestamp", "executionPath", "lastCheckTimestamp", "logToken", "pending", "pendingAgeTimestamp", "signalValue", "slaXml", "startTimestamp", "status", "wfId"};
        Class[] classArray = new Class[11];
        Class clazz2 = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = WorkflowActionBean.class$("java.sql.Timestamp"));
        classArray[0] = clazz2;
        Class clazz3 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowActionBean.class$("java.lang.String"));
        classArray[1] = clazz3;
        classArray[2] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = WorkflowActionBean.class$("java.sql.Timestamp"));
        classArray[3] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowActionBean.class$("java.lang.String"));
        classArray[4] = Integer.TYPE;
        classArray[5] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = WorkflowActionBean.class$("java.sql.Timestamp"));
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowActionBean.class$("java.lang.String"));
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowActionBean.class$("java.lang.String"));
        classArray[8] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = WorkflowActionBean.class$("java.sql.Timestamp"));
        classArray[9] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowActionBean.class$("java.lang.String"));
        classArray[10] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowActionBean.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz4 = class$Lorg$apache$oozie$WorkflowActionBean != null ? class$Lorg$apache$oozie$WorkflowActionBean : (class$Lorg$apache$oozie$WorkflowActionBean = WorkflowActionBean.class$("org.apache.oozie.WorkflowActionBean"));
        PCRegistry.register((Class)clazz4, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"WorkflowActionBean", (PersistenceCapable)new WorkflowActionBean());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.endTimestamp = null;
        this.executionPath = null;
        this.lastCheckTimestamp = null;
        this.logToken = null;
        this.pending = 0;
        this.pendingAgeTimestamp = null;
        this.signalValue = null;
        this.slaXml = null;
        this.startTimestamp = null;
        this.status = null;
        this.wfId = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        WorkflowActionBean workflowActionBean = new WorkflowActionBean();
        if (bl) {
            workflowActionBean.pcClearFields();
        }
        workflowActionBean.pcStateManager = stateManager;
        workflowActionBean.pcCopyKeyFieldsFromObjectId(object);
        return workflowActionBean;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        WorkflowActionBean workflowActionBean = new WorkflowActionBean();
        if (bl) {
            workflowActionBean.pcClearFields();
        }
        workflowActionBean.pcStateManager = stateManager;
        return workflowActionBean;
    }

    protected static int pcGetManagedFieldCount() {
        return 11 + JsonWorkflowAction.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.endTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.executionPath = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.lastCheckTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.logToken = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.pending = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.pendingAgeTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.signalValue = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.slaXml = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.startTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.status = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.wfId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.endTimestamp);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.executionPath);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.lastCheckTimestamp);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.logToken);
                return;
            }
            case 4: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.pending);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.pendingAgeTimestamp);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.signalValue);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.slaXml);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.startTimestamp);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.status);
                return;
            }
            case 10: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.wfId);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(WorkflowActionBean workflowActionBean, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(workflowActionBean, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.endTimestamp = workflowActionBean.endTimestamp;
                return;
            }
            case 1: {
                this.executionPath = workflowActionBean.executionPath;
                return;
            }
            case 2: {
                this.lastCheckTimestamp = workflowActionBean.lastCheckTimestamp;
                return;
            }
            case 3: {
                this.logToken = workflowActionBean.logToken;
                return;
            }
            case 4: {
                this.pending = workflowActionBean.pending;
                return;
            }
            case 5: {
                this.pendingAgeTimestamp = workflowActionBean.pendingAgeTimestamp;
                return;
            }
            case 6: {
                this.signalValue = workflowActionBean.signalValue;
                return;
            }
            case 7: {
                this.slaXml = workflowActionBean.slaXml;
                return;
            }
            case 8: {
                this.startTimestamp = workflowActionBean.startTimestamp;
                return;
            }
            case 9: {
                this.status = workflowActionBean.status;
                return;
            }
            case 10: {
                this.wfId = workflowActionBean.wfId;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        WorkflowActionBean workflowActionBean = (WorkflowActionBean)object;
        if (workflowActionBean.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(workflowActionBean, nArray[n]);
            ++n;
        }
    }

    private static final Timestamp pcGetendTimestamp(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.endTimestamp;
        }
        int n = pcInheritedFieldCount + 0;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.endTimestamp;
    }

    private static final void pcSetendTimestamp(WorkflowActionBean workflowActionBean, Timestamp timestamp) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.endTimestamp = timestamp;
            return;
        }
        workflowActionBean.pcStateManager.settingObjectField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 0, (Object)workflowActionBean.endTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGetexecutionPath(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.executionPath;
        }
        int n = pcInheritedFieldCount + 1;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.executionPath;
    }

    private static final void pcSetexecutionPath(WorkflowActionBean workflowActionBean, String string) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.executionPath = string;
            return;
        }
        workflowActionBean.pcStateManager.settingStringField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 1, workflowActionBean.executionPath, string, 0);
    }

    private static final Timestamp pcGetlastCheckTimestamp(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.lastCheckTimestamp;
        }
        int n = pcInheritedFieldCount + 2;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.lastCheckTimestamp;
    }

    private static final void pcSetlastCheckTimestamp(WorkflowActionBean workflowActionBean, Timestamp timestamp) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.lastCheckTimestamp = timestamp;
            return;
        }
        workflowActionBean.pcStateManager.settingObjectField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 2, (Object)workflowActionBean.lastCheckTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGetlogToken(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.logToken;
        }
        int n = pcInheritedFieldCount + 3;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.logToken;
    }

    private static final void pcSetlogToken(WorkflowActionBean workflowActionBean, String string) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.logToken = string;
            return;
        }
        workflowActionBean.pcStateManager.settingStringField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 3, workflowActionBean.logToken, string, 0);
    }

    private static final int pcGetpending(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.pending;
        }
        int n = pcInheritedFieldCount + 4;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.pending;
    }

    private static final void pcSetpending(WorkflowActionBean workflowActionBean, int n) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.pending = n;
            return;
        }
        workflowActionBean.pcStateManager.settingIntField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 4, workflowActionBean.pending, n, 0);
    }

    private static final Timestamp pcGetpendingAgeTimestamp(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.pendingAgeTimestamp;
        }
        int n = pcInheritedFieldCount + 5;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.pendingAgeTimestamp;
    }

    private static final void pcSetpendingAgeTimestamp(WorkflowActionBean workflowActionBean, Timestamp timestamp) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.pendingAgeTimestamp = timestamp;
            return;
        }
        workflowActionBean.pcStateManager.settingObjectField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 5, (Object)workflowActionBean.pendingAgeTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGetsignalValue(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.signalValue;
        }
        int n = pcInheritedFieldCount + 6;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.signalValue;
    }

    private static final void pcSetsignalValue(WorkflowActionBean workflowActionBean, String string) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.signalValue = string;
            return;
        }
        workflowActionBean.pcStateManager.settingStringField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 6, workflowActionBean.signalValue, string, 0);
    }

    private static final String pcGetslaXml(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.slaXml;
        }
        int n = pcInheritedFieldCount + 7;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.slaXml;
    }

    private static final void pcSetslaXml(WorkflowActionBean workflowActionBean, String string) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.slaXml = string;
            return;
        }
        workflowActionBean.pcStateManager.settingStringField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 7, workflowActionBean.slaXml, string, 0);
    }

    private static final Timestamp pcGetstartTimestamp(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.startTimestamp;
        }
        int n = pcInheritedFieldCount + 8;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.startTimestamp;
    }

    private static final void pcSetstartTimestamp(WorkflowActionBean workflowActionBean, Timestamp timestamp) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.startTimestamp = timestamp;
            return;
        }
        workflowActionBean.pcStateManager.settingObjectField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 8, (Object)workflowActionBean.startTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGetstatus(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.status;
        }
        int n = pcInheritedFieldCount + 9;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.status;
    }

    private static final void pcSetstatus(WorkflowActionBean workflowActionBean, String string) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.status = string;
            return;
        }
        workflowActionBean.pcStateManager.settingStringField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 9, workflowActionBean.status, string, 0);
    }

    private static final String pcGetwfId(WorkflowActionBean workflowActionBean) {
        if (workflowActionBean.pcStateManager == null) {
            return workflowActionBean.wfId;
        }
        int n = pcInheritedFieldCount + 10;
        workflowActionBean.pcStateManager.accessingField(n);
        return workflowActionBean.wfId;
    }

    private static final void pcSetwfId(WorkflowActionBean workflowActionBean, String string) {
        if (workflowActionBean.pcStateManager == null) {
            workflowActionBean.wfId = string;
            return;
        }
        workflowActionBean.pcStateManager.settingStringField((PersistenceCapable)workflowActionBean, pcInheritedFieldCount + 10, workflowActionBean.wfId, string, 0);
    }
}

