/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.oozie.action.hadoop.Credentials;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.XLog;

public class CredentialsProvider {
    Credentials cred;
    String type;
    private static final String CRED_KEY = "oozie.credentials.credentialclasses";
    private static final XLog LOG = XLog.getLog(CredentialsProvider.class);

    public CredentialsProvider(String type) {
        this.type = type;
        this.cred = null;
        LOG.debug("Credentials Provider is created for Type: " + type);
    }

    public Credentials createCredentialObject() throws Exception {
        Configuration conf = Services.get().getConf();
        if (conf.get(CRED_KEY, "").trim().length() > 0) {
            for (String function : conf.getStrings(CRED_KEY)) {
                function = this.Trim(function);
                LOG.debug("Creating Credential class for : " + function);
                String[] str = function.split("=");
                if (str.length <= 0) continue;
                String type = str[0];
                String classname = str[1];
                if (classname == null) continue;
                LOG.debug("Creating Credential type : '" + type + "', class Name : '" + classname + "'");
                if (!this.type.equalsIgnoreCase(str[0])) continue;
                Class<?> klass = null;
                try {
                    klass = Thread.currentThread().getContextClassLoader().loadClass(classname);
                }
                catch (ClassNotFoundException ex) {
                    LOG.warn((Object)"Exception while loading the class", ex);
                    throw ex;
                }
                this.cred = (Credentials)ReflectionUtils.newInstance(klass, null);
            }
        }
        return this.cred;
    }

    public String Trim(String str) {
        if (str != null) {
            str = str.replaceAll("\\n", "");
            str = str.replaceAll("\\t", "");
            str = str.trim();
        }
        return str;
    }
}

