/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.oozie.action.hadoop.LauncherException;
import org.apache.oozie.action.hadoop.LauncherMainException;
import org.apache.oozie.action.hadoop.LauncherSecurityManager;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.XLog;

public class LauncherMapper<K1, V1, K2, V2>
implements Mapper<K1, V1, K2, V2>,
Runnable {
    public static final String CONF_OOZIE_ACTION_MAIN_CLASS = "oozie.launcher.action.main.class";
    private static final String CONF_OOZIE_ACTION_MAIN_ARG_COUNT = "oozie.action.main.arg.count";
    private static final String CONF_OOZIE_ACTION_MAIN_ARG_PREFIX = "oozie.action.main.arg.";
    private static final String CONF_OOZIE_ACTION_MAX_OUTPUT_DATA = "oozie.action.max.output.data";
    private static final String COUNTER_GROUP = "oozie.launcher";
    private static final String COUNTER_DO_ID_SWAP = "oozie.do.id.swap";
    private static final String COUNTER_OUTPUT_DATA = "oozie.output.data";
    private static final String COUNTER_LAUNCHER_ERROR = "oozie.launcher.error";
    private static final String OOZIE_JOB_ID = "oozie.job.id";
    private static final String OOZIE_ACTION_ID = "oozie.action.id";
    private static final String OOZIE_ACTION_DIR_PATH = "oozie.action.dir.path";
    private static final String OOZIE_ACTION_RECOVERY_ID = "oozie.action.recovery.id";
    static final String ACTION_CONF_XML = "action.xml";
    private static final String ACTION_OUTPUT_PROPS = "output.properties";
    private static final String ACTION_NEW_ID_PROPS = "newId.properties";
    private static final String ACTION_ERROR_PROPS = "error.properties";
    private JobConf jobConf;
    private Path actionDir;
    private ScheduledThreadPoolExecutor timer;
    private boolean configFailure = false;
    private Reporter reporter;

    private void setRecoveryId(Configuration launcherConf, Path actionDir, String recoveryId) throws LauncherException {
        try {
            FileSystem fs = FileSystem.get((Configuration)launcherConf);
            String jobId = launcherConf.get("mapred.job.id");
            Path path = new Path(actionDir, recoveryId);
            if (!fs.exists(path)) {
                try {
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(path));
                    writer.write(jobId);
                    ((Writer)writer).close();
                }
                catch (IOException ex) {
                    this.failLauncher(0, "IO error", ex);
                }
            } else {
                FSDataInputStream is = fs.open(path);
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));
                String id = reader.readLine();
                reader.close();
                if (!jobId.equals(id)) {
                    this.failLauncher(0, MessageFormat.format("Hadoop job Id mismatch, action file [{0}] declares Id [{1}] current Id [{2}]", path, id, jobId), null);
                }
            }
        }
        catch (IOException ex) {
            this.failLauncher(0, "IO error", ex);
        }
    }

    public static String getRecoveryId(Configuration launcherConf, Path actionDir, String recoveryId) throws HadoopAccessorException, IOException {
        String jobId = null;
        Path recoveryFile = new Path(actionDir, recoveryId);
        FileSystem fs = Services.get().get(HadoopAccessorService.class).createFileSystem(launcherConf.get("user.name"), launcherConf.get("group.name"), launcherConf);
        if (fs.exists(recoveryFile)) {
            FSDataInputStream is = fs.open(recoveryFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));
            jobId = reader.readLine();
            reader.close();
        }
        return jobId;
    }

    public static void setupMainClass(Configuration launcherConf, String javaMainClass) {
        launcherConf.set(CONF_OOZIE_ACTION_MAIN_CLASS, javaMainClass);
    }

    public static void setupMainArguments(Configuration launcherConf, String[] args) {
        launcherConf.setInt(CONF_OOZIE_ACTION_MAIN_ARG_COUNT, args.length);
        for (int i = 0; i < args.length; ++i) {
            launcherConf.set(CONF_OOZIE_ACTION_MAIN_ARG_PREFIX + i, args[i]);
        }
    }

    public static void setupMaxOutputData(Configuration launcherConf, int maxOutputData) {
        launcherConf.setInt(CONF_OOZIE_ACTION_MAX_OUTPUT_DATA, maxOutputData);
    }

    public static void setupLauncherInfo(JobConf launcherConf, String jobId, String actionId, Path actionDir, String recoveryId, Configuration actionConf) throws IOException, HadoopAccessorException {
        launcherConf.setMapperClass(LauncherMapper.class);
        launcherConf.setSpeculativeExecution(false);
        launcherConf.setNumMapTasks(1);
        launcherConf.setNumReduceTasks(0);
        launcherConf.set(OOZIE_JOB_ID, jobId);
        launcherConf.set(OOZIE_ACTION_ID, actionId);
        launcherConf.set(OOZIE_ACTION_DIR_PATH, actionDir.toString());
        launcherConf.set(OOZIE_ACTION_RECOVERY_ID, recoveryId);
        actionConf.set(OOZIE_JOB_ID, jobId);
        actionConf.set(OOZIE_ACTION_ID, actionId);
        FileSystem fs = Services.get().get(HadoopAccessorService.class).createFileSystem(launcherConf.get("user.name"), launcherConf.get("group.name"), (Configuration)launcherConf);
        fs.mkdirs(actionDir);
        FSDataOutputStream os = fs.create(new Path(actionDir, ACTION_CONF_XML));
        actionConf.writeXml((OutputStream)os);
        os.close();
        Path inputDir = new Path(actionDir, "input");
        fs.mkdirs(inputDir);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(new Path(inputDir, "dummy.txt")));
        writer.write("dummy");
        ((Writer)writer).close();
        launcherConf.set("mapred.input.dir", inputDir.toString());
        launcherConf.set("mapred.output.dir", new Path(actionDir, "output").toString());
    }

    public static boolean isMainDone(RunningJob runningJob) throws IOException {
        return runningJob.isComplete();
    }

    public static boolean isMainSuccessful(RunningJob runningJob) throws IOException {
        Counters.Group group;
        Counters counters;
        boolean succeeded = runningJob.isSuccessful();
        if (succeeded && (counters = runningJob.getCounters()) != null && (group = counters.getGroup(COUNTER_GROUP)) != null) {
            succeeded = group.getCounter(COUNTER_LAUNCHER_ERROR) == 0L;
        }
        return succeeded;
    }

    public static boolean hasOutputData(RunningJob runningJob) throws IOException {
        Counters.Group group;
        boolean output = false;
        Counters counters = runningJob.getCounters();
        if (counters != null && (group = counters.getGroup(COUNTER_GROUP)) != null) {
            output = group.getCounter(COUNTER_OUTPUT_DATA) == 1L;
        }
        return output;
    }

    public static boolean hasIdSwap(RunningJob runningJob) throws IOException {
        Counters.Group group;
        boolean swap = false;
        Counters counters = runningJob.getCounters();
        if (counters != null && (group = counters.getGroup(COUNTER_GROUP)) != null) {
            swap = group.getCounter(COUNTER_DO_ID_SWAP) == 1L;
        }
        return swap;
    }

    public static boolean hasIdSwap(RunningJob runningJob, String user, String group, Path actionDir) throws IOException, HadoopAccessorException {
        boolean swap = false;
        XLog log = XLog.getLog("org.apache.oozie.action.hadoop.LauncherMapper");
        Counters counters = runningJob.getCounters();
        if (counters != null) {
            Counters.Group counterGroup = counters.getGroup(COUNTER_GROUP);
            if (counterGroup != null) {
                swap = counterGroup.getCounter(COUNTER_DO_ID_SWAP) == 1L;
            }
        } else {
            Path p = LauncherMapper.getIdSwapPath(actionDir);
            FileSystem fs = Services.get().get(HadoopAccessorService.class).createFileSystem(user, group, p.toUri(), new Configuration());
            if (fs.exists(p)) {
                log.debug("Hadoop Counters is null, but found newID file.");
                swap = true;
            } else {
                log.debug("Hadoop Counters is null, and newID file doesn't exist at: [{0}]", p);
            }
        }
        return swap;
    }

    public static Path getOutputDataPath(Path actionDir) {
        return new Path(actionDir, ACTION_OUTPUT_PROPS);
    }

    public static Path getErrorPath(Path actionDir) {
        return new Path(actionDir, ACTION_ERROR_PROPS);
    }

    public static Path getIdSwapPath(Path actionDir) {
        return new Path(actionDir, ACTION_NEW_ID_PROPS);
    }

    public LauncherMapper() {
    }

    public void configure(JobConf jobConf) {
        System.out.println();
        System.out.println("Oozie Launcher starts");
        System.out.println();
        this.jobConf = jobConf;
        this.actionDir = new Path(this.getJobConf().get(OOZIE_ACTION_DIR_PATH));
        String recoveryId = jobConf.get(OOZIE_ACTION_RECOVERY_ID, null);
        try {
            this.setRecoveryId((Configuration)jobConf, this.actionDir, recoveryId);
        }
        catch (LauncherException ex) {
            this.configFailure = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void map(K1 key, V1 value, OutputCollector<K2, V2> collector, Reporter reporter) throws IOException {
        try {
            if (this.configFailure) {
                throw new LauncherException();
            }
            String mainClass = this.getJobConf().get(CONF_OOZIE_ACTION_MAIN_CLASS);
            String msgPrefix = "Main class [" + mainClass + "], ";
            int errorCode = 0;
            Throwable errorCause = null;
            String errorMessage = null;
            try {
                new LauncherSecurityManager();
            }
            catch (SecurityException ex) {
                errorMessage = "Could not set LauncherSecurityManager";
                errorCause = ex;
            }
            try {
                block31: {
                    this.setupHeartBeater(reporter);
                    this.setupMainConfiguration();
                    String[] args = LauncherMapper.getMainArguments((Configuration)this.getJobConf());
                    this.printContentsOfCurrentDir();
                    System.out.println();
                    System.out.println("Oozie Java/Map-Reduce/Pig action launcher-job configuration");
                    System.out.println("=================================================================");
                    System.out.println("Workflow job id   : " + System.getProperty(OOZIE_JOB_ID));
                    System.out.println("Workflow action id: " + System.getProperty(OOZIE_ACTION_ID));
                    System.out.println();
                    System.out.println("Classpath         :");
                    System.out.println("------------------------");
                    StringTokenizer st = new StringTokenizer(System.getProperty("java.class.path"), ":");
                    while (st.hasMoreTokens()) {
                        System.out.println("  " + st.nextToken());
                    }
                    System.out.println("------------------------");
                    System.out.println();
                    System.out.println("Main class        : " + mainClass);
                    System.out.println();
                    System.out.println("Maximum output    : " + this.getJobConf().getInt(CONF_OOZIE_ACTION_MAX_OUTPUT_DATA, 2048));
                    System.out.println();
                    System.out.println("Arguments         :");
                    for (String arg : args) {
                        System.out.println("                    " + arg);
                    }
                    System.out.println();
                    System.out.println("Java System Properties:");
                    System.out.println("------------------------");
                    System.getProperties().store(System.out, "");
                    System.out.flush();
                    System.out.println("------------------------");
                    System.out.println();
                    System.out.println("=================================================================");
                    System.out.println();
                    System.out.println(">>> Invoking Main class now >>>");
                    System.out.println();
                    System.out.flush();
                    try {
                        Class klass = this.getJobConf().getClass(CONF_OOZIE_ACTION_MAIN_CLASS, Object.class);
                        Method mainMethod = klass.getMethod("main", String[].class);
                        mainMethod.invoke(null, new Object[]{args});
                    }
                    catch (InvocationTargetException ex) {
                        if (LauncherMainException.class.isInstance(ex.getCause())) {
                            errorMessage = msgPrefix + "exit code [" + ((LauncherMainException)ex.getCause()).getErrorCode() + "]";
                            errorCause = null;
                            break block31;
                        }
                        if (SecurityException.class.isInstance(ex.getCause())) {
                            if (LauncherSecurityManager.getExitInvoked()) {
                                System.out.println("Intercepting System.exit(" + LauncherSecurityManager.getExitCode() + ")");
                                System.err.println("Intercepting System.exit(" + LauncherSecurityManager.getExitCode() + ")");
                                errorCode = LauncherSecurityManager.getExitCode();
                                if (errorCode != 0) {
                                    errorMessage = msgPrefix + "exit code [" + errorCode + "]";
                                    errorCause = null;
                                }
                            }
                            break block31;
                        }
                        throw ex;
                    }
                    finally {
                        System.out.println();
                        System.out.println("<<< Invocation of Main class completed <<<");
                        System.out.println();
                    }
                }
                if (errorMessage == null) {
                    File newId;
                    File outputData = new File(System.getProperty("oozie.action.output.properties"));
                    if (outputData.exists()) {
                        FileSystem fs = FileSystem.get((Configuration)this.getJobConf());
                        fs.copyFromLocalFile(new Path(outputData.toString()), new Path(this.actionDir, ACTION_OUTPUT_PROPS));
                        reporter.incrCounter(COUNTER_GROUP, COUNTER_OUTPUT_DATA, 1L);
                        int maxOutputData = this.getJobConf().getInt(CONF_OOZIE_ACTION_MAX_OUTPUT_DATA, 2048);
                        if (outputData.length() > (long)maxOutputData) {
                            String msg = MessageFormat.format("Output data size [{0}] exceeds maximum [{1}]", outputData.length(), maxOutputData);
                            this.failLauncher(0, msg, null);
                        }
                        System.out.println();
                        System.out.println("Oozie Launcher, capturing output data:");
                        System.out.println("=======================");
                        Properties props = new Properties();
                        props.load(new FileReader(outputData));
                        props.store(System.out, "");
                        System.out.println();
                        System.out.println("=======================");
                        System.out.println();
                    }
                    if ((newId = new File(System.getProperty("oozie.action.newId.properties"))).exists()) {
                        Properties props = new Properties();
                        props.load(new FileReader(newId));
                        if (props.getProperty("id") == null) {
                            throw new IllegalStateException("ID swap file does not have [id] property");
                        }
                        FileSystem fs = FileSystem.get((Configuration)this.getJobConf());
                        fs.copyFromLocalFile(new Path(newId.toString()), new Path(this.actionDir, ACTION_NEW_ID_PROPS));
                        reporter.incrCounter(COUNTER_GROUP, COUNTER_DO_ID_SWAP, 1L);
                        System.out.println("Oozie Launcher, copying new Hadoop job id to file: " + new Path(this.actionDir, ACTION_NEW_ID_PROPS).toUri());
                        System.out.println();
                        System.out.println("Oozie Launcher, propagating new Hadoop job id to Oozie");
                        System.out.println("=======================");
                        System.out.println("id: " + props.getProperty("id"));
                        System.out.println("=======================");
                        System.out.println();
                    }
                }
            }
            catch (NoSuchMethodException ex) {
                errorMessage = msgPrefix + "main() method not found";
                errorCause = ex;
            }
            catch (InvocationTargetException ex) {
                errorMessage = msgPrefix + "main() threw exception";
                errorCause = ex.getTargetException();
            }
            catch (Throwable ex) {
                errorMessage = msgPrefix + "exception invoking main()";
                errorCause = ex;
            }
            finally {
                this.destroyHeartBeater();
                if (errorMessage != null) {
                    this.failLauncher(errorCode, errorMessage, errorCause);
                }
            }
        }
        catch (LauncherException ex) {
            reporter.incrCounter(COUNTER_GROUP, COUNTER_LAUNCHER_ERROR, 1L);
            System.out.println();
            System.out.println("Oozie Launcher failed, finishing Hadoop job gracefully");
            System.out.println();
        }
    }

    public void close() throws IOException {
        System.out.println();
        System.out.println("Oozie Launcher ends");
        System.out.println();
    }

    protected JobConf getJobConf() {
        return this.jobConf;
    }

    private void setupMainConfiguration() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.getJobConf());
        fs.copyToLocalFile(new Path(this.getJobConf().get(OOZIE_ACTION_DIR_PATH), ACTION_CONF_XML), new Path(new File(ACTION_CONF_XML).getAbsolutePath()));
        System.setProperty("oozie.launcher.job.id", this.getJobConf().get("mapred.job.id"));
        System.setProperty(OOZIE_JOB_ID, this.getJobConf().get(OOZIE_JOB_ID));
        System.setProperty(OOZIE_ACTION_ID, this.getJobConf().get(OOZIE_ACTION_ID));
        System.setProperty("oozie.action.conf.xml", new File(ACTION_CONF_XML).getAbsolutePath());
        System.setProperty("oozie.action.output.properties", new File(ACTION_OUTPUT_PROPS).getAbsolutePath());
        System.setProperty("oozie.action.newId.properties", new File(ACTION_NEW_ID_PROPS).getAbsolutePath());
    }

    public static String[] getMainArguments(Configuration conf) {
        String[] args = new String[conf.getInt(CONF_OOZIE_ACTION_MAIN_ARG_COUNT, 0)];
        for (int i = 0; i < args.length; ++i) {
            args[i] = conf.get(CONF_OOZIE_ACTION_MAIN_ARG_PREFIX + i);
        }
        return args;
    }

    private void setupHeartBeater(Reporter reporter) {
        this.timer = new ScheduledThreadPoolExecutor(1);
        this.timer.scheduleAtFixedRate(new LauncherMapper<K1, V1, K2, V2>(reporter), 0L, 30L, TimeUnit.SECONDS);
    }

    private void destroyHeartBeater() {
        this.timer.shutdownNow();
    }

    private LauncherMapper(Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public void run() {
        System.out.println("Heart beat");
        this.reporter.progress();
    }

    private void failLauncher(int errorCode, String reason, Throwable ex) throws LauncherException {
        try {
            if (ex != null) {
                reason = reason + ", " + ex.getMessage();
            }
            Properties errorProps = new Properties();
            errorProps.setProperty("error.code", Integer.toString(errorCode));
            errorProps.setProperty("error.reason", reason);
            if (ex != null) {
                if (ex.getMessage() != null) {
                    errorProps.setProperty("exception.message", ex.getMessage());
                }
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                pw.close();
                errorProps.setProperty("exception.stacktrace", sw.toString());
            }
            FileSystem fs = FileSystem.get((Configuration)this.getJobConf());
            FSDataOutputStream os = fs.create(new Path(this.actionDir, ACTION_ERROR_PROPS));
            errorProps.store((OutputStream)os, "");
            os.close();
            System.out.print("Failing Oozie Launcher, " + reason + "\n");
            System.err.print("Failing Oozie Launcher, " + reason + "\n");
            if (ex != null) {
                ex.printStackTrace(System.out);
                ex.printStackTrace(System.err);
            }
            throw new LauncherException();
        }
        catch (IOException rex) {
            throw new RuntimeException("Error while failing launcher, " + rex.getMessage(), rex);
        }
    }

    protected void printContentsOfCurrentDir() {
        File[] listOfFiles;
        File folder = new File(".");
        System.out.println();
        System.out.println("Files in current dir:" + folder.getAbsolutePath());
        System.out.println("======================");
        for (File fileName : listOfFiles = folder.listFiles()) {
            File[] moreFiles;
            if (fileName.isFile()) {
                System.out.println("File: " + fileName.getName());
                continue;
            }
            if (!fileName.isDirectory()) continue;
            System.out.println("Dir: " + fileName.getName());
            File subDir = new File(fileName.getName());
            for (File subFileName : moreFiles = subDir.listFiles()) {
                if (subFileName.isFile()) {
                    System.out.println("  File: " + subFileName.getName());
                    continue;
                }
                if (!subFileName.isDirectory()) continue;
                System.out.println("  Dir: " + subFileName.getName());
            }
        }
    }
}

