/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.ssh;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.service.CallbackService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.PropertiesUtils;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class SshActionExecutor
extends ActionExecutor {
    public static final String ACTION_TYPE = "ssh";
    public static final String CONF_SSH_ALLOW_USER_AT_HOST = "oozie.action.ssh.allow.user.at.host";
    protected static final String SSH_COMMAND_OPTIONS = "-o PasswordAuthentication=no -o KbdInteractiveDevices=no -o StrictHostKeyChecking=no -o ConnectTimeout=20 ";
    protected static final String SSH_COMMAND_BASE = "ssh -o PasswordAuthentication=no -o KbdInteractiveDevices=no -o StrictHostKeyChecking=no -o ConnectTimeout=20 ";
    protected static final String SCP_COMMAND_BASE = "scp -o PasswordAuthentication=no -o KbdInteractiveDevices=no -o StrictHostKeyChecking=no -o ConnectTimeout=20 ";
    public static final String ERR_SETUP_FAILED = "SETUP_FAILED";
    public static final String ERR_EXECUTION_FAILED = "EXECUTION_FAILED";
    public static final String ERR_UNKNOWN_ERROR = "UNKOWN_ERROR";
    public static final String ERR_COULD_NOT_CONNECT = "COULD_NOT_CONNECT";
    public static final String ERR_HOST_RESOLUTION = "COULD_NOT_RESOLVE_HOST";
    public static final String ERR_FNF = "FNF";
    public static final String ERR_AUTH_FAILED = "AUTH_FAILED";
    public static final String ERR_NO_EXEC_PERM = "NO_EXEC_PERM";
    public static final String ERR_USER_MISMATCH = "ERR_USER_MISMATCH";
    public static final String ERR_EXCEDE_LEN = "ERR_OUTPUT_EXCEED_MAX_LEN";
    public static final String DELETE_TMP_DIR = "oozie.action.ssh.delete.remote.tmp.dir";
    public static final String HTTP_COMMAND = "oozie.action.ssh.http.command";
    public static final String HTTP_COMMAND_OPTIONS = "oozie.action.ssh.http.command.post.options";
    private static final String EXT_STATUS_VAR = "#status";
    private static int maxLen;
    private static boolean allowSshUserAtHost;

    protected SshActionExecutor() {
        super(ACTION_TYPE);
    }

    @Override
    public void initActionType() {
        super.initActionType();
        maxLen = this.getOozieConf().getInt("oozie.servlet.CallbackServlet.max.data.len", 2048);
        allowSshUserAtHost = this.getOozieConf().getBoolean(CONF_SSH_ALLOW_USER_AT_HOST, true);
        this.registerError(InterruptedException.class.getName(), ActionExecutorException.ErrorType.ERROR, "SH001");
        this.registerError(JDOMException.class.getName(), ActionExecutorException.ErrorType.ERROR, "SH002");
        this.initSshScripts();
    }

    @Override
    public void check(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        WorkflowAction.Status status = this.getActionStatus(context, action);
        boolean captureOutput = false;
        try {
            Element eConf = XmlUtils.parseXml(action.getConf());
            Namespace ns = eConf.getNamespace();
            captureOutput = eConf.getChild("capture-output", ns) != null;
        }
        catch (JDOMException ex) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "ERR_XML_PARSE_FAILED", "unknown error", new Object[]{ex});
        }
        XLog log = XLog.getLog(this.getClass());
        log.debug("Capture Output: {0}", captureOutput);
        if (status == WorkflowAction.Status.OK) {
            if (captureOutput) {
                String outFile = this.getRemoteFileName(context, action, "stdout", false, true);
                String dataCommand = SSH_COMMAND_BASE + action.getTrackerUri() + " cat " + outFile;
                log.debug("Ssh command [{0}]", dataCommand);
                try {
                    Process process = Runtime.getRuntime().exec(dataCommand.split("\\s"));
                    StringBuffer buffer = new StringBuffer();
                    boolean overflow = false;
                    this.drainBuffers(process, buffer, null, maxLen);
                    if (buffer.length() > maxLen) {
                        overflow = true;
                    }
                    if (overflow) {
                        throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, ERR_EXCEDE_LEN, "unknown error");
                    }
                    context.setExecutionData(status.toString(), PropertiesUtils.stringToProperties(buffer.toString()));
                }
                catch (Exception ex) {
                    throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "ERR_UNKNOWN_ERROR", "unknown error", ex);
                }
            } else {
                context.setExecutionData(status.toString(), null);
            }
        } else if (status == WorkflowAction.Status.ERROR) {
            context.setExecutionData(status.toString(), null);
        } else {
            context.setExternalStatus(status.toString());
        }
    }

    @Override
    public void kill(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        String command = "ssh " + action.getTrackerUri() + " kill  -KILL " + action.getExternalId();
        int returnValue = this.getReturnValue(command);
        if (returnValue != 0) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FAILED_TO_KILL", XLog.format("Unable to kill process {0} on {1}", action.getExternalId(), action.getTrackerUri()));
        }
        context.setEndData(WorkflowAction.Status.KILLED, "ERROR");
    }

    @Override
    public void start(final ActionExecutor.Context context, final WorkflowAction action) throws ActionExecutorException {
        Element conf;
        XLog log = XLog.getLog(this.getClass());
        log.info("start() begins");
        String confStr = action.getConf();
        try {
            conf = XmlUtils.parseXml(confStr);
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
        Namespace nameSpace = conf.getNamespace();
        Element hostElement = conf.getChild("host", nameSpace);
        String hostString = hostElement.getValue().trim();
        final String host = hostString = this.prepareUserHost(hostString, context);
        final String dirLocation = this.execute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return SshActionExecutor.this.setupRemote(host, context, action);
            }
        });
        String runningPid = this.execute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return SshActionExecutor.this.checkIfRunning(host, context, action);
            }
        });
        String pid = "";
        if (runningPid == null) {
            boolean ignoreOutput;
            final Element commandElement = conf.getChild("command", nameSpace);
            boolean bl = ignoreOutput = conf.getChild("capture-output", nameSpace) == null;
            if (commandElement != null) {
                List argsList = conf.getChildren("args", nameSpace);
                StringBuilder args = new StringBuilder("");
                if (argsList != null && argsList.size() > 0) {
                    for (Element argsElement : argsList) {
                        args = args.append(argsElement.getValue()).append(" ");
                    }
                    args.setLength(args.length() - 1);
                }
                final String argsString = args.toString();
                final String recoveryId = context.getRecoveryId();
                pid = this.execute(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return SshActionExecutor.this.doExecute(host, dirLocation, commandElement.getValue(), argsString, ignoreOutput, action, recoveryId);
                    }
                });
            }
            context.setStartData(pid, host, host);
        } else {
            pid = runningPid;
            context.setStartData(pid, host, host);
            this.check(context, action);
        }
        log.info("start() ends");
    }

    private String checkIfRunning(String host, ActionExecutor.Context context, WorkflowAction action) {
        String pid = null;
        String outFile = this.getRemoteFileName(context, action, "pid", false, false);
        String getOutputCmd = SSH_COMMAND_BASE + host + " cat " + outFile;
        try {
            Process process = Runtime.getRuntime().exec(getOutputCmd.split("\\s"));
            StringBuffer buffer = new StringBuffer();
            this.drainBuffers(process, buffer, null, maxLen);
            pid = this.getFirstLine(buffer);
            if (Long.valueOf(pid) > 0L) {
                return pid;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getRemoteFileName(ActionExecutor.Context context, WorkflowAction action, String fileExtension, boolean dirOnly, boolean useExtId) {
        String path = this.getActionDirPath(context.getWorkflow().getId(), action, ACTION_TYPE, false) + "/";
        if (dirOnly) {
            return path;
        }
        if (useExtId) {
            path = path + action.getExternalId() + ".";
        }
        path = path + context.getRecoveryId() + "." + fileExtension;
        return path;
    }

    public int executeCommand(String command) throws IOException, InterruptedException {
        Runtime runtime = Runtime.getRuntime();
        Process p = runtime.exec(command.split("\\s"));
        StringBuffer errorBuffer = new StringBuffer();
        int exitValue = this.drainBuffers(p, null, errorBuffer, maxLen);
        String error = null;
        if (exitValue != 0) {
            error = this.getTruncatedString(errorBuffer);
            throw new IOException(XLog.format("Not able to perform operation [{0}]", command) + " | " + "ErrorStream: " + error);
        }
        return exitValue;
    }

    protected String setupRemote(String host, ActionExecutor.Context context, WorkflowAction action) throws IOException, InterruptedException {
        File file;
        XLog log = XLog.getLog(this.getClass());
        log.info("Attempting to copy ssh base scripts to remote host [{0}]", host);
        String localDirLocation = Services.get().getRuntimeDir() + "/ssh";
        if (localDirLocation.endsWith("/")) {
            localDirLocation = localDirLocation.substring(0, localDirLocation.length() - 1);
        }
        if (!(file = new File(localDirLocation + "/ssh-base.sh")).exists()) {
            throw new IOException("Required Local file " + file.getAbsolutePath() + " not present.");
        }
        file = new File(localDirLocation + "/ssh-wrapper.sh");
        if (!file.exists()) {
            throw new IOException("Required Local file " + file.getAbsolutePath() + " not present.");
        }
        String remoteDirLocation = this.getRemoteFileName(context, action, null, true, true);
        String command = XLog.format("{0}{1}  mkdir -p {2} ", SSH_COMMAND_BASE, host, remoteDirLocation).toString();
        this.executeCommand(command);
        command = XLog.format("{0}{1}/ssh-base.sh {2}/ssh-wrapper.sh {3}:{4}", SCP_COMMAND_BASE, localDirLocation, localDirLocation, host, remoteDirLocation);
        this.executeCommand(command);
        command = XLog.format("{0}{1}  chmod +x {2}ssh-base.sh {3}ssh-wrapper.sh ", SSH_COMMAND_BASE, host, remoteDirLocation, remoteDirLocation);
        this.executeCommand(command);
        return remoteDirLocation;
    }

    protected String doExecute(String host, String dirLocation, String cmnd, String args, boolean ignoreOutput, WorkflowAction action, String recoveryId) throws IOException, InterruptedException {
        XLog log = XLog.getLog(this.getClass());
        Runtime runtime = Runtime.getRuntime();
        String callbackPost = ignoreOutput ? "_" : this.getOozieConf().get(HTTP_COMMAND_OPTIONS).replace(" ", "%%%");
        String callBackUrl = Services.get().get(CallbackService.class).createCallBackUrl(action.getId(), EXT_STATUS_VAR);
        String command = XLog.format("{0}{1} {2}ssh-base.sh {3} \"{4}\" \"{5}\" {6} {7} {8} ", SSH_COMMAND_BASE, host, dirLocation, this.getOozieConf().get(HTTP_COMMAND), callBackUrl, callbackPost, recoveryId, cmnd, args).toString();
        log.trace("Executing ssh command [{0}]", command);
        Process p = runtime.exec(command.split("\\s"));
        String pid = "";
        StringBuffer inputBuffer = new StringBuffer();
        StringBuffer errorBuffer = new StringBuffer();
        int exitValue = this.drainBuffers(p, inputBuffer, errorBuffer, maxLen);
        pid = this.getFirstLine(inputBuffer);
        String error = null;
        if (exitValue != 0) {
            error = this.getTruncatedString(errorBuffer);
            throw new IOException(XLog.format("Not able to execute ssh-base.sh on {0}", host) + " | " + "ErrorStream: " + error);
        }
        return pid;
    }

    @Override
    public void end(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        if (action.getExternalStatus().equals("OK")) {
            context.setEndData(WorkflowAction.Status.OK, WorkflowAction.Status.OK.toString());
        } else {
            context.setEndData(WorkflowAction.Status.ERROR, WorkflowAction.Status.ERROR.toString());
        }
        boolean deleteTmpDir = this.getOozieConf().getBoolean(DELETE_TMP_DIR, true);
        if (deleteTmpDir) {
            String tmpDir = this.getRemoteFileName(context, action, null, true, false);
            String removeTmpDirCmd = SSH_COMMAND_BASE + action.getTrackerUri() + " rm -rf " + tmpDir;
            int retVal = this.getReturnValue(removeTmpDirCmd);
            if (retVal != 0) {
                XLog.getLog(this.getClass()).warn("Cannot delete temp dir {0}", tmpDir);
            }
        }
    }

    private int getReturnValue(String command) throws ActionExecutorException {
        int returnValue;
        Process ps = null;
        try {
            ps = Runtime.getRuntime().exec(command.split("\\s"));
            returnValue = this.drainBuffers(ps, null, null, 0);
        }
        catch (IOException e) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FAILED_OPERATION", XLog.format("Not able to perform operation {0}", command), e);
        }
        finally {
            ps.destroy();
        }
        return returnValue;
    }

    private void initSshScripts() {
        String dirLocation = Services.get().getRuntimeDir() + "/ssh";
        File path = new File(dirLocation);
        if (!path.mkdirs()) {
            throw new RuntimeException(XLog.format("Not able to create required directory {0}", dirLocation));
        }
        try {
            IOUtils.copyCharStream(IOUtils.getResourceAsReader("ssh-base.sh", -1), new FileWriter(dirLocation + "/ssh-base.sh"));
            IOUtils.copyCharStream(IOUtils.getResourceAsReader("ssh-wrapper.sh", -1), new FileWriter(dirLocation + "/ssh-wrapper.sh"));
        }
        catch (IOException ie) {
            throw new RuntimeException(XLog.format("Not able to copy required scripts file to {0} for SshActionHandler", dirLocation));
        }
    }

    protected WorkflowAction.Status getActionStatus(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        WorkflowAction.Status aStatus;
        String command = SSH_COMMAND_BASE + action.getTrackerUri() + " ps -p " + action.getExternalId();
        int returnValue = this.getReturnValue(command);
        if (returnValue == 0) {
            aStatus = WorkflowAction.Status.RUNNING;
        } else {
            String outFile = this.getRemoteFileName(context, action, "error", false, true);
            String checkErrorCmd = SSH_COMMAND_BASE + action.getTrackerUri() + " ls " + outFile;
            int retVal = this.getReturnValue(checkErrorCmd);
            aStatus = retVal == 0 ? WorkflowAction.Status.ERROR : WorkflowAction.Status.OK;
        }
        return aStatus;
    }

    private <T> T execute(Callable<T> callable) throws ActionExecutorException {
        XLog log = XLog.getLog(this.getClass());
        try {
            return callable.call();
        }
        catch (IOException ex) {
            log.warn("Error while executing ssh EXECUTION");
            String errorMessage = ex.getMessage();
            if (null == errorMessage) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, ERR_UNKNOWN_ERROR, ex.getMessage(), ex);
            }
            if (errorMessage.contains("Could not resolve hostname") || errorMessage.contains("service not known")) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.TRANSIENT, ERR_HOST_RESOLUTION, ex.getMessage(), ex);
            }
            if (errorMessage.contains("timed out")) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.TRANSIENT, ERR_COULD_NOT_CONNECT, ex.getMessage(), ex);
            }
            if (errorMessage.contains("Required Local file")) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.TRANSIENT, ERR_FNF, ex.getMessage(), ex);
            }
            if (errorMessage.contains("No such file or directory") && (errorMessage.contains("ssh-base") || errorMessage.contains("ssh-wrapper"))) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.TRANSIENT, ERR_FNF, ex.getMessage(), ex);
            }
            if (errorMessage.contains("command not found")) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.NON_TRANSIENT, ERR_FNF, ex.getMessage(), ex);
            }
            if (errorMessage.contains("Permission denied")) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.NON_TRANSIENT, ERR_AUTH_FAILED, ex.getMessage(), ex);
            }
            if (errorMessage.contains(": Permission denied")) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.NON_TRANSIENT, ERR_NO_EXEC_PERM, ex.getMessage(), ex);
            }
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, ERR_UNKNOWN_ERROR, ex.getMessage(), ex);
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    private String prepareUserHost(String host, ActionExecutor.Context context) throws ActionExecutorException {
        String oozieUser = context.getProtoActionConf().get("user.name");
        if (allowSshUserAtHost) {
            if (!host.contains("@")) {
                host = oozieUser + "@" + host;
            }
        } else if (host.contains("@")) {
            if (!host.toLowerCase().startsWith(oozieUser + "@")) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, ERR_USER_MISMATCH, XLog.format("user mismatch between oozie user [{0}] and ssh host [{1}]", oozieUser, host));
            }
        } else {
            host = oozieUser + "@" + host;
        }
        return host;
    }

    @Override
    public boolean isCompleted(String externalStatus) {
        return true;
    }

    private String getTruncatedString(StringBuffer strBuffer) {
        if (strBuffer.length() <= maxLen) {
            return strBuffer.toString();
        }
        return strBuffer.substring(0, maxLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int drainBuffers(Process p, StringBuffer inputBuffer, StringBuffer errorBuffer, int maxLength) throws IOException {
        int exitValue = -1;
        BufferedReader ir = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedReader er = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        int inBytesRead = 0;
        int errBytesRead = 0;
        boolean processEnded = false;
        try {
            while (!processEnded) {
                try {
                    exitValue = p.exitValue();
                    processEnded = true;
                }
                catch (IllegalThreadStateException ex) {
                    // empty catch block
                }
                inBytesRead += this.drainBuffer(ir, inputBuffer, maxLength, inBytesRead, processEnded);
                errBytesRead += this.drainBuffer(er, errorBuffer, maxLength, errBytesRead, processEnded);
            }
        }
        finally {
            ir.close();
            er.close();
        }
        return exitValue;
    }

    private int drainBuffer(BufferedReader br, StringBuffer storageBuf, int maxLength, int bytesRead, boolean readAll) throws IOException {
        int bReadSession = 0;
        if (br.ready()) {
            char[] buf = new char[1024];
            do {
                int bReadCurrent = br.read(buf, 0, 1024);
                if (storageBuf != null && bytesRead < maxLength) {
                    storageBuf.append(buf, 0, bReadCurrent);
                }
                bReadSession += bReadCurrent;
            } while (br.ready() && readAll);
        }
        return bReadSession;
    }

    private String getFirstLine(StringBuffer buffer) {
        int newLineIndex = 0;
        newLineIndex = buffer.indexOf("\n");
        if (newLineIndex == -1) {
            return buffer.toString();
        }
        return buffer.substring(0, newLineIndex);
    }
}

