/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.IOException;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XConfiguration;

public class CoordActionNotificationXCommand
extends CoordinatorXCommand<Void> {
    private final CoordinatorActionBean actionBean;
    private static final String STATUS_PATTERN = "\\$status";
    private static final String ACTION_ID_PATTERN = "\\$actionId";
    private int retries = 0;

    public CoordActionNotificationXCommand(CoordinatorActionBean actionBean) {
        super("coord_action_notification", "coord_action_notification", 0);
        ParamChecker.notNull(actionBean, "Action Bean");
        this.actionBean = actionBean;
    }

    @Override
    protected Void execute() throws CommandException {
        XConfiguration conf;
        this.LOG.info("STARTED Coordinator Notification actionId=" + this.actionBean.getId() + " : " + this.actionBean.getStatus());
        try {
            conf = new XConfiguration(new StringReader(this.actionBean.getRunConf()));
        }
        catch (IOException e1) {
            this.LOG.warn("Configuration parse error. read from DB :" + this.actionBean.getRunConf());
            throw new CommandException(ErrorCode.E1005, e1.getMessage(), e1);
        }
        String url = conf.get("oozie.coord.action.notification.url");
        if (url != null) {
            url = url.replaceAll(ACTION_ID_PATTERN, this.actionBean.getId());
            url = url.replaceAll(STATUS_PATTERN, this.actionBean.getStatus().toString());
            this.LOG.debug("Notification URL :" + url);
            try {
                URL urlObj = new URL(url);
                HttpURLConnection urlConn = (HttpURLConnection)urlObj.openConnection();
                if (urlConn.getResponseCode() != 200) {
                    this.handleRetry(url);
                }
            }
            catch (IOException ex) {
                this.handleRetry(url);
            }
        } else {
            this.LOG.info("No Notification URL is defined. Therefore nothing to notify for job " + this.actionBean.getJobId() + " action ID " + this.actionBean.getId());
        }
        this.LOG.info("ENDED Coordinator Notification actionId=" + this.actionBean.getId());
        return null;
    }

    private void handleRetry(String url) {
        if (this.retries < 3) {
            ++this.retries;
            this.resetUsed();
            this.queue(this, 60000L);
        } else {
            this.LOG.warn(4, "could not send notification [{0}]", url);
        }
    }

    @Override
    protected String getEntityKey() {
        return this.actionBean.getId();
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    protected void loadState() throws CommandException {
        LogUtils.setLogInfo(this.actionBean, this.logInfo);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }
}

