/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.bundle.BundleStatusUpdateXCommand;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.executor.jpa.CoordActionRemoveJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetActionByActionNumberJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.JobUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;

public class CoordChangeXCommand
extends CoordinatorXCommand<Void> {
    private final String jobId;
    private Date newEndTime = null;
    private Integer newConcurrency = null;
    private Date newPauseTime = null;
    private Date oldPauseTime = null;
    private boolean resetPauseTime = false;
    private CoordinatorJobBean coordJob;
    private JPAService jpaService = null;
    private Job.Status prevStatus;
    private static final Set<String> ALLOWED_CHANGE_OPTIONS = new HashSet<String>();

    public CoordChangeXCommand(String id, String changeValue) throws CommandException {
        super("coord_change", "coord_change", 0);
        this.jobId = ParamChecker.notEmpty(id, "id");
        ParamChecker.notEmpty(changeValue, "value");
        this.validateChangeValue(changeValue);
    }

    private void validateChangeValue(String changeValue) throws CommandException {
        String value;
        Map<String, String> map = JobUtils.parseChangeValue(changeValue);
        if (map.size() > ALLOWED_CHANGE_OPTIONS.size()) {
            throw new CommandException(ErrorCode.E1015, changeValue, "must change endtime|concurrency|pausetime");
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value2 = entry.getValue();
            if (!ALLOWED_CHANGE_OPTIONS.contains(key)) {
                throw new CommandException(ErrorCode.E1015, changeValue, "must change endtime|concurrency|pausetime");
            }
            if (key.equals("pausetime") || !value2.equalsIgnoreCase("")) continue;
            throw new CommandException(ErrorCode.E1015, changeValue, "value on " + key + " can not be empty");
        }
        if (map.containsKey("endtime")) {
            value = map.get("endtime");
            try {
                this.newEndTime = DateUtils.parseDateUTC(value);
            }
            catch (Exception ex) {
                throw new CommandException(ErrorCode.E1015, value, "must be a valid date");
            }
        }
        if (map.containsKey("concurrency")) {
            value = map.get("concurrency");
            try {
                this.newConcurrency = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                throw new CommandException(ErrorCode.E1015, value, "must be a valid integer");
            }
        }
        if (map.containsKey("pausetime")) {
            value = map.get("pausetime");
            if (value.equals("")) {
                this.resetPauseTime = true;
            } else {
                try {
                    this.newPauseTime = DateUtils.parseDateUTC(value);
                }
                catch (Exception ex) {
                    throw new CommandException(ErrorCode.E1015, value, "must be a valid date");
                }
            }
        }
    }

    private void checkEndTime(CoordinatorJobBean coordJob, Date newEndTime) throws CommandException {
        Date d;
        Date startTime = coordJob.getStartTime();
        if (newEndTime.before(startTime)) {
            throw new CommandException(ErrorCode.E1015, newEndTime, "cannot be before coordinator job's start time [" + startTime + "]");
        }
        Date lastActionTime = coordJob.getLastActionTime();
        if (lastActionTime != null && !newEndTime.after(d = new Date(lastActionTime.getTime() - (long)(coordJob.getFrequency() * 60 * 1000)))) {
            throw new CommandException(ErrorCode.E1015, newEndTime, "must be after coordinator job's last action time [" + d + "]");
        }
    }

    private void checkPauseTime(CoordinatorJobBean coordJob, Date newPauseTime) throws CommandException {
        Date d = new Date();
        if (newPauseTime.before(d)) {
            throw new CommandException(ErrorCode.E1015, newPauseTime, "must be a non-past time");
        }
    }

    private void processLookaheadActions(CoordinatorJobBean coordJob, Date newPauseTime) throws CommandException {
        Date lastActionTime = coordJob.getLastActionTime();
        if (lastActionTime != null) {
            Date d = new Date(lastActionTime.getTime() - (long)(coordJob.getFrequency() * 60 * 1000));
            int lastActionNumber = coordJob.getLastActionNumber();
            boolean hasChanged = false;
            while (!newPauseTime.after(d)) {
                this.deleteAction(coordJob.getId(), lastActionNumber);
                d = new Date(d.getTime() - (long)(coordJob.getFrequency() * 60 * 1000));
                --lastActionNumber;
                hasChanged = true;
            }
            if (hasChanged) {
                coordJob.setLastActionNumber(lastActionNumber);
                Date d1 = new Date(d.getTime() + (long)(coordJob.getFrequency() * 60 * 1000));
                coordJob.setLastActionTime(d1);
                coordJob.setNextMaterializedTime(d1);
                coordJob.resetDoneMaterialization();
            }
        }
    }

    private void deleteAction(String jobId, int lastActionNum) throws CommandException {
        try {
            CoordinatorActionBean actionBean = this.jpaService.execute(new CoordJobGetActionByActionNumberJPAExecutor(jobId, lastActionNum));
            this.jpaService.execute(new CoordActionRemoveJPAExecutor(actionBean.getId()));
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
    }

    private void check(CoordinatorJobBean coordJob, Date newEndTime, Integer newConcurrency, Date newPauseTime) throws CommandException {
        if (coordJob.getStatus() == Job.Status.KILLED) {
            throw new CommandException(ErrorCode.E1016, new Object[0]);
        }
        if (newEndTime != null) {
            this.checkEndTime(coordJob, newEndTime);
        }
        if (newPauseTime != null) {
            this.checkPauseTime(coordJob, newPauseTime);
        }
    }

    @Override
    protected Void execute() throws CommandException {
        this.LOG.info("STARTED CoordChangeXCommand for jobId=" + this.jobId);
        try {
            if (this.newEndTime != null) {
                this.coordJob.setEndTime(this.newEndTime);
                if (this.coordJob.getStatus() == Job.Status.SUCCEEDED || this.coordJob.getStatus() == Job.Status.RUNNING || this.coordJob.getStatus() == Job.Status.DONEWITHERROR || this.coordJob.getStatus() == Job.Status.FAILED) {
                    this.coordJob.setStatus(Job.Status.RUNNING);
                    this.coordJob.setPending();
                    this.coordJob.resetDoneMaterialization();
                }
            }
            if (this.newConcurrency != null) {
                this.coordJob.setConcurrency(this.newConcurrency);
            }
            if (this.newPauseTime != null || this.resetPauseTime) {
                this.coordJob.setPauseTime(this.newPauseTime);
                if (this.oldPauseTime != null && this.newPauseTime != null) {
                    if (this.oldPauseTime.before(this.newPauseTime) && this.coordJob.getStatus() == Job.Status.PAUSED) {
                        this.coordJob.setStatus(Job.Status.RUNNING);
                    }
                } else if (this.oldPauseTime != null && this.newPauseTime == null && this.coordJob.getStatus() == Job.Status.PAUSED) {
                    this.coordJob.setStatus(Job.Status.RUNNING);
                }
                if (!this.resetPauseTime) {
                    this.processLookaheadActions(this.coordJob, this.newPauseTime);
                }
            }
            this.jpaService.execute(new CoordJobUpdateJPAExecutor(this.coordJob));
            Void void_ = null;
            return void_;
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
        finally {
            this.LOG.info("ENDED CoordChangeXCommand for jobId=" + this.jobId);
            if (this.coordJob.getBundleId() != null) {
                BundleStatusUpdateXCommand bundleStatusUpdate = new BundleStatusUpdateXCommand(this.coordJob, this.prevStatus);
                bundleStatusUpdate.call();
            }
        }
    }

    @Override
    protected String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected void loadState() throws CommandException {
        this.jpaService = Services.get().get(JPAService.class);
        if (this.jpaService == null) {
            throw new CommandException(ErrorCode.E0610, new Object[0]);
        }
        try {
            this.coordJob = this.jpaService.execute(new CoordJobGetJPAExecutor(this.jobId));
            this.oldPauseTime = this.coordJob.getPauseTime();
            this.prevStatus = this.coordJob.getStatus();
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
        LogUtils.setLogInfo(this.coordJob, this.logInfo);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        this.check(this.coordJob, this.newEndTime, this.newConcurrency, this.newPauseTime);
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    static {
        ALLOWED_CHANGE_OPTIONS.add("endtime");
        ALLOWED_CHANGE_OPTIONS.add("concurrency");
        ALLOWED_CHANGE_OPTIONS.add("pausetime");
    }
}

