/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.Date;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.KillTransitionXCommand;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.bundle.BundleStatusUpdateXCommand;
import org.apache.oozie.command.wf.KillXCommand;
import org.apache.oozie.executor.jpa.CoordActionUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetActionsJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.StatusUtils;

public class CoordKillXCommand
extends KillTransitionXCommand {
    private final String jobId;
    private CoordinatorJobBean coordJob;
    private List<CoordinatorActionBean> actionList;
    private JPAService jpaService = null;
    private Job.Status prevStatus = null;

    public CoordKillXCommand(String id) {
        super("coord_kill", "coord_kill", 2);
        this.jobId = ParamChecker.notEmpty(id, "id");
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.jpaService = Services.get().get(JPAService.class);
            if (this.jpaService == null) {
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            this.coordJob = this.jpaService.execute(new CoordJobGetJPAExecutor(this.jobId));
            this.actionList = this.jpaService.execute(new CoordJobGetActionsJPAExecutor(this.jobId));
            this.prevStatus = this.coordJob.getStatus();
            LogUtils.setLogInfo(this.coordJob, this.logInfo);
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (StatusUtils.isV1CoordjobKillable(this.coordJob)) {
            return;
        }
        if (this.coordJob.getStatus() == Job.Status.SUCCEEDED || this.coordJob.getStatus() == Job.Status.FAILED || this.coordJob.getStatus() == Job.Status.DONEWITHERROR) {
            this.LOG.info("CoordKillXCommand not killed - job either finished SUCCEEDED, FAILED or DONEWITHERROR, job id = " + this.jobId + ", status = " + this.coordJob.getStatus());
            throw new PreconditionException(ErrorCode.E1020, this.jobId);
        }
    }

    private void updateCoordAction(CoordinatorActionBean action) throws CommandException {
        action.setStatus(CoordinatorAction.Status.KILLED);
        action.incrementAndGetPending();
        action.setLastModifiedTime(new Date());
        try {
            this.jpaService.execute(new CoordActionUpdateJPAExecutor(action));
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
    }

    @Override
    public void killChildren() throws CommandException {
        try {
            if (this.actionList != null) {
                for (CoordinatorActionBean action : this.actionList) {
                    if (action.getStatus() == CoordinatorAction.Status.FAILED || action.getStatus() == CoordinatorAction.Status.TIMEDOUT || action.getStatus() == CoordinatorAction.Status.SUCCEEDED || action.getStatus() == CoordinatorAction.Status.KILLED) continue;
                    if (action.getExternalId() != null) {
                        this.queue(new KillXCommand(action.getExternalId()));
                        this.updateCoordAction(action);
                        this.LOG.debug("Killed coord action = [{0}], new status = [{1}], pending = [{2}] and queue KillXCommand for [{3}]", action.getId(), action.getStatus(), action.getPending(), action.getExternalId());
                        continue;
                    }
                    this.updateCoordAction(action);
                    this.LOG.debug("Killed coord action = [{0}], current status = [{1}], pending = [{2}]", action.getId(), action.getStatus(), action.getPending());
                }
            }
            this.jpaService.execute(new CoordJobUpdateJPAExecutor(this.coordJob));
            this.LOG.debug("Killed coord actions for the coordinator=[{0}]", this.jobId);
        }
        catch (JPAExecutorException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    public void notifyParent() throws CommandException {
        if (this.coordJob.getBundleId() != null) {
            BundleStatusUpdateXCommand bundleStatusUpdate = new BundleStatusUpdateXCommand(this.coordJob, this.prevStatus);
            bundleStatusUpdate.call();
        }
    }

    @Override
    public void updateJob() throws CommandException {
        try {
            this.jpaService.execute(new CoordJobUpdateJPAExecutor(this.coordJob));
        }
        catch (JPAExecutorException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    public Job getJob() {
        return this.coordJob;
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.jobId;
    }
}

