/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorActionInfo;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordActionInputCheckCommand;
import org.apache.oozie.command.coord.CoordActionNotification;
import org.apache.oozie.command.coord.CoordCommandUtils;
import org.apache.oozie.command.coord.CoordResumeCommand;
import org.apache.oozie.command.coord.CoordinatorCommand;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.store.CoordinatorStore;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.util.db.SLADbOperations;
import org.jdom.Element;
import org.jdom.JDOMException;

public class CoordRerunCommand
extends CoordinatorCommand<CoordinatorActionInfo> {
    private String jobId;
    private String rerunType;
    private String scope;
    private boolean refresh;
    private boolean noCleanup;
    private final XLog log = XLog.getLog(this.getClass());

    public CoordRerunCommand(String jobId, String rerunType, String scope, boolean refresh, boolean noCleanup) {
        super("coord_rerun", "coord_rerun", 1, 1);
        this.jobId = ParamChecker.notEmpty(jobId, "jobId");
        this.rerunType = ParamChecker.notEmpty(rerunType, "rerunType");
        this.scope = ParamChecker.notEmpty(scope, "scope");
        this.refresh = refresh;
        this.noCleanup = noCleanup;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected CoordinatorActionInfo call(CoordinatorStore store) throws StoreException, CommandException {
        try {
            CoordinatorJobBean coordJob = store.getCoordinatorJob(this.jobId, false);
            CoordinatorActionInfo coordInfo = null;
            this.setLogInfo(coordJob);
            if (coordJob.getStatus() != Job.Status.KILLED && coordJob.getStatus() != Job.Status.FAILED) {
                List<CoordinatorActionBean> coordActions;
                this.incrJobCounter(1);
                if (this.rerunType.equals("date")) {
                    coordActions = this.getCoordActionsFromDates(this.jobId, this.scope, store);
                } else {
                    if (!this.rerunType.equals("action")) throw new CommandException(ErrorCode.E1018, "date or action expected.");
                    coordActions = this.getCoordActionsFromIds(this.jobId, this.scope, store);
                }
                if (!this.checkAllActionsRunnable(coordActions)) throw new CommandException(ErrorCode.E1018, "part or all actions are not eligible to rerun!");
                XConfiguration conf = new XConfiguration(new StringReader(coordJob.getConf()));
                Iterator<CoordinatorActionBean> i$ = coordActions.iterator();
                while (i$.hasNext()) {
                    CoordinatorActionBean coordAction = i$.next();
                    String actionXml = coordAction.getActionXml();
                    if (!this.noCleanup) {
                        Element eAction = XmlUtils.parseXml(actionXml);
                        this.cleanupOutputEvents(eAction, coordJob.getUser(), coordJob.getGroup(), conf);
                    }
                    if (this.refresh) {
                        this.refreshAction(coordJob, coordAction, store);
                    }
                    this.updateAction(coordJob, coordAction, actionXml, store);
                    this.queueCallable(new CoordActionNotification(coordAction), 100L);
                    this.queueCallable(new CoordActionInputCheckCommand(coordAction.getId()), 100L);
                }
                return new CoordinatorActionInfo(coordActions);
            }
            this.log.info("CoordRerunCommand is not able to run, job status=" + coordJob.getStatus() + ", jobid=" + this.jobId);
            throw new CommandException(ErrorCode.E1018, "coordinator job is killed or failed so all actions are not eligible to rerun!");
        }
        catch (XException xex) {
            throw new CommandException(xex);
        }
        catch (JDOMException jex) {
            throw new CommandException(ErrorCode.E0700, new Object[]{jex});
        }
        catch (Exception ex) {
            throw new CommandException(ErrorCode.E1018, ex);
        }
    }

    private List<CoordinatorActionBean> getCoordActionsFromIds(String jobId, String scope, CoordinatorStore store) throws CommandException, StoreException {
        String[] list;
        ParamChecker.notEmpty(jobId, "jobId");
        ParamChecker.notEmpty(scope, "scope");
        HashSet<String> actions = new HashSet<String>();
        for (String s : list = scope.split(",")) {
            if ((s = s.trim()).contains("-")) {
                int end;
                String[] range = s.split("-");
                if (range.length != 2) {
                    throw new CommandException(ErrorCode.E0302, "format is wrong for action's range '" + s + "'");
                }
                try {
                    int start = Integer.parseInt(range[0].trim());
                    end = Integer.parseInt(range[1].trim());
                    if (start > end) {
                        throw new CommandException(ErrorCode.E0302, "format is wrong for action's range '" + s + "'");
                    }
                }
                catch (NumberFormatException ne) {
                    throw new CommandException(ErrorCode.E0302, ne);
                }
                for (int i = start; i <= end; ++i) {
                    actions.add(jobId + "@" + i);
                }
                continue;
            }
            try {
                Integer.parseInt(s);
            }
            catch (NumberFormatException ne) {
                throw new CommandException(ErrorCode.E0302, "format is wrong for action id'" + s + "'. Integer only.");
            }
            actions.add(jobId + "@" + s);
        }
        ArrayList<CoordinatorActionBean> coordActions = new ArrayList<CoordinatorActionBean>();
        for (String id : actions) {
            CoordinatorActionBean coordAction = store.getCoordinatorAction(id, false);
            coordActions.add(coordAction);
            this.log.debug("Rerun coordinator for actionId='" + id + "'");
        }
        return coordActions;
    }

    private List<CoordinatorActionBean> getCoordActionsFromDates(String jobId, String scope, CoordinatorStore store) throws CommandException, StoreException {
        String[] list;
        ParamChecker.notEmpty(jobId, "jobId");
        ParamChecker.notEmpty(scope, "scope");
        HashSet<CoordinatorActionBean> actionSet = new HashSet<CoordinatorActionBean>();
        for (String s : list = scope.split(",")) {
            Date date;
            if ((s = s.trim()).contains("::")) {
                Date end;
                Date start;
                String[] dateRange = s.split("::");
                if (dateRange.length != 2) {
                    throw new CommandException(ErrorCode.E0302, "format is wrong for date's range '" + s + "'");
                }
                try {
                    start = DateUtils.parseDateUTC(dateRange[0].trim());
                    end = DateUtils.parseDateUTC(dateRange[1].trim());
                    if (start.after(end)) {
                        throw new CommandException(ErrorCode.E0302, "start date is older than end date: '" + s + "'");
                    }
                }
                catch (Exception e) {
                    throw new CommandException(ErrorCode.E0302, e);
                }
                List<CoordinatorActionBean> listOfActions = this.getActionIdsFromDateRange(jobId, start, end, store);
                actionSet.addAll(listOfActions);
                continue;
            }
            try {
                date = DateUtils.parseDateUTC(s.trim());
            }
            catch (Exception e) {
                throw new CommandException(ErrorCode.E0302, e);
            }
            CoordinatorActionBean coordAction = store.getCoordActionForNominalTime(jobId, date);
            actionSet.add(coordAction);
        }
        ArrayList<CoordinatorActionBean> coordActions = new ArrayList<CoordinatorActionBean>();
        for (CoordinatorActionBean coordAction : actionSet) {
            coordActions.add(coordAction);
            this.log.debug("Rerun coordinator for actionId='" + coordAction.getId() + "'");
        }
        return coordActions;
    }

    private List<CoordinatorActionBean> getActionIdsFromDateRange(String jobId, Date start, Date end, CoordinatorStore store) throws StoreException {
        List<CoordinatorActionBean> list = store.getCoordActionsForDates(jobId, start, end);
        return list;
    }

    private boolean checkAllActionsRunnable(List<CoordinatorActionBean> coordActions) {
        for (CoordinatorActionBean coordAction : coordActions) {
            if (coordAction.isTerminalStatus()) continue;
            return false;
        }
        return true;
    }

    private void cleanupOutputEvents(Element eAction, String user, String group, Configuration conf) {
        Element outputList = eAction.getChild("output-events", eAction.getNamespace());
        if (outputList != null) {
            for (Element data : outputList.getChildren("data-out", eAction.getNamespace())) {
                String[] uriArr;
                String uris;
                if (data.getChild("uris", data.getNamespace()) == null || (uris = data.getChild("uris", data.getNamespace()).getTextTrim()) == null) continue;
                for (String uri : uriArr = uris.split("#")) {
                    Path path = new Path(uri);
                    try {
                        FileSystem fs = Services.get().get(HadoopAccessorService.class).createFileSystem(user, group, path.toUri(), conf);
                        if (fs.exists(path) && !fs.delete(path, true)) {
                            throw new IOException();
                        }
                        this.log.debug("Cleanup the output dir " + path);
                    }
                    catch (Exception ex) {
                        this.log.warn((Object)("Failed to cleanup the output dir " + uri), ex);
                    }
                }
            }
        } else {
            this.log.info("No output-events defined in coordinator xml. Therefore nothing to cleanup");
        }
    }

    private void refreshAction(CoordinatorJobBean coordJob, CoordinatorActionBean coordAction, CoordinatorStore store) throws Exception {
        XConfiguration jobConf = null;
        try {
            jobConf = new XConfiguration(new StringReader(coordJob.getConf()));
        }
        catch (IOException ioe) {
            this.log.warn((Object)("Configuration parse error. read from DB :" + coordJob.getConf()), ioe);
            throw new CommandException(ErrorCode.E1005, ioe);
        }
        String jobXml = coordJob.getJobXml();
        Element eJob = XmlUtils.parseXml(jobXml);
        Date actualTime = new Date();
        String actionXml = CoordCommandUtils.materializeOneInstance(this.jobId, this.dryrun, (Element)eJob.clone(), coordAction.getNominalTime(), actualTime, coordAction.getActionNumber(), jobConf, coordAction);
        this.log.debug("Refresh Action actionId=" + coordAction.getId() + ", actionXml=" + XmlUtils.prettyPrint(actionXml).toString());
        coordAction.setActionXml(actionXml);
    }

    private void updateAction(CoordinatorJobBean coordJob, CoordinatorActionBean coordAction, String actionXml, CoordinatorStore store) throws Exception {
        this.log.debug("updateAction for actionId=" + coordAction.getId());
        coordAction.setStatus(CoordinatorAction.Status.WAITING);
        coordAction.setExternalId("");
        coordAction.setExternalStatus("");
        coordAction.setRerunTime(new Date());
        store.updateCoordinatorAction(coordAction);
        this.writeActionRegistration(coordAction.getActionXml(), coordAction, store, coordJob.getUser(), coordJob.getGroup());
    }

    private void writeActionRegistration(String actionXml, CoordinatorActionBean actionBean, CoordinatorStore store, String user, String group) throws Exception {
        Element eAction = XmlUtils.parseXml(actionXml);
        Element eSla = eAction.getChild("action", eAction.getNamespace()).getChild("info", eAction.getNamespace("sla"));
        SLADbOperations.writeSlaRegistrationEvent(eSla, store, actionBean.getId(), SLAEvent.SlaAppType.COORDINATOR_ACTION, user, group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CoordinatorActionInfo execute(CoordinatorStore store) throws StoreException, CommandException {
        this.log.info("STARTED CoordRerunCommand for jobId=" + this.jobId + ", scope=" + this.scope);
        CoordinatorActionInfo coordInfo = null;
        try {
            if (this.lock(this.jobId)) {
                coordInfo = this.call(store);
            } else {
                this.queueCallable(new CoordResumeCommand(this.jobId), 30000L);
                this.log.warn("CoordRerunCommand lock was not acquired -  failed " + this.jobId + ". Requeing the same.");
            }
        }
        catch (InterruptedException e) {
            this.queueCallable(new CoordResumeCommand(this.jobId), 30000L);
            this.log.warn("CoordRerunCommand lock acquiring failed  with exception " + e.getMessage() + " for job id " + this.jobId + ". Requeing the same.");
        }
        finally {
            this.log.info("ENDED CoordRerunCommand for jobId=" + this.jobId + ", scope=" + this.scope);
        }
        return coordInfo;
    }
}

