/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordActionMaterializeCommand;
import org.apache.oozie.command.coord.CoordJobMatLookupCommand;
import org.apache.oozie.command.coord.CoordinatorCommand;
import org.apache.oozie.coord.CoordELEvaluator;
import org.apache.oozie.coord.CoordELFunctions;
import org.apache.oozie.coord.CoordUtils;
import org.apache.oozie.coord.CoordinatorJobException;
import org.apache.oozie.coord.TimeUnit;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.SchemaService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.store.CoordinatorStore;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.PropertiesUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.xml.sax.SAXException;

public class CoordSubmitCommand
extends CoordinatorCommand<String> {
    private Configuration conf;
    private String authToken;
    private boolean dryrun;
    public static final String CONFIG_DEFAULT = "coord-config-default.xml";
    public static final String COORDINATOR_XML_FILE = "coordinator.xml";
    private static final Set<String> DISALLOWED_USER_PROPERTIES = new HashSet<String>();
    private static final Set<String> DISALLOWED_DEFAULT_PROPERTIES = new HashSet<String>();
    public static final String CONF_DEFAULT_TIMEOUT_NORMAL = "oozie.service.coord.normal.default.timeout";
    private XLog log = XLog.getLog(this.getClass());
    private ELEvaluator evalFreq = null;
    private ELEvaluator evalNofuncs = null;
    private ELEvaluator evalData = null;
    private ELEvaluator evalInst = null;
    private ELEvaluator evalSla = null;

    public CoordSubmitCommand(Configuration conf, String authToken) {
        super("coord_submit", "coord_submit", 1, 1);
        this.conf = ParamChecker.notNull(conf, "conf");
        this.authToken = ParamChecker.notEmpty(authToken, "authToken");
    }

    public CoordSubmitCommand(boolean dryrun, Configuration conf, String authToken) {
        super("coord_submit", "coord_submit", 1, 1, dryrun);
        this.conf = ParamChecker.notNull(conf, "conf");
        this.authToken = ParamChecker.notEmpty(authToken, "authToken");
        this.dryrun = dryrun;
    }

    @Override
    protected String call(CoordinatorStore store) throws StoreException, CommandException {
        String jobId = null;
        this.log.info("STARTED Coordinator Submit");
        this.incrJobCounter(1);
        CoordinatorJobBean coordJob = new CoordinatorJobBean();
        try {
            XLog.Info.get().setParameter("TOKEN", this.conf.get("oozie.wf.log.token"));
            this.mergeDefaultConfig();
            String appXml = this.readAndValidateXml();
            coordJob.setOrigJobXml(appXml);
            this.log.debug("jobXml after initial validation " + XmlUtils.prettyPrint(appXml).toString());
            appXml = XmlUtils.removeComments(appXml);
            this.initEvaluators();
            Element eJob = this.basicResolveAndIncludeDS(appXml, this.conf, coordJob);
            this.log.debug("jobXml after all validation " + XmlUtils.prettyPrint(eJob).toString());
            jobId = this.storeToDB(eJob, store, coordJob);
            this.setLogInfo(coordJob);
            this.log = XLog.getLog(this.getClass());
            if (this.dryrun) {
                Date jobEndTime;
                Date startTime = coordJob.getStartTime();
                long startTimeMilli = startTime.getTime();
                long endTimeMilli = startTimeMilli + 3600000L;
                Date endTime = new Date(endTimeMilli);
                if (endTime.compareTo(jobEndTime = coordJob.getEndTime()) > 0) {
                    endTime = jobEndTime;
                }
                jobId = coordJob.getId();
                this.log.info("[" + jobId + "]: Update status to PREMATER");
                coordJob.setStatus(Job.Status.PREMATER);
                CoordActionMaterializeCommand coordActionMatCom = new CoordActionMaterializeCommand(jobId, startTime, endTime);
                XConfiguration jobConf = null;
                try {
                    jobConf = new XConfiguration(new StringReader(coordJob.getConf()));
                }
                catch (IOException e1) {
                    this.log.warn((Object)("Configuration parse error. read from DB :" + coordJob.getConf()), e1);
                }
                String action = coordActionMatCom.materializeJobs(true, coordJob, jobConf, null);
                String output = coordJob.getJobXml() + System.getProperty("line.separator") + "***actions for instance***" + action;
                return output;
            }
            this.queueCallable(new CoordJobMatLookupCommand(jobId, 3600), 100L);
        }
        catch (CoordinatorJobException ex) {
            this.log.warn((Object)"ERROR:  ", ex);
            throw new CommandException(ex);
        }
        catch (IllegalArgumentException iex) {
            this.log.warn((Object)"ERROR:  ", iex);
            throw new CommandException(ErrorCode.E1003, iex);
        }
        catch (Exception ex) {
            this.log.warn((Object)"ERROR:  ", ex);
            throw new CommandException(ErrorCode.E0803, ex);
        }
        this.log.info("ENDED Coordinator Submit jobId=" + jobId);
        return jobId;
    }

    private String readAndValidateXml() throws CoordinatorJobException {
        String appPath = ParamChecker.notEmpty(this.conf.get("oozie.coord.application.path"), "oozie.coord.application.path");
        String coordXml = this.readDefinition(appPath);
        this.validateXml(coordXml);
        return coordXml;
    }

    private void validateXml(String xmlContent) throws CoordinatorJobException {
        Schema schema = Services.get().get(SchemaService.class).getSchema(SchemaService.SchemaName.COORDINATOR);
        Validator validator = schema.newValidator();
        try {
            validator.validate(new StreamSource(new StringReader(xmlContent)));
        }
        catch (SAXException ex) {
            this.log.warn((Object)"SAXException :", ex);
            throw new CoordinatorJobException(ErrorCode.E0701, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            this.log.warn((Object)"IOException :", ex);
            throw new CoordinatorJobException(ErrorCode.E0702, ex.getMessage(), ex);
        }
    }

    protected void mergeDefaultConfig() throws CommandException {
        Path coordAppDir = new Path(this.conf.get("oozie.coord.application.path")).getParent();
        Path configDefault = new Path(coordAppDir, CONFIG_DEFAULT);
        Configuration fsConfig = CoordUtils.getHadoopConf(this.conf);
        try {
            String user = ParamChecker.notEmpty(this.conf.get("user.name"), "user.name");
            String group = ParamChecker.notEmpty(this.conf.get("group.name"), "group.name");
            FileSystem fs = Services.get().get(HadoopAccessorService.class).createFileSystem(user, group, configDefault.toUri(), this.conf);
            if (fs.exists(configDefault)) {
                XConfiguration defaultConf = new XConfiguration((InputStream)fs.open(configDefault));
                PropertiesUtils.checkDisallowedProperties(defaultConf, DISALLOWED_DEFAULT_PROPERTIES);
                XConfiguration.injectDefaults(defaultConf, this.conf);
            } else {
                this.log.info("configDefault Doesn't exist " + configDefault);
            }
            PropertiesUtils.checkDisallowedProperties(this.conf, DISALLOWED_USER_PROPERTIES);
        }
        catch (IOException e) {
            throw new CommandException(ErrorCode.E0702, e.getMessage() + " : Problem reading default config " + configDefault, e);
        }
        catch (HadoopAccessorException e) {
            throw new CommandException(e);
        }
        this.log.debug("Merged CONF :" + XmlUtils.prettyPrint(this.conf).toString());
    }

    public Element basicResolveAndIncludeDS(String appXml, Configuration conf, CoordinatorJobBean coordJob) throws CoordinatorJobException, Exception {
        Element basicResolvedApp = this.resolveInitial(conf, appXml, coordJob);
        this.includeDataSets(basicResolvedApp, conf);
        return basicResolvedApp;
    }

    private void insertDataSet(Element eAppXml, Element eDatasets) {
        Element outputList;
        Element inputList = eAppXml.getChild("input-events", eAppXml.getNamespace());
        if (inputList != null) {
            for (Element dataIn : inputList.getChildren("data-in", eAppXml.getNamespace())) {
                Element eDataset = CoordSubmitCommand.findDataSet(eDatasets, dataIn.getAttributeValue("dataset"));
                dataIn.getContent().add(0, eDataset);
            }
        }
        if ((outputList = eAppXml.getChild("output-events", eAppXml.getNamespace())) != null) {
            for (Element dataOut : outputList.getChildren("data-out", eAppXml.getNamespace())) {
                Element eDataset = CoordSubmitCommand.findDataSet(eDatasets, dataOut.getAttributeValue("dataset"));
                dataOut.getContent().add(0, eDataset);
            }
        }
    }

    private static Element findDataSet(Element eDatasets, String name) {
        for (Element eDataset : eDatasets.getChildren("dataset", eDatasets.getNamespace())) {
            if (!eDataset.getAttributeValue("name").equals(name)) continue;
            eDataset = (Element)eDataset.clone();
            eDataset.detach();
            return eDataset;
        }
        throw new RuntimeException("undefined dataset: " + name);
    }

    protected void initEvaluators() {
        this.evalFreq = CoordELEvaluator.createELEvaluatorForGroup(this.conf, "coord-job-submit-freq");
        this.evalNofuncs = CoordELEvaluator.createELEvaluatorForGroup(this.conf, "coord-job-submit-nofuncs");
        this.evalInst = CoordELEvaluator.createELEvaluatorForGroup(this.conf, "coord-job-submit-instances");
        this.evalSla = CoordELEvaluator.createELEvaluatorForGroup(this.conf, "coord-sla-submit");
    }

    protected Element resolveInitial(Configuration conf, String appXml, CoordinatorJobBean coordJob) throws CoordinatorJobException, Exception {
        Element eAppXml = XmlUtils.parseXml(appXml);
        String val = this.resolveAttribute("frequency", eAppXml, this.evalFreq);
        int ival = ParamChecker.checkInteger(val, "frequency");
        ParamChecker.checkGTZero(ival, "frequency");
        coordJob.setFrequency(ival);
        TimeUnit tmp = this.evalFreq.getVariable("timeunit") == null ? TimeUnit.MINUTE : (TimeUnit)((Object)this.evalFreq.getVariable("timeunit"));
        this.addAnAttribute("freq_timeunit", eAppXml, tmp.toString());
        coordJob.setTimeUnit(CoordinatorJob.Timeunit.valueOf((String)tmp.toString()));
        tmp = this.evalFreq.getVariable("endOfDuration") == null ? TimeUnit.NONE : (TimeUnit)((Object)this.evalFreq.getVariable("endOfDuration"));
        this.addAnAttribute("end_of_duration", eAppXml, tmp.toString());
        val = this.resolveAttribute("start", eAppXml, this.evalNofuncs);
        ParamChecker.checkUTC(val, "start");
        coordJob.setStartTime(DateUtils.parseDateUTC(val));
        val = this.resolveAttribute("end", eAppXml, this.evalNofuncs);
        ParamChecker.checkUTC(val, "end");
        coordJob.setEndTime(DateUtils.parseDateUTC(val));
        val = this.resolveAttribute("timezone", eAppXml, this.evalNofuncs);
        ParamChecker.checkTimeZone(val, "timezone");
        coordJob.setTimeZone(val);
        val = this.resolveTagContents("timeout", eAppXml.getChild("controls", eAppXml.getNamespace()), this.evalNofuncs);
        if (val == "") {
            val = Services.get().getConf().get(CONF_DEFAULT_TIMEOUT_NORMAL);
        }
        ival = ParamChecker.checkInteger(val, "timeout");
        coordJob.setTimeout(ival);
        val = this.resolveTagContents("concurrency", eAppXml.getChild("controls", eAppXml.getNamespace()), this.evalNofuncs);
        if (val == "") {
            val = "-1";
        }
        ival = ParamChecker.checkInteger(val, "concurrency");
        coordJob.setConcurrency(ival);
        val = this.resolveTagContents("execution", eAppXml.getChild("controls", eAppXml.getNamespace()), this.evalNofuncs);
        if (val == "") {
            val = CoordinatorJob.Execution.FIFO.toString();
        }
        coordJob.setExecution(CoordinatorJob.Execution.valueOf((String)val));
        String[] acceptedVals = new String[]{CoordinatorJob.Execution.LIFO.toString(), CoordinatorJob.Execution.FIFO.toString(), CoordinatorJob.Execution.LAST_ONLY.toString()};
        ParamChecker.isMember(val, acceptedVals, "execution");
        this.resolveTagContents("include", eAppXml.getChild("datasets", eAppXml.getNamespace()), this.evalNofuncs);
        this.resolveDataSets(eAppXml);
        HashMap<String, String> dataNameList = new HashMap<String, String>();
        this.resolveIOEvents(eAppXml, dataNameList);
        this.resolveTagContents("app-path", eAppXml.getChild("action", eAppXml.getNamespace()).getChild("workflow", eAppXml.getNamespace()), this.evalNofuncs);
        Element configElem = eAppXml.getChild("action", eAppXml.getNamespace()).getChild("workflow", eAppXml.getNamespace()).getChild("configuration", eAppXml.getNamespace());
        this.evalData = CoordELEvaluator.createELEvaluatorForDataEcho(conf, "coord-job-submit-data", dataNameList);
        if (configElem != null) {
            for (Element propElem : configElem.getChildren("property", configElem.getNamespace())) {
                this.resolveTagContents("name", propElem, this.evalData);
                Element tmpProp = (Element)propElem.clone();
                this.resolveTagContents("value", tmpProp, this.evalData);
            }
        }
        this.resolveSLA(eAppXml, coordJob);
        return eAppXml;
    }

    private void resolveSLA(Element eAppXml, CoordinatorJobBean coordJob) throws CommandException {
        Element eSla = eAppXml.getChild("action", eAppXml.getNamespace()).getChild("info", Namespace.getNamespace((String)"uri:oozie:sla:0.1"));
        if (eSla != null) {
            String slaXml = XmlUtils.prettyPrint(eSla).toString();
            try {
                slaXml = this.evalSla.evaluate(slaXml, String.class);
                XmlUtils.validateData(slaXml, SchemaService.SchemaName.SLA_ORIGINAL);
            }
            catch (Exception e) {
                throw new CommandException(ErrorCode.E1004, "Validation ERROR :" + e.getMessage(), e);
            }
        }
    }

    private void resolveIOEvents(Element eJobOrg, HashMap<String, String> dataNameList) throws CoordinatorJobException {
        Element outputList;
        Element eJob = (Element)eJobOrg.clone();
        Element inputList = eJob.getChild("input-events", eJob.getNamespace());
        if (inputList != null) {
            TreeSet<String> eventNameSet = new TreeSet<String>();
            for (Element dataIn : inputList.getChildren("data-in", eJob.getNamespace())) {
                String dataInName = dataIn.getAttributeValue("name");
                dataNameList.put(dataInName, "data-in");
                if (eventNameSet.contains(dataInName)) {
                    throw new RuntimeException("Duplicate dataIn name " + dataInName);
                }
                eventNameSet.add(dataInName);
                this.resolveTagContents("instance", dataIn, this.evalInst);
                this.resolveTagContents("start-instance", dataIn, this.evalInst);
                this.resolveTagContents("end-instance", dataIn, this.evalInst);
            }
        }
        if ((outputList = eJob.getChild("output-events", eJob.getNamespace())) != null) {
            TreeSet<String> eventNameSet = new TreeSet<String>();
            for (Element dataOut : outputList.getChildren("data-out", eJob.getNamespace())) {
                String dataOutName = dataOut.getAttributeValue("name");
                dataNameList.put(dataOutName, "data-out");
                if (eventNameSet.contains(dataOutName)) {
                    throw new RuntimeException("Duplicate dataIn name " + dataOutName);
                }
                eventNameSet.add(dataOutName);
                this.resolveTagContents("instance", dataOut, this.evalInst);
            }
        }
    }

    private void addAnAttribute(String attrName, Element elem, String value) {
        elem.setAttribute(attrName, value);
    }

    private void resolveDataSets(Element eAppXml) throws Exception {
        Element datasetList = eAppXml.getChild("datasets", eAppXml.getNamespace());
        if (datasetList != null) {
            List dsElems = datasetList.getChildren("dataset", eAppXml.getNamespace());
            this.resolveDataSets(dsElems);
            this.resolveTagContents("app-path", eAppXml.getChild("action", eAppXml.getNamespace()).getChild("workflow", eAppXml.getNamespace()), this.evalNofuncs);
        }
    }

    private void resolveDataSets(List<Element> dsElems) throws CoordinatorJobException {
        for (Element dsElem : dsElems) {
            this.evalFreq.setVariable("timeunit", (Object)TimeUnit.MINUTE);
            this.evalFreq.setVariable("endOfDuration", (Object)TimeUnit.NONE);
            String val = this.resolveAttribute("frequency", dsElem, this.evalFreq);
            int ival = ParamChecker.checkInteger(val, "frequency");
            ParamChecker.checkGTZero(ival, "frequency");
            this.addAnAttribute("freq_timeunit", dsElem, this.evalFreq.getVariable("timeunit") == null ? TimeUnit.MINUTE.toString() : ((TimeUnit)((Object)this.evalFreq.getVariable("timeunit"))).toString());
            this.addAnAttribute("end_of_duration", dsElem, this.evalFreq.getVariable("endOfDuration") == null ? TimeUnit.NONE.toString() : ((TimeUnit)((Object)this.evalFreq.getVariable("endOfDuration"))).toString());
            val = this.resolveAttribute("initial-instance", dsElem, this.evalNofuncs);
            ParamChecker.checkUTC(val, "initial-instance");
            val = this.resolveAttribute("timezone", dsElem, this.evalNofuncs);
            ParamChecker.checkTimeZone(val, "timezone");
            this.resolveTagContents("uri-template", dsElem, this.evalNofuncs);
            this.resolveTagContents("done-flag", dsElem, this.evalNofuncs);
        }
    }

    private String resolveTagContents(String tagName, Element elem, ELEvaluator eval) throws CoordinatorJobException {
        String ret = "";
        if (elem != null) {
            for (Element tagElem : elem.getChildren(tagName, elem.getNamespace())) {
                String updated;
                if (tagElem == null) continue;
                try {
                    updated = CoordELFunctions.evalAndWrap(eval, tagElem.getText().trim());
                }
                catch (Exception e) {
                    throw new CoordinatorJobException(ErrorCode.E1004, e.getMessage(), e);
                }
                tagElem.removeContent();
                tagElem.addContent(updated);
                ret = ret + updated;
            }
        }
        return ret;
    }

    private String resolveAttribute(String attrName, Element elem, ELEvaluator eval) throws CoordinatorJobException {
        Attribute attr = elem.getAttribute(attrName);
        String val = null;
        if (attr != null) {
            try {
                val = CoordELFunctions.evalAndWrap(eval, attr.getValue().trim());
            }
            catch (Exception e) {
                throw new CoordinatorJobException(ErrorCode.E1004, e.getMessage(), e);
            }
            attr.setValue(val);
        }
        return val;
    }

    protected void includeDataSets(Element resolvedXml, Configuration conf) throws CoordinatorJobException {
        Element datasets = resolvedXml.getChild("datasets", resolvedXml.getNamespace());
        Element allDataSets = new Element("all_datasets", resolvedXml.getNamespace());
        ArrayList<String> dsList = new ArrayList<String>();
        if (datasets != null) {
            for (Element includeElem : datasets.getChildren("include", datasets.getNamespace())) {
                String incDSFile = includeElem.getTextTrim();
                this.includeOneDSFile(incDSFile, dsList, allDataSets, datasets.getNamespace());
            }
            for (Element e : datasets.getChildren("dataset", datasets.getNamespace())) {
                String dsName = e.getAttributeValue("name");
                if (dsList.contains(dsName)) {
                    CoordSubmitCommand.removeDataSet(allDataSets, dsName);
                } else {
                    dsList.add(dsName);
                }
                allDataSets.addContent((Content)((Element)e.clone()));
            }
        }
        this.insertDataSet(resolvedXml, allDataSets);
        resolvedXml.removeChild("datasets", resolvedXml.getNamespace());
    }

    private void includeOneDSFile(String incDSFile, List<String> dsList, Element allDataSets, Namespace dsNameSpace) throws CoordinatorJobException {
        Element tmpDataSets = null;
        try {
            String dsXml = this.readDefinition(incDSFile);
            this.log.debug("DSFILE :" + incDSFile + "\n" + dsXml);
            tmpDataSets = XmlUtils.parseXml(dsXml);
        }
        catch (JDOMException e) {
            this.log.warn("Error parsing included dataset [{0}].  Message [{1}]", incDSFile, e.getMessage());
            throw new CoordinatorJobException(ErrorCode.E0700, e.getMessage());
        }
        this.resolveDataSets(tmpDataSets.getChildren("dataset"));
        for (Element e : tmpDataSets.getChildren("dataset")) {
            String dsName = e.getAttributeValue("name");
            if (dsList.contains(dsName)) {
                throw new RuntimeException("Duplicate Dataset " + dsName);
            }
            dsList.add(dsName);
            Element tmp = (Element)e.clone();
            tmp.setNamespace(dsNameSpace);
            tmp.getChild("uri-template").setNamespace(dsNameSpace);
            if (e.getChild("done-flag") != null) {
                tmp.getChild("done-flag").setNamespace(dsNameSpace);
            }
            allDataSets.addContent((Content)tmp);
        }
        for (Element includeElem : tmpDataSets.getChildren("include", tmpDataSets.getNamespace())) {
            String incFile = includeElem.getTextTrim();
            this.includeOneDSFile(incFile, dsList, allDataSets, dsNameSpace);
        }
    }

    private static void removeDataSet(Element eDatasets, String name) {
        for (Element eDataset : eDatasets.getChildren("dataset", eDatasets.getNamespace())) {
            if (!eDataset.getAttributeValue("name").equals(name)) continue;
            eDataset.detach();
        }
        throw new RuntimeException("undefined dataset: " + name);
    }

    protected String readDefinition(String appPath) throws CoordinatorJobException {
        String user = ParamChecker.notEmpty(this.conf.get("user.name"), "user.name");
        String group = ParamChecker.notEmpty(this.conf.get("group.name"), "group.name");
        Configuration confHadoop = CoordUtils.getHadoopConf(this.conf);
        try {
            URI uri = new URI(appPath);
            this.log.debug("user =" + user + " group =" + group);
            FileSystem fs = Services.get().get(HadoopAccessorService.class).createFileSystem(user, group, uri, this.conf);
            Path p = new Path(uri.getPath());
            InputStreamReader reader = new InputStreamReader((InputStream)fs.open(p));
            StringWriter writer = new StringWriter();
            IOUtils.copyCharStream(reader, writer);
            return writer.toString();
        }
        catch (IOException ex) {
            this.log.warn((Object)("IOException :" + XmlUtils.prettyPrint(confHadoop)), ex);
            throw new CoordinatorJobException(ErrorCode.E1001, ex.getMessage(), ex);
        }
        catch (URISyntaxException ex) {
            this.log.warn("URISyException :" + ex.getMessage());
            throw new CoordinatorJobException(ErrorCode.E1002, appPath, ex.getMessage(), ex);
        }
        catch (HadoopAccessorException ex) {
            throw new CoordinatorJobException(ex);
        }
        catch (Exception ex) {
            this.log.warn((Object)"Exception :", ex);
            throw new CoordinatorJobException(ErrorCode.E1001, ex.getMessage(), ex);
        }
    }

    private String storeToDB(Element eJob, CoordinatorStore store, CoordinatorJobBean coordJob) throws StoreException {
        String jobId = Services.get().get(UUIDService.class).generateId(UUIDService.ApplicationType.COORDINATOR);
        coordJob.setId(jobId);
        coordJob.setAuthToken(this.authToken);
        coordJob.setAppName(eJob.getAttributeValue("name"));
        coordJob.setAppPath(this.conf.get("oozie.coord.application.path"));
        coordJob.setStatus(Job.Status.PREP);
        coordJob.setCreatedTime(new Date());
        coordJob.setUser(this.conf.get("user.name"));
        coordJob.setGroup(this.conf.get("group.name"));
        coordJob.setConf(XmlUtils.prettyPrint(this.conf).toString());
        coordJob.setJobXml(XmlUtils.prettyPrint(eJob).toString());
        coordJob.setLastActionNumber(0);
        coordJob.setLastModifiedTime(new Date());
        if (!this.dryrun) {
            store.insertCoordinatorJob(coordJob);
        }
        return jobId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.coord.application.path", "file:///homes/test/workspace/sandbox_krishna/oozie-main/core/src/main/java/org/apache/oozie/coord/");
        conf.set("user.name", "test");
        conf.set("group.name", "other");
        new Services().init();
        try {
            CoordSubmitCommand sc = new CoordSubmitCommand(conf, "TESTING");
            String jobId = (String)sc.call();
            System.out.println("Job Id " + jobId);
            Thread.sleep(80000L);
        }
        finally {
            Services.get().destroy();
        }
    }

    static {
        String[] badUserProps = new String[]{"YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "DAYS", "HOURS", "MINUTES", "KB", "MB", "GB", "TB", "PB", "RECORDS", "MAP_IN", "MAP_OUT", "REDUCE_IN", "REDUCE_OUT", "GROUPS"};
        PropertiesUtils.createPropertySet(badUserProps, DISALLOWED_USER_PROPERTIES);
        String[] badDefaultProps = new String[]{"user.name", "hadoop.job.ugi", "mapreduce.jobtracker.kerberos.principal", "dfs.namenode.kerberos.principal"};
        PropertiesUtils.createPropertySet(badUserProps, DISALLOWED_DEFAULT_PROPERTIES);
        PropertiesUtils.createPropertySet(badDefaultProps, DISALLOWED_DEFAULT_PROPERTIES);
    }
}

