/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.sql.Timestamp;
import java.util.Date;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.wf.ActionCommand;
import org.apache.oozie.command.wf.ActionEndCommand;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.store.WorkflowStore;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XLog;

public class ActionCheckCommand
extends ActionCommand<Void> {
    public static final String EXEC_DATA_MISSING = "EXEC_DATA_MISSING";
    private String id;
    private String jobId;
    private int actionCheckDelay;

    public ActionCheckCommand(String id) {
        this(id, -1);
    }

    public ActionCheckCommand(String id, int priority, int checkDelay) {
        super("action.check", "action.check", priority);
        this.id = id;
        this.actionCheckDelay = checkDelay;
    }

    public ActionCheckCommand(String id, int checkDelay) {
        this(id, 0, checkDelay);
    }

    @Override
    protected Void call(WorkflowStore store) throws StoreException, CommandException {
        WorkflowJobBean workflow = store.getWorkflow(this.jobId, false);
        this.setLogInfo(workflow);
        WorkflowActionBean action = store.getAction(this.id, false);
        this.setLogInfo(action);
        if (action.isPending() && action.getStatus() == WorkflowAction.Status.RUNNING) {
            this.setLogInfo(workflow);
            if (this.actionCheckDelay > 0) {
                Timestamp actionCheckTs = new Timestamp(System.currentTimeMillis() - (long)(this.actionCheckDelay * 1000));
                Timestamp actionLmt = action.getLastCheckTimestamp();
                if (actionLmt.after(actionCheckTs)) {
                    XLog.getLog(this.getClass()).debug("The wf action :" + this.id + " has been udated recently. Ignoring ActionCheckCommand!");
                    return null;
                }
            }
            if (workflow.getStatus() == WorkflowJob.Status.RUNNING) {
                ActionExecutor executor = Services.get().get(ActionService.class).getExecutor(action.getType());
                if (executor != null) {
                    ActionCommand.ActionExecutorContext context = null;
                    try {
                        boolean isRetry = false;
                        context = new ActionCommand.ActionExecutorContext(workflow, action, isRetry);
                        this.incrActionCounter(action.getType(), 1);
                        Instrumentation.Cron cron = new Instrumentation.Cron();
                        cron.start();
                        executor.check(context, action);
                        cron.stop();
                        this.addActionCron(action.getType(), cron);
                        if (action.isExecutionComplete()) {
                            if (!context.isExecuted()) {
                                XLog.getLog(this.getClass()).warn(4, "Action Completed, ActionExecutor [{0}] must call setExecutionData()", executor.getType());
                                action.setErrorInfo(EXEC_DATA_MISSING, "Execution Complete, but Execution Data Missing from Action");
                                this.failJob(context);
                                action.setLastCheckTime(new Date());
                                store.updateAction(action);
                                store.updateWorkflow(workflow);
                                return null;
                            }
                            action.setPending();
                            this.queueCallable(new ActionEndCommand(action.getId(), action.getType()));
                        }
                        action.setLastCheckTime(new Date());
                        store.updateAction(action);
                        store.updateWorkflow(workflow);
                    }
                    catch (ActionExecutorException ex) {
                        XLog.getLog(this.getClass()).warn("Exception while executing check(). Error Code [{0}], Message[{1}]", ex.getErrorCode(), ex.getMessage(), ex);
                        switch (ex.getErrorType()) {
                            case FAILED: {
                                this.failAction(workflow, action);
                            }
                        }
                        action.setLastCheckTime(new Date());
                        store.updateAction(action);
                        store.updateWorkflow(workflow);
                        return null;
                    }
                }
            } else {
                action.setLastCheckTime(new Date());
                store.updateAction(action);
                XLog.getLog(this.getClass()).warn("Action [{0}] status is running but WF Job [{1}] status is [{2}]. Expected status is RUNNING.", action.getId(), workflow.getId(), workflow.getStatus());
            }
        }
        return null;
    }

    private void failAction(WorkflowJobBean workflow, WorkflowActionBean action) throws CommandException {
        XLog.getLog(this.getClass()).warn("Failing Job [{0}] due to failed action [{1}]", workflow.getId(), action.getId());
        action.resetPending();
        action.setStatus(WorkflowAction.Status.FAILED);
        workflow.setStatus(WorkflowJob.Status.FAILED);
        this.incrJobCounter("failed", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        new Services().init();
        try {
            new ActionCheckCommand("0000001-100122154231282-oozie-dani-W@pig1").call();
            Thread.sleep(100000L);
        }
        finally {
            new Services().destroy();
        }
    }

    @Override
    protected Void execute(WorkflowStore store) throws CommandException, StoreException {
        try {
            XLog.getLog(this.getClass()).debug("STARTED ActionCheckCommand for wf actionId=" + this.id + " priority =" + this.getPriority());
            this.jobId = Services.get().get(UUIDService.class).getId(this.id);
            if (this.lock(this.jobId)) {
                this.call(store);
            } else {
                this.queueCallable(new ActionCheckCommand(this.id, this.actionCheckDelay), 30000L);
                XLog.getLog(this.getClass()).warn("ActionCheckCommand lock was not acquired - failed {0}", this.id);
            }
        }
        catch (InterruptedException e) {
            this.queueCallable(new ActionCheckCommand(this.id, this.actionCheckDelay), 30000L);
            XLog.getLog(this.getClass()).warn("ActionCheckCommand lock was not acquired - interrupted exception failed {0}", this.id);
        }
        XLog.getLog(this.getClass()).debug("ENDED ActionCheckCommand for wf actionId=" + this.id + ", jobId=" + this.jobId);
        return null;
    }
}

