/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.command.wf.WorkflowCommand;
import org.apache.oozie.store.WorkflowStore;
import org.apache.oozie.util.XLog;

public class NotificationCommand
extends WorkflowCommand<Void> {
    private static final String STATUS_PATTERN = "\\$status";
    private static final String JOB_ID_PATTERN = "\\$jobId";
    private static final String NODE_NAME_PATTERN = "\\$nodeName";
    private String url;
    private int retries = 0;

    public NotificationCommand(WorkflowJobBean workflow) {
        super("job.notification", "job.notification", 0, 1, false);
        this.url = workflow.getWorkflowInstance().getConf().get("oozie.wf.workflow.notification.url");
        if (this.url != null) {
            this.url = this.url.replaceAll(JOB_ID_PATTERN, workflow.getId());
            this.url = this.url.replaceAll(STATUS_PATTERN, workflow.getStatus().toString());
        }
    }

    public NotificationCommand(WorkflowJobBean workflow, WorkflowActionBean action) {
        super("action.notification", "job.notification", 0, 1);
        this.url = workflow.getWorkflowInstance().getConf().get("oozie.wf.action.notification.url");
        if (this.url != null) {
            this.url = this.url.replaceAll(JOB_ID_PATTERN, workflow.getId());
            this.url = this.url.replaceAll(NODE_NAME_PATTERN, action.getName());
            this.url = action.isComplete() ? this.url.replaceAll(STATUS_PATTERN, "T:" + action.getTransition()) : this.url.replaceAll(STATUS_PATTERN, "S:" + action.getStatus().toString());
        }
    }

    @Override
    public Void call(WorkflowStore store) {
        if (this.url != null) {
            try {
                URL url = new URL(this.url);
                HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
                if (urlConn.getResponseCode() != 200) {
                    this.handleRetry();
                }
            }
            catch (IOException ex) {
                this.handleRetry();
            }
        }
        return null;
    }

    private void handleRetry() {
        if (this.retries < 3) {
            ++this.retries;
            this.queueCallable(this, 60000L);
        } else {
            XLog.getLog(this.getClass()).warn(4, "could not send notification [{0}]", this.url);
        }
    }
}

