/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.Date;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordActionUpdateXCommand;
import org.apache.oozie.command.wf.ActionEndXCommand;
import org.apache.oozie.command.wf.ActionStartXCommand;
import org.apache.oozie.command.wf.NotificationXCommand;
import org.apache.oozie.command.wf.WorkflowXCommand;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetActionsJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobUpdateJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.InstrumentUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.LiteWorkflowInstance;

public class ResumeXCommand
extends WorkflowXCommand<Void> {
    private String id;
    private JPAService jpaService = null;
    private WorkflowJobBean workflow = null;

    public ResumeXCommand(String id) {
        super("resume", "resume", 1);
        this.id = ParamChecker.notEmpty(id, "id");
    }

    @Override
    protected Void execute() throws CommandException {
        try {
            WorkflowInstance wfInstance;
            if (this.workflow.getStatus() == WorkflowJob.Status.SUSPENDED) {
                InstrumentUtils.incrJobCounter(this.getName(), 1, this.getInstrumentation());
                this.workflow.getWorkflowInstance().resume();
                wfInstance = this.workflow.getWorkflowInstance();
                ((LiteWorkflowInstance)wfInstance).setStatus(WorkflowInstance.Status.RUNNING);
                this.workflow.setWorkflowInstance(wfInstance);
                this.workflow.setStatus(WorkflowJob.Status.RUNNING);
                for (WorkflowActionBean action : this.jpaService.execute(new WorkflowJobGetActionsJPAExecutor(this.id))) {
                    Date nextRunTime;
                    if (action.isRetryOrManual()) {
                        action.setPendingOnly();
                        this.jpaService.execute(new WorkflowActionUpdateJPAExecutor(action));
                    }
                    if (!action.isPending()) continue;
                    if (action.getStatus() == WorkflowAction.Status.PREP || action.getStatus() == WorkflowAction.Status.START_MANUAL) {
                        this.queue(new ActionStartXCommand(action.getId(), action.getType()));
                        continue;
                    }
                    if (action.getStatus() == WorkflowAction.Status.START_RETRY) {
                        nextRunTime = action.getPendingAge();
                        this.queue(new ActionStartXCommand(action.getId(), action.getType()), nextRunTime.getTime() - System.currentTimeMillis());
                        continue;
                    }
                    if (action.getStatus() == WorkflowAction.Status.DONE || action.getStatus() == WorkflowAction.Status.END_MANUAL) {
                        this.queue(new ActionEndXCommand(action.getId(), action.getType()));
                        continue;
                    }
                    if (action.getStatus() != WorkflowAction.Status.END_RETRY) continue;
                    nextRunTime = action.getPendingAge();
                    this.queue(new ActionEndXCommand(action.getId(), action.getType()), nextRunTime.getTime() - System.currentTimeMillis());
                }
                this.jpaService.execute(new WorkflowJobUpdateJPAExecutor(this.workflow));
                this.queue(new NotificationXCommand(this.workflow));
            }
            wfInstance = null;
            return wfInstance;
        }
        catch (WorkflowException ex) {
            throw new CommandException(ex);
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
        finally {
            new CoordActionUpdateXCommand(this.workflow).call();
        }
    }

    @Override
    protected String getEntityKey() {
        return this.id;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void loadState() throws CommandException {
        this.jpaService = Services.get().get(JPAService.class);
        if (this.jpaService == null) {
            throw new CommandException(ErrorCode.E0610, new Object[0]);
        }
        try {
            this.workflow = this.jpaService.execute(new WorkflowJobGetJPAExecutor(this.id));
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
        LogUtils.setLogInfo(this.workflow, this.logInfo);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.workflow.getStatus() != WorkflowJob.Status.SUSPENDED) {
            throw new PreconditionException(ErrorCode.E1100, "workflow's status is " + this.workflow.getStatusStr() + " is not SUSPENDED");
        }
    }
}

