/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.StringReader;
import java.util.Date;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordActionUpdateXCommand;
import org.apache.oozie.command.wf.ActionKillXCommand;
import org.apache.oozie.command.wf.ActionStartXCommand;
import org.apache.oozie.command.wf.ActionXCommand;
import org.apache.oozie.command.wf.NotificationXCommand;
import org.apache.oozie.command.wf.SubmitCommand;
import org.apache.oozie.command.wf.WfEndXCommand;
import org.apache.oozie.command.wf.WorkflowXCommand;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionInsertJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobUpdateJPAExecutor;
import org.apache.oozie.service.ELService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.InstrumentUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.util.db.SLADbXOperations;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.KillNodeDef;
import org.apache.oozie.workflow.lite.NodeDef;
import org.jdom.Element;
import org.jdom.Namespace;

public class SignalXCommand
extends WorkflowXCommand<Void> {
    protected static final String INSTR_SUCCEEDED_JOBS_COUNTER_NAME = "succeeded";
    private JPAService jpaService = null;
    private String jobId;
    private String actionId;
    private WorkflowJobBean wfJob;
    private WorkflowActionBean wfAction;

    public SignalXCommand(String name, int priority, String jobId) {
        super(name, name, priority);
        this.jobId = ParamChecker.notEmpty(jobId, "jobId");
    }

    public SignalXCommand(String jobId, String actionId) {
        this("signal", 1, jobId);
        this.actionId = ParamChecker.notEmpty(actionId, "actionId");
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected void loadState() throws CommandException {
        block4: {
            try {
                this.jpaService = Services.get().get(JPAService.class);
                if (this.jpaService != null) {
                    this.wfJob = this.jpaService.execute(new WorkflowJobGetJPAExecutor(this.jobId));
                    LogUtils.setLogInfo(this.wfJob, this.logInfo);
                    if (this.actionId != null) {
                        this.wfAction = this.jpaService.execute(new WorkflowActionGetJPAExecutor(this.actionId));
                        LogUtils.setLogInfo(this.wfAction, this.logInfo);
                    }
                    break block4;
                }
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            catch (XException ex) {
                throw new CommandException(ex);
            }
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.wfAction == null || this.wfAction.isComplete() && this.wfAction.isPending()) {
            if (this.wfJob.getStatus() != WorkflowJob.Status.RUNNING && this.wfJob.getStatus() != WorkflowJob.Status.PREP) {
                throw new PreconditionException(ErrorCode.E0813, this.wfJob.getStatusStr());
            }
        } else {
            throw new PreconditionException(ErrorCode.E0814, this.actionId, this.wfAction.getStatusStr(), this.wfAction.isPending());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Void execute() throws CommandException {
        this.LOG.debug("STARTED SignalCommand for jobid=" + this.jobId + ", actionId=" + this.actionId);
        WorkflowInstance workflowInstance = this.wfJob.getWorkflowInstance();
        workflowInstance.setTransientVar("oozie.workflow.workflow.bean", this.wfJob);
        boolean completed = false;
        boolean skipAction = false;
        if (this.wfAction == null) {
            if (this.wfJob.getStatus() != WorkflowJob.Status.PREP) throw new CommandException(ErrorCode.E0801, this.wfJob.getId());
            try {
                completed = workflowInstance.start();
            }
            catch (WorkflowException e) {
                throw new CommandException(e);
            }
            this.wfJob.setStatus(WorkflowJob.Status.RUNNING);
            this.wfJob.setStartTime(new Date());
            this.wfJob.setWorkflowInstance(workflowInstance);
            SLADbXOperations.writeStausEvent(this.wfJob.getSlaXml(), this.jobId, SLAEvent.Status.STARTED, SLAEvent.SlaAppType.WORKFLOW_JOB);
            this.writeSLARegistrationForAllActions(workflowInstance.getApp().getDefinition(), this.wfJob.getUser(), this.wfJob.getGroup(), this.wfJob.getConf());
            this.queue(new NotificationXCommand(this.wfJob));
        } else {
            String skipVar = workflowInstance.getVar(this.wfAction.getName() + "#" + "TO_SKIP");
            if (skipVar != null) {
                skipAction = skipVar.equals("true");
            }
            try {
                completed = workflowInstance.signal(this.wfAction.getExecutionPath(), this.wfAction.getSignalValue());
            }
            catch (WorkflowException e) {
                throw new CommandException(e);
            }
            this.wfJob.setWorkflowInstance(workflowInstance);
            this.wfAction.resetPending();
            if (!skipAction) {
                this.wfAction.setTransition(workflowInstance.getTransition(this.wfAction.getName()));
            }
            try {
                this.jpaService.execute(new WorkflowActionUpdateJPAExecutor(this.wfAction));
            }
            catch (JPAExecutorException je) {
                throw new CommandException(je);
            }
        }
        if (completed) {
            NodeDef nodeDef;
            try {
                for (String actionToKillId : WorkflowStoreService.getActionsToKill(workflowInstance)) {
                    WorkflowActionBean actionToKill = this.jpaService.execute(new WorkflowActionGetJPAExecutor(actionToKillId));
                    actionToKill.setPending();
                    actionToKill.setStatus(WorkflowAction.Status.KILLED);
                    this.jpaService.execute(new WorkflowActionUpdateJPAExecutor(actionToKill));
                    this.queue(new ActionKillXCommand(actionToKill.getId(), actionToKill.getType()));
                }
                for (String actionToFailId : WorkflowStoreService.getActionsToFail(workflowInstance)) {
                    WorkflowActionBean actionToFail = this.jpaService.execute(new WorkflowActionGetJPAExecutor(actionToFailId));
                    actionToFail.resetPending();
                    actionToFail.setStatus(WorkflowAction.Status.FAILED);
                    SLADbXOperations.writeStausEvent(this.wfAction.getSlaXml(), this.wfAction.getId(), SLAEvent.Status.FAILED, SLAEvent.SlaAppType.WORKFLOW_ACTION);
                    this.jpaService.execute(new WorkflowActionUpdateJPAExecutor(actionToFail));
                }
            }
            catch (JPAExecutorException je) {
                throw new CommandException(je);
            }
            this.wfJob.setStatus(WorkflowJob.Status.valueOf((String)workflowInstance.getStatus().toString()));
            this.wfJob.setEndTime(new Date());
            this.wfJob.setWorkflowInstance(workflowInstance);
            SLAEvent.Status slaStatus = SLAEvent.Status.SUCCEEDED;
            switch (this.wfJob.getStatus()) {
                case SUCCEEDED: {
                    slaStatus = SLAEvent.Status.SUCCEEDED;
                    break;
                }
                case KILLED: {
                    slaStatus = SLAEvent.Status.KILLED;
                    break;
                }
                case FAILED: {
                    slaStatus = SLAEvent.Status.FAILED;
                    break;
                }
            }
            SLADbXOperations.writeStausEvent(this.wfJob.getSlaXml(), this.jobId, slaStatus, SLAEvent.SlaAppType.WORKFLOW_JOB);
            this.queue(new NotificationXCommand(this.wfJob));
            if (this.wfJob.getStatus() == WorkflowJob.Status.SUCCEEDED) {
                InstrumentUtils.incrJobCounter(INSTR_SUCCEEDED_JOBS_COUNTER_NAME, 1, this.getInstrumentation());
            }
            if (this.wfAction != null && (nodeDef = workflowInstance.getNodeDef(this.wfAction.getExecutionPath())) != null && nodeDef instanceof KillNodeDef) {
                boolean isRetry = false;
                boolean isUserRetry = false;
                ActionXCommand.ActionExecutorContext context = new ActionXCommand.ActionExecutorContext(this.wfJob, this.wfAction, isRetry, isUserRetry);
                try {
                    String tmpNodeConf = nodeDef.getConf();
                    String actionConf = context.getELEvaluator().evaluate(tmpNodeConf, String.class);
                    this.LOG.debug("Try to resolve KillNode message for jobid [{0}], actionId [{1}], before resolve [{2}], after resolve [{3}]", this.jobId, this.actionId, tmpNodeConf, actionConf);
                    if (this.wfAction.getErrorCode() != null) {
                        this.wfAction.setErrorInfo(this.wfAction.getErrorCode(), actionConf);
                    } else {
                        this.wfAction.setErrorInfo(ErrorCode.E0729.toString(), actionConf);
                    }
                    this.jpaService.execute(new WorkflowActionUpdateJPAExecutor(this.wfAction));
                }
                catch (JPAExecutorException je) {
                    throw new CommandException(je);
                }
                catch (Exception ex) {
                    this.LOG.warn("Exception in SignalXCommand ", ex.getMessage(), ex);
                    throw new CommandException(ErrorCode.E0729, this.wfAction.getName(), ex);
                }
            }
        } else {
            for (WorkflowActionBean newAction : WorkflowStoreService.getStartedActions(workflowInstance)) {
                String skipVar = workflowInstance.getVar(newAction.getName() + "#" + "TO_SKIP");
                boolean skipNewAction = false;
                if (skipVar != null) {
                    skipNewAction = skipVar.equals("true");
                }
                try {
                    if (skipNewAction) {
                        WorkflowActionBean oldAction = this.jpaService.execute(new WorkflowActionGetJPAExecutor(newAction.getId()));
                        oldAction.setPending();
                        this.jpaService.execute(new WorkflowActionUpdateJPAExecutor(oldAction));
                        this.queue(new SignalXCommand(this.jobId, oldAction.getId()));
                        continue;
                    }
                    newAction.setPending();
                    String actionSlaXml = this.getActionSLAXml(newAction.getName(), workflowInstance.getApp().getDefinition(), this.wfJob.getConf());
                    newAction.setSlaXml(actionSlaXml);
                    this.jpaService.execute(new WorkflowActionInsertJPAExecutor(newAction));
                    this.LOG.debug("SignalXCommand: Name: " + newAction.getName() + ", Id: " + newAction.getId() + ", Authcode:" + newAction.getCred());
                    this.queue(new ActionStartXCommand(newAction.getId(), newAction.getType()));
                }
                catch (JPAExecutorException je) {
                    throw new CommandException(je);
                }
            }
        }
        try {
            this.jpaService.execute(new WorkflowJobUpdateJPAExecutor(this.wfJob));
        }
        catch (JPAExecutorException je) {
            throw new CommandException(je);
        }
        this.LOG.debug("Updated the workflow status to " + this.wfJob.getId() + "  status =" + this.wfJob.getStatusStr());
        if (this.wfJob.getStatus() != WorkflowJob.Status.RUNNING && this.wfJob.getStatus() != WorkflowJob.Status.SUSPENDED) {
            new CoordActionUpdateXCommand(this.wfJob).call();
            new WfEndXCommand(this.wfJob).call();
        }
        this.LOG.debug("ENDED SignalCommand for jobid=" + this.jobId + ", actionId=" + this.actionId);
        return null;
    }

    public static ELEvaluator createELEvaluatorForGroup(Configuration conf, String group) {
        ELEvaluator eval = Services.get().get(ELService.class).createEvaluator(group);
        for (Map.Entry entry : conf) {
            eval.setVariable((String)entry.getKey(), entry.getValue());
        }
        return eval;
    }

    private String getActionSLAXml(String actionName, String wfXml, String wfConf) throws CommandException {
        String slaXml = null;
        try {
            Element eWfJob = XmlUtils.parseXml(wfXml);
            for (Element action : eWfJob.getChildren("action", eWfJob.getNamespace())) {
                Element eSla;
                if (!action.getAttributeValue("name").equals(actionName) || (eSla = action.getChild("info", Namespace.getNamespace((String)"uri:oozie:sla:0.1"))) == null) continue;
                slaXml = XmlUtils.prettyPrint(eSla).toString();
                break;
            }
        }
        catch (Exception e) {
            throw new CommandException(ErrorCode.E1004, e.getMessage(), e);
        }
        return slaXml;
    }

    private String resolveSla(Element eSla, Configuration conf) throws CommandException {
        String slaXml = null;
        try {
            ELEvaluator evalSla = SubmitCommand.createELEvaluatorForGroup(conf, "wf-sla-submit");
            slaXml = SubmitCommand.resolveSla(eSla, evalSla);
        }
        catch (Exception e) {
            throw new CommandException(ErrorCode.E1004, e.getMessage(), e);
        }
        return slaXml;
    }

    private void writeSLARegistrationForAllActions(String wfXml, String user, String group, String strConf) throws CommandException {
        try {
            Element eWfJob = XmlUtils.parseXml(wfXml);
            XConfiguration conf = new XConfiguration(new StringReader(strConf));
            for (Element action : eWfJob.getChildren("action", eWfJob.getNamespace())) {
                Element eSla = action.getChild("info", Namespace.getNamespace((String)"uri:oozie:sla:0.1"));
                if (eSla == null) continue;
                String slaXml = this.resolveSla(eSla, conf);
                eSla = XmlUtils.parseXml(slaXml);
                String actionId = Services.get().get(UUIDService.class).generateChildId(this.jobId, action.getAttributeValue("name") + "");
                SLADbXOperations.writeSlaRegistrationEvent(eSla, actionId, SLAEvent.SlaAppType.WORKFLOW_ACTION, user, group);
            }
        }
        catch (Exception e) {
            throw new CommandException(ErrorCode.E1007, "workflow:Actions " + this.jobId, e);
        }
    }
}

