/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord;

import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.util.ParamChecker;
import org.jdom.Element;

public class CoordUtils {
    public static final String HADOOP_UGI = "hadoop.job.ugi";
    public static final String HADOOP_USER = "user.name";

    public static String getDoneFlag(Element doneFlagElement) {
        if (doneFlagElement != null) {
            return doneFlagElement.getTextTrim();
        }
        return "_SUCCESS";
    }

    public static Configuration getHadoopConf(Configuration jobConf) {
        Configuration conf = new Configuration();
        ParamChecker.notNull(jobConf, "Configuration to be used for hadoop setup ");
        String user = ParamChecker.notEmpty(jobConf.get(HADOOP_USER), HADOOP_USER);
        String group = ParamChecker.notEmpty(jobConf.get("group.name"), "group.name");
        conf.set(HADOOP_USER, user);
        conf.set(HADOOP_UGI, user + "," + group);
        return conf;
    }
}

