/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;

public class BundleJobsGetNeedStartJPAExecutor
implements JPAExecutor<List<BundleJobBean>> {
    private Date date;

    public BundleJobsGetNeedStartJPAExecutor(Date d) {
        this.date = d;
    }

    @Override
    public String getName() {
        return "BundleJobsGetNeedStartJPAExecutor";
    }

    @Override
    public List<BundleJobBean> execute(EntityManager em) throws JPAExecutorException {
        ArrayList<BundleJobBean> jobList = new ArrayList<BundleJobBean>();
        try {
            Query q = em.createNamedQuery("GET_BUNDLE_JOBS_NEED_START");
            q.setParameter("currentTime", (Object)new Timestamp(this.date.getTime()));
            List bjBeans = q.getResultList();
            for (BundleJobBean j : bjBeans) {
                jobList.add(j);
            }
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e);
        }
        return jobList;
    }
}

