/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class CoordJobGetActionByActionNumberJPAExecutor
implements JPAExecutor<CoordinatorActionBean> {
    private String coordJobId = null;
    private final int actionNumber;

    public CoordJobGetActionByActionNumberJPAExecutor(String coordJobId, int actionNumber) {
        ParamChecker.notNull(coordJobId, "coordJobId");
        this.coordJobId = coordJobId;
        this.actionNumber = actionNumber;
    }

    @Override
    public String getName() {
        return "CoordJobGetActionByActionNumberJPAExecutor";
    }

    @Override
    public CoordinatorActionBean execute(EntityManager em) throws JPAExecutorException {
        try {
            CoordinatorActionBean caBean = null;
            Query q = em.createNamedQuery("GET_COORD_ACTION_FOR_COORD_JOB_BY_ACTION_NUMBER");
            q.setParameter("jobId", (Object)this.coordJobId);
            q.setParameter("actionNumber", (Object)this.actionNumber);
            List actionList = q.getResultList();
            if (actionList.size() > 0) {
                caBean = (CoordinatorActionBean)actionList.get(0);
            }
            return caBean;
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e);
        }
    }
}

