/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;

public class WorkflowJobsGetForPurgeJPAExecutor
implements JPAExecutor<List<WorkflowJobBean>> {
    private static final long DAY_IN_MS = 86400000L;
    private long olderThanDays;
    private int limit;

    public WorkflowJobsGetForPurgeJPAExecutor(long olderThanDays, int limit) {
        this.olderThanDays = olderThanDays;
        this.limit = limit;
    }

    @Override
    public String getName() {
        return "WorkflowJobsGetForPurgeJPAExecutor";
    }

    @Override
    public List<WorkflowJobBean> execute(EntityManager em) throws JPAExecutorException {
        List workflows = null;
        try {
            Timestamp maxEndTime = new Timestamp(System.currentTimeMillis() - this.olderThanDays * 86400000L);
            Query jobQ = em.createNamedQuery("GET_COMPLETED_WORKFLOWS_OLDER_THAN");
            jobQ.setParameter("endTime", (Object)maxEndTime);
            jobQ.setMaxResults(this.limit);
            workflows = jobQ.getResultList();
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e);
        }
        return workflows;
    }
}

