/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;

public class HadoopAccessorService
implements Service {
    public static final String CONF_PREFIX = "oozie.service.HadoopAccessorService.";
    public static final String JOB_TRACKER_WHITELIST = "oozie.service.HadoopAccessorService.jobTracker.whitelist";
    public static final String NAME_NODE_WHITELIST = "oozie.service.HadoopAccessorService.nameNode.whitelist";
    private Set<String> jobTrackerWhitelist = new HashSet<String>();
    private Set<String> nameNodeWhitelist = new HashSet<String>();

    @Override
    public void init(Services services) throws ServiceException {
        String tmp;
        for (String name : services.getConf().getStringCollection(JOB_TRACKER_WHITELIST)) {
            tmp = name.toLowerCase().trim();
            if (tmp.length() == 0) continue;
            this.jobTrackerWhitelist.add(tmp);
        }
        XLog.getLog(this.getClass()).info("JOB_TRACKER_WHITELIST :" + services.getConf().getStringCollection(JOB_TRACKER_WHITELIST) + ", Total entries :" + this.jobTrackerWhitelist.size());
        for (String name : services.getConf().getStringCollection(NAME_NODE_WHITELIST)) {
            tmp = name.toLowerCase().trim();
            if (tmp.length() == 0) continue;
            this.nameNodeWhitelist.add(tmp);
        }
        XLog.getLog(this.getClass()).info("NAME_NODE_WHITELIST :" + services.getConf().getStringCollection(NAME_NODE_WHITELIST) + ", Total entries :" + this.nameNodeWhitelist.size());
        this.init(services.getConf());
    }

    public void init(Configuration serviceConf) throws ServiceException {
    }

    @Override
    public void destroy() {
    }

    @Override
    public Class<? extends Service> getInterface() {
        return HadoopAccessorService.class;
    }

    public JobClient createJobClient(String user, String group, JobConf conf) throws HadoopAccessorException {
        this.validateJobTracker(conf.get("mapred.job.tracker"));
        conf = this.createConfiguration(user, group, conf);
        try {
            return new JobClient(conf);
        }
        catch (IOException e) {
            throw new HadoopAccessorException(ErrorCode.E0902, e);
        }
    }

    public FileSystem createFileSystem(String user, String group, Configuration conf) throws HadoopAccessorException {
        try {
            this.validateNameNode(new URI(conf.get("fs.default.name")).getAuthority());
            conf = this.createConfiguration(user, group, conf);
            return FileSystem.get((Configuration)conf);
        }
        catch (IOException e) {
            throw new HadoopAccessorException(ErrorCode.E0902, e);
        }
        catch (URISyntaxException e) {
            throw new HadoopAccessorException(ErrorCode.E0902, e);
        }
    }

    public FileSystem createFileSystem(String user, String group, URI uri, Configuration conf) throws HadoopAccessorException {
        this.validateNameNode(uri.getAuthority());
        conf = this.createConfiguration(user, group, conf);
        try {
            return FileSystem.get((URI)uri, (Configuration)conf);
        }
        catch (IOException e) {
            throw new HadoopAccessorException(ErrorCode.E0902, e);
        }
    }

    protected void validateJobTracker(String jobTrackerUri) throws HadoopAccessorException {
        this.validate(jobTrackerUri, this.jobTrackerWhitelist, ErrorCode.E0900);
    }

    protected void validateNameNode(String nameNodeUri) throws HadoopAccessorException {
        this.validate(nameNodeUri, this.nameNodeWhitelist, ErrorCode.E0901);
    }

    private void validate(String uri, Set<String> whitelist, ErrorCode error) throws HadoopAccessorException {
        if (uri != null) {
            uri = uri.toLowerCase().trim();
            if (whitelist.size() > 0 && !whitelist.contains(uri)) {
                throw new HadoopAccessorException(error, uri);
            }
        }
    }

    private <C extends Configuration> C createConfiguration(String user, String group, C conf) {
        ParamChecker.notEmpty(user, "user");
        ParamChecker.notEmpty(group, "group");
        JobConf fsConf = conf instanceof JobConf ? new JobConf() : new Configuration();
        XConfiguration.copy(conf, (Configuration)fsConf);
        fsConf.set("user.name", user);
        fsConf.set("hadoop.job.ugi", user + "," + group);
        return (C)fsConf;
    }

    public void addFileToClassPath(String user, String group, Path file, Configuration conf) throws IOException {
        Configuration defaultConf = this.createConfiguration(user, group, conf);
        DistributedCache.addFileToClassPath((Path)file, (Configuration)defaultConf);
        DistributedCache.addFileToClassPath((Path)file, (Configuration)conf);
    }
}

