/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;

public class UUIDService
implements Service {
    public static final String CONF_PREFIX = "oozie.service.UUIDService.";
    public static final String CONF_GENERATOR = "oozie.service.UUIDService.generator";
    private String startTime;
    private AtomicLong counter;
    private String systemId;

    @Override
    public void init(Services services) throws ServiceException {
        String genType = services.getConf().get(CONF_GENERATOR, "counter").trim();
        if (genType.equals("counter")) {
            this.counter = new AtomicLong();
            this.startTime = new SimpleDateFormat("yyMMddHHmmssSSS").format(new Date());
        } else if (!genType.equals("random")) {
            throw new ServiceException(ErrorCode.E0120, genType);
        }
        this.systemId = services.getSystemId();
    }

    @Override
    public void destroy() {
        this.counter = null;
        this.startTime = null;
    }

    @Override
    public Class<? extends Service> getInterface() {
        return UUIDService.class;
    }

    private String longPadding(long number) {
        StringBuilder sb = new StringBuilder();
        sb.append(number);
        if (sb.length() <= 7) {
            sb.insert(0, "0000000".substring(sb.length()));
        }
        return sb.toString();
    }

    public String generateId(ApplicationType type) {
        StringBuilder sb = new StringBuilder();
        if (this.counter != null) {
            sb.append(this.longPadding(this.counter.getAndIncrement())).append('-').append(this.startTime);
        } else {
            sb.append(UUID.randomUUID().toString());
            if (sb.length() > 37 - this.systemId.length()) {
                sb.setLength(37 - this.systemId.length());
            }
        }
        sb.append('-').append(this.systemId);
        sb.append('-').append(type.getType());
        if (sb.length() > 40) {
            throw new RuntimeException(XLog.format("ID exceeds limit of 40 characters, [{0}]", sb));
        }
        return sb.toString();
    }

    public String generateChildId(String id, String childName) {
        if ((id = ParamChecker.notEmpty(id, "id") + "@" + ParamChecker.notEmpty(childName, "childName")).length() > 95) {
            throw new RuntimeException(XLog.format("Child ID exceeds limit of 95 characters, [{0}]", id));
        }
        return id;
    }

    public String getId(String childId) {
        int index = ParamChecker.notEmpty(childId, "childId").indexOf("@");
        if (index == -1) {
            throw new IllegalArgumentException(XLog.format("invalid child id [{0}]", childId));
        }
        return childId.substring(0, index);
    }

    public String getChildName(String childId) {
        int index = ParamChecker.notEmpty(childId, "childId").indexOf("@");
        if (index == -1) {
            throw new IllegalArgumentException(XLog.format("invalid child id [{0}]", childId));
        }
        return childId.substring(index + 1);
    }

    public static enum ApplicationType {
        WORKFLOW('W'),
        COORDINATOR('C'),
        BUNDLE('B');

        private final char type;

        private ApplicationType(char type) {
            this.type = type;
        }

        public char getType() {
            return this.type;
        }
    }
}

