/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.SLAEventsCommand;
import org.apache.oozie.servlet.JsonRestServlet;
import org.apache.oozie.servlet.XServletException;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Content;
import org.jdom.Element;

public class SLAServlet
extends JsonRestServlet {
    private static final String INSTRUMENTATION_NAME = "sla";
    private static final JsonRestServlet.ResourceInfo[] RESOURCES_INFO = new JsonRestServlet.ResourceInfo[1];

    public SLAServlet() {
        super(INSTRUMENTATION_NAME, RESOURCES_INFO);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Element eResponse;
            long lastSeqId;
            String gtSequenceNum = request.getParameter("gt-sequence-id");
            String strMaxEvents = request.getParameter("max-events");
            int maxNoEvents = 100;
            XLog.getLog(((Object)((Object)this)).getClass()).debug("Got SLA GET request for :" + gtSequenceNum + " and max-events :" + strMaxEvents);
            if (strMaxEvents != null && strMaxEvents.length() > 0) {
                maxNoEvents = Integer.parseInt(strMaxEvents);
            }
            if (gtSequenceNum != null) {
                long seqId = Long.parseLong(gtSequenceNum);
                this.stopCron();
                SLAEventsCommand seCommand = new SLAEventsCommand(seqId, maxNoEvents);
                List slaEvntList = (List)seCommand.call();
                lastSeqId = seCommand.getLastSeqId();
                eResponse = new Element("sla-message");
                for (SLAEventBean event : slaEvntList) {
                    eResponse.addContent((Content)event.toXml());
                }
            } else {
                XLog.getLog(((Object)((Object)this)).getClass()).error("Not implemented witout gt_seq_id");
                throw new XServletException(400, ErrorCode.E0401, "Not implemented without gtSeqID");
            }
            Element eLastSeq = new Element("last-sequence-id");
            eLastSeq.addContent(String.valueOf(lastSeqId));
            eResponse.addContent((Content)eLastSeq);
            response.setContentType("application/xml; charset=\"UTF-8\"");
            XLog.getLog(((Object)((Object)this)).getClass()).debug("Writing back SLA Servlet  Caller with last-seq-id " + lastSeqId);
            this.startCron();
            response.setStatus(200);
            response.getWriter().write(XmlUtils.prettyPrint(eResponse) + "\n");
        }
        catch (CommandException ce) {
            ce.printStackTrace();
            XLog.getLog(((Object)((Object)this)).getClass()).error((Object)"Command exception ", ce);
            throw new XServletException(400, ce);
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            XLog.getLog(((Object)((Object)this)).getClass()).error((Object)"Runtime error ", re);
            throw new XServletException(400, ErrorCode.E0307, re.getMessage());
        }
    }

    static {
        SLAServlet.RESOURCES_INFO[0] = new JsonRestServlet.ResourceInfo("", Arrays.asList("GET"), Arrays.asList(new JsonRestServlet.ParameterInfo("gt-sequence-id", String.class, true, Arrays.asList("GET")), new JsonRestServlet.ParameterInfo("max-events", String.class, false, Arrays.asList("GET"))));
    }
}

