/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.store;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.service.InstrumentationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.store.Store;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.ParamChecker;

public class SLAStore
extends Store {
    private EntityManager entityManager = this.getEntityManager();
    private static final String INSTR_GROUP = "db";

    public SLAStore() throws StoreException {
    }

    public SLAStore(Store store) throws StoreException {
        super(store);
    }

    public void insertSLAEvent(final SLAEventBean slaEvent) throws StoreException {
        ParamChecker.notNull(slaEvent, "sLaEvent");
        this.doOperation("insertSLAEvent", new Callable<Void>(){

            @Override
            public Void call() throws StoreException {
                SLAStore.this.entityManager.persist((Object)slaEvent);
                return null;
            }
        });
    }

    public List<SLAEventBean> getSLAEventListNewerSeqLimited(final long seqId, final int limitLen, long[] lastSeqId) throws StoreException {
        ParamChecker.notNull(seqId, "SLAEventListNewerSeqLimited");
        ParamChecker.checkGTZero(limitLen, "SLAEventListNewerSeqLimited");
        lastSeqId[0] = seqId;
        List<SLAEventBean> seBeans = this.doOperation("getSLAEventListNewerSeqLimited", new Callable<List<SLAEventBean>>(){

            @Override
            public List<SLAEventBean> call() throws StoreException {
                List seBeans;
                try {
                    Query q = SLAStore.this.entityManager.createNamedQuery("GET_SLA_EVENT_NEWER_SEQ_LIMITED");
                    q.setParameter("id", (Object)seqId);
                    q.setMaxResults(limitLen);
                    seBeans = q.getResultList();
                }
                catch (IllegalStateException e) {
                    throw new StoreException(ErrorCode.E0601, e.getMessage(), e);
                }
                return seBeans;
            }
        });
        ArrayList<SLAEventBean> eventList = new ArrayList<SLAEventBean>();
        for (SLAEventBean j : seBeans) {
            lastSeqId[0] = Math.max(lastSeqId[0], j.getEvent_id());
            eventList.add(j);
        }
        return eventList;
    }

    private SLAEventBean copyEventBean(SLAEventBean e) {
        SLAEventBean event = new SLAEventBean();
        event.setAlertContact(e.getAlertContact());
        event.setAlertFrequency(e.getAlertFrequency());
        event.setAlertPercentage(e.getAlertPercentage());
        event.setAppName(e.getAppName());
        event.setAppType(e.getAppType());
        event.setAppTypeStr(e.getAppTypeStr());
        event.setDevContact(e.getDevContact());
        event.setEvent_id(e.getEvent_id());
        event.setEventType(e.getEventType());
        event.setExpectedEnd(e.getExpectedEnd());
        event.setExpectedStart(e.getExpectedStart());
        event.setGroupName(e.getGroupName());
        event.setJobData(e.getJobData());
        event.setJobStatus(e.getJobStatus());
        event.setJobStatusStr(e.getJobStatusStr());
        event.setNotificationMsg(e.getNotificationMsg());
        event.setParentClientId(e.getParentClientId());
        event.setParentSlaId(e.getParentSlaId());
        event.setQaContact(e.getQaContact());
        event.setSeContact(e.getSeContact());
        event.setSlaId(e.getSlaId());
        event.setStatusTimestamp(e.getStatusTimestamp());
        event.setUpstreamApps(e.getUpstreamApps());
        event.setUser(e.getUser());
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V doOperation(String name, Callable<V> command) throws StoreException {
        try {
            V retVal;
            Instrumentation.Cron cron = new Instrumentation.Cron();
            cron.start();
            try {
                retVal = command.call();
            }
            finally {
                cron.stop();
            }
            Services.get().get(InstrumentationService.class).get().addCron(INSTR_GROUP, name, cron);
            return retVal;
        }
        catch (StoreException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            throw new StoreException(ErrorCode.E0603, name, ex.getMessage(), ex);
        }
        catch (Exception e) {
            throw new StoreException(ErrorCode.E0607, name, e.getMessage(), e);
        }
    }
}

