/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.store;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.xml.validation.Schema;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.WorkflowsInfo;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.service.InstrumentationService;
import org.apache.oozie.service.SchemaService;
import org.apache.oozie.service.Services;
import org.apache.oozie.store.Store;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.FetchDirection;
import org.apache.openjpa.persistence.jdbc.JDBCFetchPlan;
import org.apache.openjpa.persistence.jdbc.LRSSizeAlgorithm;
import org.apache.openjpa.persistence.jdbc.ResultSetType;

public class WorkflowStore
extends Store {
    private Connection conn;
    private EntityManager entityManager;
    private boolean selectForUpdate;
    private static final String INSTR_GROUP = "db";
    public static final int LOCK_TIMEOUT = 50000;
    private static final String seletStr = "Select w.id, w.appName, w.status, w.run, w.user, w.group, w.createdTimestamp, w.startTimestamp, w.lastModifiedTimestamp, w.endTimestamp from WorkflowJobBean w";
    private static final String countStr = "Select count(w) from WorkflowJobBean w";
    private static final long DAY_IN_MS = 86400000L;

    public WorkflowStore() {
    }

    public WorkflowStore(Connection connection, boolean selectForUpdate) throws StoreException {
        this.conn = ParamChecker.notNull(connection, "conn");
        this.entityManager = this.getEntityManager();
        this.selectForUpdate = selectForUpdate;
    }

    public WorkflowStore(Connection connection, Store store, boolean selectForUpdate) throws StoreException {
        super(store);
        this.conn = ParamChecker.notNull(connection, "conn");
        this.entityManager = this.getEntityManager();
        this.selectForUpdate = selectForUpdate;
    }

    public WorkflowStore(boolean selectForUpdate) throws StoreException {
        this.entityManager = this.getEntityManager();
        Schema schema = Services.get().get(SchemaService.class).getSchema(SchemaService.SchemaName.WORKFLOW);
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)this.entityManager);
        this.conn = (Connection)kem.getConnection();
        this.selectForUpdate = selectForUpdate;
    }

    public WorkflowStore(Store store, boolean selectForUpdate) throws StoreException {
        super(store);
        this.entityManager = this.getEntityManager();
        this.selectForUpdate = selectForUpdate;
    }

    public void insertWorkflow(final WorkflowJobBean workflow) throws StoreException {
        ParamChecker.notNull(workflow, "workflow");
        this.doOperation("insertWorkflow", new Callable<Void>(){

            @Override
            public Void call() throws SQLException, StoreException, WorkflowException {
                WorkflowStore.this.entityManager.persist((Object)workflow);
                return null;
            }
        });
    }

    public WorkflowJobBean getWorkflow(final String id, final boolean locking) throws StoreException {
        ParamChecker.notEmpty(id, "WorkflowID");
        WorkflowJobBean wfBean = this.doOperation("getWorkflow", new Callable<WorkflowJobBean>(){

            @Override
            public WorkflowJobBean call() throws SQLException, StoreException, WorkflowException, InterruptedException {
                WorkflowJobBean wfBean = null;
                wfBean = WorkflowStore.this.getWorkflowOnly(id, locking);
                if (wfBean == null) {
                    throw new StoreException(ErrorCode.E0604, id);
                }
                return wfBean;
            }
        });
        return wfBean;
    }

    public int getWorkflowCountWithStatus(final String status) throws StoreException {
        ParamChecker.notEmpty(status, "status");
        Integer cnt = this.doOperation("getWorkflowCountWithStatus", new Callable<Integer>(){

            @Override
            public Integer call() throws SQLException {
                Query q = WorkflowStore.this.entityManager.createNamedQuery("GET_WORKFLOWS_COUNT_WITH_STATUS");
                q.setParameter("status", (Object)status);
                Long count = (Long)q.getSingleResult();
                return count.intValue();
            }
        });
        return cnt;
    }

    public int getWorkflowCountWithStatusInLastNSeconds(final String status, final int secs) throws StoreException {
        ParamChecker.notEmpty(status, "status");
        ParamChecker.notEmpty(status, "secs");
        Integer cnt = this.doOperation("getWorkflowCountWithStatusInLastNSecs", new Callable<Integer>(){

            @Override
            public Integer call() throws SQLException {
                Query q = WorkflowStore.this.entityManager.createNamedQuery("GET_WORKFLOWS_COUNT_WITH_STATUS_IN_LAST_N_SECS");
                Timestamp ts = new Timestamp(System.currentTimeMillis() - (long)(secs * 1000));
                q.setParameter("status", (Object)status);
                q.setParameter("lastModTime", (Object)ts);
                Long count = (Long)q.getSingleResult();
                return count.intValue();
            }
        });
        return cnt;
    }

    public void updateWorkflow(final WorkflowJobBean wfBean) throws StoreException {
        ParamChecker.notNull(wfBean, "WorkflowJobBean");
        this.doOperation("updateWorkflow", new Callable<Void>(){

            @Override
            public Void call() throws SQLException, StoreException, WorkflowException {
                Query q = WorkflowStore.this.entityManager.createNamedQuery("UPDATE_WORKFLOW");
                q.setParameter("id", (Object)wfBean.getId());
                WorkflowStore.this.setWFQueryParameters(wfBean, q);
                q.executeUpdate();
                return null;
            }
        });
    }

    public void insertAction(final WorkflowActionBean action) throws StoreException {
        ParamChecker.notNull(action, "WorkflowActionBean");
        this.doOperation("insertAction", new Callable<Void>(){

            @Override
            public Void call() throws SQLException, StoreException, WorkflowException {
                WorkflowStore.this.entityManager.persist((Object)action);
                return null;
            }
        });
    }

    public WorkflowActionBean getAction(final String id, boolean locking) throws StoreException {
        ParamChecker.notEmpty(id, "ActionID");
        WorkflowActionBean action = this.doOperation("getAction", new Callable<WorkflowActionBean>(){

            @Override
            public WorkflowActionBean call() throws SQLException, StoreException, WorkflowException, InterruptedException {
                Query q = WorkflowStore.this.entityManager.createNamedQuery("GET_ACTION");
                WorkflowActionBean action = null;
                q.setParameter("id", (Object)id);
                List actions = q.getResultList();
                if (actions.size() <= 0) {
                    throw new StoreException(ErrorCode.E0605, id);
                }
                action = (WorkflowActionBean)actions.get(0);
                return WorkflowStore.this.getBeanForRunningAction(action);
            }
        });
        return action;
    }

    public void updateAction(final WorkflowActionBean action) throws StoreException {
        ParamChecker.notNull(action, "WorkflowActionBean");
        this.doOperation("updateAction", new Callable<Void>(){

            @Override
            public Void call() throws SQLException, StoreException, WorkflowException {
                Query q = WorkflowStore.this.entityManager.createNamedQuery("UPDATE_ACTION");
                q.setParameter("id", (Object)action.getId());
                WorkflowStore.this.setActionQueryParameters(action, q);
                q.executeUpdate();
                return null;
            }
        });
    }

    public void deleteAction(final String id) throws StoreException {
        ParamChecker.notEmpty(id, "ActionID");
        this.doOperation("deleteAction", new Callable<Void>(){

            @Override
            public Void call() throws SQLException, StoreException, WorkflowException {
                WorkflowActionBean action = (WorkflowActionBean)WorkflowStore.this.entityManager.find(WorkflowActionBean.class, (Object)id);
                if (action != null) {
                    WorkflowStore.this.entityManager.remove((Object)action);
                }
                return null;
            }
        });
    }

    public List<WorkflowActionBean> getActionsForWorkflow(final String wfId, boolean locking) throws StoreException {
        ParamChecker.notEmpty(wfId, "WorkflowID");
        List<WorkflowActionBean> actions = this.doOperation("getActionsForWorkflow", new Callable<List<WorkflowActionBean>>(){

            @Override
            public List<WorkflowActionBean> call() throws SQLException, StoreException, WorkflowException, InterruptedException {
                ArrayList<WorkflowActionBean> actionList = new ArrayList<WorkflowActionBean>();
                try {
                    Query q = WorkflowStore.this.entityManager.createNamedQuery("GET_ACTIONS_FOR_WORKFLOW");
                    q.setParameter("wfId", (Object)wfId);
                    List actions = q.getResultList();
                    for (WorkflowActionBean a : actions) {
                        WorkflowActionBean aa = WorkflowStore.this.getBeanForRunningAction(a);
                        actionList.add(aa);
                    }
                }
                catch (IllegalStateException e) {
                    throw new StoreException(ErrorCode.E0601, e.getMessage(), e);
                }
                return actionList;
            }
        });
        return actions;
    }

    public List<WorkflowActionBean> getActionsSubsetForWorkflow(final String wfId, final int start, final int len) throws StoreException {
        ParamChecker.notEmpty(wfId, "WorkflowID");
        List<WorkflowActionBean> actions = this.doOperation("getActionsForWorkflow", new Callable<List<WorkflowActionBean>>(){

            @Override
            public List<WorkflowActionBean> call() throws SQLException, StoreException, WorkflowException, InterruptedException {
                ArrayList<WorkflowActionBean> actionList = new ArrayList<WorkflowActionBean>();
                try {
                    Query q = WorkflowStore.this.entityManager.createNamedQuery("GET_ACTIONS_FOR_WORKFLOW");
                    OpenJPAQuery oq = OpenJPAPersistence.cast((Query)q);
                    q.setParameter("wfId", (Object)wfId);
                    q.setFirstResult(start - 1);
                    q.setMaxResults(len);
                    List actions = q.getResultList();
                    for (WorkflowActionBean a : actions) {
                        WorkflowActionBean aa = WorkflowStore.this.getBeanForRunningAction(a);
                        actionList.add(aa);
                    }
                }
                catch (IllegalStateException e) {
                    throw new StoreException(ErrorCode.E0601, e.getMessage(), e);
                }
                return actionList;
            }
        });
        return actions;
    }

    public List<WorkflowActionBean> getPendingActions(final long minimumPendingAgeSecs) throws StoreException {
        List<WorkflowActionBean> actions = this.doOperation("getPendingActions", new Callable<List<WorkflowActionBean>>(){

            @Override
            public List<WorkflowActionBean> call() throws SQLException, StoreException, WorkflowException {
                Timestamp ts = new Timestamp(System.currentTimeMillis() - minimumPendingAgeSecs * 1000L);
                List actionList = null;
                try {
                    Query q = WorkflowStore.this.entityManager.createNamedQuery("GET_PENDING_ACTIONS");
                    q.setParameter("pendingAge", (Object)ts);
                    actionList = q.getResultList();
                }
                catch (IllegalStateException e) {
                    throw new StoreException(ErrorCode.E0601, e.getMessage(), e);
                }
                return actionList;
            }
        });
        return actions;
    }

    public List<WorkflowActionBean> getRunningActions(final long checkAgeSecs) throws StoreException {
        List<WorkflowActionBean> actions = this.doOperation("getRunningActions", new Callable<List<WorkflowActionBean>>(){

            @Override
            public List<WorkflowActionBean> call() throws SQLException, StoreException, WorkflowException {
                ArrayList<WorkflowActionBean> actions = new ArrayList();
                Timestamp ts = new Timestamp(System.currentTimeMillis() - checkAgeSecs * 1000L);
                try {
                    Query q = WorkflowStore.this.entityManager.createNamedQuery("GET_RUNNING_ACTIONS");
                    q.setParameter("lastCheckTime", (Object)ts);
                    actions = q.getResultList();
                }
                catch (IllegalStateException e) {
                    throw new StoreException(ErrorCode.E0601, e.getMessage(), e);
                }
                return actions;
            }
        });
        return actions;
    }

    public List<WorkflowActionBean> getRetryAndManualActions(final String wfId) throws StoreException {
        List<WorkflowActionBean> actions = this.doOperation("GET_RETRY_MANUAL_ACTIONS", new Callable<List<WorkflowActionBean>>(){

            @Override
            public List<WorkflowActionBean> call() throws SQLException, StoreException, WorkflowException {
                List actionList = null;
                try {
                    Query q = WorkflowStore.this.entityManager.createNamedQuery("GET_RETRY_MANUAL_ACTIONS");
                    q.setParameter("wfId", (Object)wfId);
                    actionList = q.getResultList();
                }
                catch (IllegalStateException e) {
                    throw new StoreException(ErrorCode.E0601, e.getMessage(), e);
                }
                return actionList;
            }
        });
        return actions;
    }

    public WorkflowsInfo getWorkflowsInfo(final Map<String, List<String>> filter, final int start, final int len) throws StoreException {
        WorkflowsInfo workFlowsInfo = this.doOperation("getWorkflowsInfo", new Callable<WorkflowsInfo>(){

            @Override
            public WorkflowsInfo call() throws SQLException, StoreException {
                List resultList;
                ArrayList<String> orArray = new ArrayList<String>();
                ArrayList<String> colArray = new ArrayList<String>();
                ArrayList valArray = new ArrayList();
                StringBuilder sb = new StringBuilder("");
                boolean isStatus = false;
                boolean isGroup = false;
                boolean isAppName = false;
                boolean isUser = false;
                boolean isEnabled = false;
                int index = 0;
                for (Map.Entry entry : filter.entrySet()) {
                    int i;
                    List values;
                    String colName = null;
                    String colVar = null;
                    if (((String)entry.getKey()).equals("group")) {
                        values = (List)filter.get("group");
                        colName = "group";
                        for (i = 0; i < values.size(); ++i) {
                            colVar = "group";
                            colVar = colVar + index;
                            if (!isEnabled && !isGroup) {
                                sb.append(WorkflowStore.seletStr).append(" where w.group IN (:group" + index);
                                isGroup = true;
                                isEnabled = true;
                            } else if (isEnabled && !isGroup) {
                                sb.append(" and w.group IN (:group" + index);
                                isGroup = true;
                            } else if (isGroup) {
                                sb.append(", :group" + index);
                            }
                            if (i == values.size() - 1) {
                                sb.append(")");
                            }
                            ++index;
                            valArray.add(values.get(i));
                            orArray.add(colName);
                            colArray.add(colVar);
                        }
                        continue;
                    }
                    if (((String)entry.getKey()).equals("status")) {
                        values = (List)filter.get("status");
                        colName = "status";
                        for (i = 0; i < values.size(); ++i) {
                            colVar = "status";
                            colVar = colVar + index;
                            if (!isEnabled && !isStatus) {
                                sb.append(WorkflowStore.seletStr).append(" where w.status IN (:status" + index);
                                isStatus = true;
                                isEnabled = true;
                            } else if (isEnabled && !isStatus) {
                                sb.append(" and w.status IN (:status" + index);
                                isStatus = true;
                            } else if (isStatus) {
                                sb.append(", :status" + index);
                            }
                            if (i == values.size() - 1) {
                                sb.append(")");
                            }
                            ++index;
                            valArray.add(values.get(i));
                            orArray.add(colName);
                            colArray.add(colVar);
                        }
                        continue;
                    }
                    if (((String)entry.getKey()).equals("name")) {
                        values = (List)filter.get("name");
                        colName = "appName";
                        for (i = 0; i < values.size(); ++i) {
                            colVar = "appName";
                            colVar = colVar + index;
                            if (!isEnabled && !isAppName) {
                                sb.append(WorkflowStore.seletStr).append(" where w.appName IN (:appName" + index);
                                isAppName = true;
                                isEnabled = true;
                            } else if (isEnabled && !isAppName) {
                                sb.append(" and w.appName IN (:appName" + index);
                                isAppName = true;
                            } else if (isAppName) {
                                sb.append(", :appName" + index);
                            }
                            if (i == values.size() - 1) {
                                sb.append(")");
                            }
                            ++index;
                            valArray.add(values.get(i));
                            orArray.add(colName);
                            colArray.add(colVar);
                        }
                        continue;
                    }
                    if (!((String)entry.getKey()).equals("user")) continue;
                    values = (List)filter.get("user");
                    colName = "user";
                    for (i = 0; i < values.size(); ++i) {
                        colVar = "user";
                        colVar = colVar + index;
                        if (!isEnabled && !isUser) {
                            sb.append(WorkflowStore.seletStr).append(" where w.user IN (:user" + index);
                            isUser = true;
                            isEnabled = true;
                        } else if (isEnabled && !isUser) {
                            sb.append(" and w.user IN (:user" + index);
                            isUser = true;
                        } else if (isUser) {
                            sb.append(", :user" + index);
                        }
                        if (i == values.size() - 1) {
                            sb.append(")");
                        }
                        ++index;
                        valArray.add(values.get(i));
                        orArray.add(colName);
                        colArray.add(colVar);
                    }
                }
                int realLen = 0;
                Query q = null;
                Query qTotal = null;
                if (orArray.size() == 0) {
                    q = WorkflowStore.this.entityManager.createNamedQuery("GET_WORKFLOWS_COLUMNS");
                    q.setFirstResult(start - 1);
                    q.setMaxResults(len);
                    qTotal = WorkflowStore.this.entityManager.createNamedQuery("GET_WORKFLOWS_COUNT");
                } else if (orArray.size() > 0) {
                    StringBuilder sbTotal = new StringBuilder(sb);
                    sb.append(" order by w.startTimestamp desc ");
                    XLog.getLog(this.getClass()).debug("Created String is **** " + sb.toString());
                    q = WorkflowStore.this.entityManager.createQuery(sb.toString());
                    q.setFirstResult(start - 1);
                    q.setMaxResults(len);
                    qTotal = WorkflowStore.this.entityManager.createQuery(sbTotal.toString().replace(WorkflowStore.seletStr, WorkflowStore.countStr));
                    for (int i = 0; i < orArray.size(); ++i) {
                        q.setParameter((String)colArray.get(i), valArray.get(i));
                        qTotal.setParameter((String)colArray.get(i), valArray.get(i));
                    }
                }
                OpenJPAQuery kq = OpenJPAPersistence.cast(q);
                JDBCFetchPlan fetch = (JDBCFetchPlan)kq.getFetchPlan();
                fetch.setFetchBatchSize(20);
                fetch.setResultSetType(ResultSetType.SCROLL_INSENSITIVE);
                fetch.setFetchDirection(FetchDirection.FORWARD);
                fetch.setLRSSizeAlgorithm(LRSSizeAlgorithm.LAST);
                List objectArrList = resultList = q.getResultList();
                ArrayList<WorkflowJobBean> wfBeansList = new ArrayList<WorkflowJobBean>();
                for (Object[] arr : objectArrList) {
                    WorkflowJobBean ww = WorkflowStore.this.getBeanForWorkflowFromArray(arr);
                    wfBeansList.add(ww);
                }
                realLen = ((Long)qTotal.getSingleResult()).intValue();
                return new WorkflowsInfo(wfBeansList, start, len, realLen);
            }
        });
        return workFlowsInfo;
    }

    public WorkflowJobBean getWorkflowInfo(final String id) throws StoreException {
        ParamChecker.notEmpty(id, "WorkflowID");
        WorkflowJobBean wfBean = this.doOperation("getWorkflowInfo", new Callable<WorkflowJobBean>(){

            @Override
            public WorkflowJobBean call() throws SQLException, StoreException, InterruptedException {
                WorkflowJobBean wfBean = null;
                wfBean = WorkflowStore.this.getWorkflowforInfo(id, false);
                if (wfBean == null) {
                    throw new StoreException(ErrorCode.E0604, id);
                }
                wfBean.setActions(WorkflowStore.this.getActionsForWorkflow(id, false));
                return wfBean;
            }
        });
        return wfBean;
    }

    public WorkflowJobBean getWorkflowInfoWithActionsSubset(final String id, final int start, final int len) throws StoreException {
        ParamChecker.notEmpty(id, "WorkflowID");
        WorkflowJobBean wfBean = this.doOperation("getWorkflowInfo", new Callable<WorkflowJobBean>(){

            @Override
            public WorkflowJobBean call() throws SQLException, StoreException, InterruptedException {
                WorkflowJobBean wfBean = null;
                wfBean = WorkflowStore.this.getWorkflowforInfo(id, false);
                if (wfBean == null) {
                    throw new StoreException(ErrorCode.E0604, id);
                }
                wfBean.setActions(WorkflowStore.this.getActionsSubsetForWorkflow(id, start, len));
                return wfBean;
            }
        });
        return wfBean;
    }

    public String getWorkflowIdForExternalId(final String externalId) throws StoreException {
        ParamChecker.notEmpty(externalId, "externalId");
        String wfId = this.doOperation("getWorkflowIdForExternalId", new Callable<String>(){

            @Override
            public String call() throws SQLException, StoreException {
                String id = "";
                Query q = WorkflowStore.this.entityManager.createNamedQuery("GET_WORKFLOW_ID_FOR_EXTERNAL_ID");
                q.setParameter("externalId", (Object)externalId);
                List w = q.getResultList();
                if (w.size() == 0) {
                    id = "";
                } else {
                    int index = w.size() - 1;
                    id = (String)w.get(index);
                }
                return id;
            }
        });
        return wfId;
    }

    public void purge(final long olderThanDays, final int limit) throws StoreException {
        this.doOperation("purge", new Callable<Void>(){

            @Override
            public Void call() throws SQLException, StoreException, WorkflowException {
                Timestamp maxEndTime = new Timestamp(System.currentTimeMillis() - olderThanDays * 86400000L);
                Query q = WorkflowStore.this.entityManager.createNamedQuery("GET_COMPLETED_WORKFLOWS_OLDER_THAN");
                q.setParameter("endTime", (Object)maxEndTime);
                q.setMaxResults(limit);
                List workflows = q.getResultList();
                int actionDeleted = 0;
                if (workflows.size() != 0) {
                    for (WorkflowJobBean w : workflows) {
                        String wfId = w.getId();
                        WorkflowStore.this.entityManager.remove((Object)w);
                        Query g = WorkflowStore.this.entityManager.createNamedQuery("DELETE_ACTIONS_FOR_WORKFLOW");
                        g.setParameter("wfId", (Object)wfId);
                        actionDeleted += g.executeUpdate();
                    }
                }
                XLog.getLog(this.getClass()).debug("ENDED Workflow Purge deleted jobs :" + workflows.size() + " and actions " + actionDeleted);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V doOperation(String name, Callable<V> command) throws StoreException {
        try {
            V retVal;
            Instrumentation.Cron cron = new Instrumentation.Cron();
            cron.start();
            try {
                retVal = command.call();
            }
            finally {
                cron.stop();
            }
            Services.get().get(InstrumentationService.class).get().addCron(INSTR_GROUP, name, cron);
            return retVal;
        }
        catch (StoreException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            throw new StoreException(ErrorCode.E0603, name, ex.getMessage(), ex);
        }
        catch (Exception e) {
            throw new StoreException(ErrorCode.E0607, name, e.getMessage(), e);
        }
    }

    private WorkflowJobBean getWorkflowOnly(String id, boolean locking) throws SQLException, InterruptedException, StoreException {
        WorkflowJobBean wfBean = null;
        Query q = this.entityManager.createNamedQuery("GET_WORKFLOW");
        q.setParameter("id", (Object)id);
        List w = q.getResultList();
        if (w.size() > 0) {
            wfBean = (WorkflowJobBean)w.get(0);
        }
        return wfBean;
    }

    private WorkflowJobBean getWorkflowforInfo(String id, boolean locking) throws SQLException, InterruptedException, StoreException {
        WorkflowJobBean wfBean = null;
        Query q = this.entityManager.createNamedQuery("GET_WORKFLOW");
        q.setParameter("id", (Object)id);
        List w = q.getResultList();
        if (w.size() > 0) {
            wfBean = (WorkflowJobBean)w.get(0);
            return this.getBeanForRunningWorkflow(wfBean);
        }
        return null;
    }

    private WorkflowJobBean getBeanForRunningWorkflow(WorkflowJobBean w) throws SQLException {
        WorkflowJobBean wfBean = new WorkflowJobBean();
        wfBean.setId(w.getId());
        wfBean.setAppName(w.getAppName());
        wfBean.setAppPath(w.getAppPath());
        wfBean.setConf(w.getConf());
        wfBean.setGroup(w.getGroup());
        wfBean.setRun(w.getRun());
        wfBean.setUser(w.getUser());
        wfBean.setAuthToken(w.getAuthToken());
        wfBean.setCreatedTime(w.getCreatedTime());
        wfBean.setEndTime(w.getEndTime());
        wfBean.setExternalId(w.getExternalId());
        wfBean.setLastModifiedTime(w.getLastModifiedTime());
        wfBean.setLogToken(w.getLogToken());
        wfBean.setProtoActionConf(w.getProtoActionConf());
        wfBean.setSlaXml(w.getSlaXml());
        wfBean.setStartTime(w.getStartTime());
        wfBean.setStatus(w.getStatus());
        wfBean.setWfInstance(w.getWfInstance());
        return wfBean;
    }

    private WorkflowJobBean getBeanForWorkflowFromArray(Object[] arr) {
        WorkflowJobBean wfBean = new WorkflowJobBean();
        wfBean.setId((String)arr[0]);
        if (arr[1] != null) {
            wfBean.setAppName((String)arr[1]);
        }
        if (arr[2] != null) {
            wfBean.setStatus(WorkflowJob.Status.valueOf((String)((String)arr[2])));
        }
        if (arr[3] != null) {
            wfBean.setRun((Integer)arr[3]);
        }
        if (arr[4] != null) {
            wfBean.setUser((String)arr[4]);
        }
        if (arr[5] != null) {
            wfBean.setGroup((String)arr[5]);
        }
        if (arr[6] != null) {
            wfBean.setCreatedTime((Timestamp)arr[6]);
        }
        if (arr[7] != null) {
            wfBean.setStartTime((Timestamp)arr[7]);
        }
        if (arr[8] != null) {
            wfBean.setLastModifiedTime((Timestamp)arr[8]);
        }
        if (arr[9] != null) {
            wfBean.setEndTime((Timestamp)arr[9]);
        }
        return wfBean;
    }

    private WorkflowActionBean getBeanForRunningAction(WorkflowActionBean a) throws SQLException {
        if (a != null) {
            WorkflowActionBean action = new WorkflowActionBean();
            action.setId(a.getId());
            action.setConf(a.getConf());
            action.setConsoleUrl(a.getConsoleUrl());
            action.setData(a.getData());
            action.setErrorInfo(a.getErrorCode(), a.getErrorMessage());
            action.setExternalId(a.getExternalId());
            action.setExternalStatus(a.getExternalStatus());
            action.setName(a.getName());
            action.setCred(a.getCred());
            action.setRetries(a.getRetries());
            action.setTrackerUri(a.getTrackerUri());
            action.setTransition(a.getTransition());
            action.setType(a.getType());
            action.setEndTime(a.getEndTime());
            action.setExecutionPath(a.getExecutionPath());
            action.setLastCheckTime(a.getLastCheckTime());
            action.setLogToken(a.getLogToken());
            if (a.getPending()) {
                action.setPending();
            }
            action.setPendingAge(a.getPendingAge());
            action.setSignalValue(a.getSignalValue());
            action.setSlaXml(a.getSlaXml());
            action.setStartTime(a.getStartTime());
            action.setStatus(a.getStatus());
            action.setJobId(a.getWfId());
            action.setUserRetryCount(a.getUserRetryCount());
            action.setUserRetryInterval(a.getUserRetryInterval());
            action.setUserRetryMax(a.getUserRetryMax());
            return action;
        }
        return null;
    }

    private void setWFQueryParameters(WorkflowJobBean wfBean, Query q) {
        q.setParameter("appName", (Object)wfBean.getAppName());
        q.setParameter("appPath", (Object)wfBean.getAppPath());
        q.setParameter("conf", (Object)wfBean.getConf());
        q.setParameter("groupName", (Object)wfBean.getGroup());
        q.setParameter("run", (Object)wfBean.getRun());
        q.setParameter("user", (Object)wfBean.getUser());
        q.setParameter("authToken", (Object)wfBean.getAuthToken());
        q.setParameter("createdTime", (Object)wfBean.getCreatedTimestamp());
        q.setParameter("endTime", (Object)wfBean.getEndTimestamp());
        q.setParameter("externalId", (Object)wfBean.getExternalId());
        q.setParameter("lastModTime", (Object)new Date());
        q.setParameter("logToken", (Object)wfBean.getLogToken());
        q.setParameter("protoActionConf", (Object)wfBean.getProtoActionConf());
        q.setParameter("slaXml", (Object)wfBean.getSlaXml());
        q.setParameter("startTime", (Object)wfBean.getStartTimestamp());
        q.setParameter("status", (Object)wfBean.getStatusStr());
        q.setParameter("wfInstance", (Object)wfBean.getWfInstance());
    }

    private void setActionQueryParameters(WorkflowActionBean aBean, Query q) {
        q.setParameter("conf", (Object)aBean.getConf());
        q.setParameter("consoleUrl", (Object)aBean.getConsoleUrl());
        q.setParameter("data", (Object)aBean.getData());
        q.setParameter("errorCode", (Object)aBean.getErrorCode());
        q.setParameter("errorMessage", (Object)aBean.getErrorMessage());
        q.setParameter("externalId", (Object)aBean.getExternalId());
        q.setParameter("externalStatus", (Object)aBean.getExternalStatus());
        q.setParameter("name", (Object)aBean.getName());
        q.setParameter("cred", (Object)aBean.getCred());
        q.setParameter("retries", (Object)aBean.getRetries());
        q.setParameter("trackerUri", (Object)aBean.getTrackerUri());
        q.setParameter("transition", (Object)aBean.getTransition());
        q.setParameter("type", (Object)aBean.getType());
        q.setParameter("endTime", (Object)aBean.getEndTimestamp());
        q.setParameter("executionPath", (Object)aBean.getExecutionPath());
        q.setParameter("lastCheckTime", (Object)aBean.getLastCheckTimestamp());
        q.setParameter("logToken", (Object)aBean.getLogToken());
        q.setParameter("pending", (Object)(aBean.isPending() ? 1 : 0));
        q.setParameter("pendingAge", (Object)aBean.getPendingAgeTimestamp());
        q.setParameter("signalValue", (Object)aBean.getSignalValue());
        q.setParameter("slaXml", (Object)aBean.getSlaXml());
        q.setParameter("startTime", (Object)aBean.getStartTimestamp());
        q.setParameter("status", (Object)aBean.getStatusStr());
        q.setParameter("wfId", (Object)aBean.getWfId());
    }
}

