/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.executor.jpa.CoordJobGetActionsForDatesJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ParamChecker;

public class CoordActionsInDateRange {
    public static List<CoordinatorActionBean> getCoordActionsFromDates(String jobId, String scope) throws XException {
        String[] list;
        ParamChecker.notEmpty(jobId, "jobId");
        ParamChecker.notEmpty(scope, "scope");
        HashSet<CoordinatorActionBean> actionSet = new HashSet<CoordinatorActionBean>();
        for (String s : list = scope.split(",")) {
            Date end;
            Date start;
            if ((s = s.trim()).contains("::")) {
                String[] dateRange = s.split("::");
                if (dateRange.length != 2) {
                    throw new XException(ErrorCode.E0308, "'" + s + "'. Date value expected on both sides of the scope resolution operator '::' to signify start and end of range");
                }
                try {
                    start = DateUtils.parseDateUTC(dateRange[0].trim());
                    end = DateUtils.parseDateUTC(dateRange[1].trim());
                }
                catch (Exception dx) {
                    throw new XException(ErrorCode.E0308, "Error in parsing start or end date");
                }
                if (start.after(end)) {
                    throw new XException(ErrorCode.E0308, "'" + s + "'. Start date '" + start + "' is older than end date: '" + end + "'");
                }
            } else {
                throw new XException(ErrorCode.E0308, "'" + s + "'. Separator '::' is missing for start and end dates of range");
            }
            List<CoordinatorActionBean> listOfActions = CoordActionsInDateRange.getActionIdsFromDateRange(jobId, start, end);
            actionSet.addAll(listOfActions);
        }
        ArrayList<CoordinatorActionBean> coordActions = new ArrayList<CoordinatorActionBean>();
        for (CoordinatorActionBean coordAction : actionSet) {
            coordActions.add(coordAction);
        }
        return coordActions;
    }

    private static List<CoordinatorActionBean> getActionIdsFromDateRange(String jobId, Date start, Date end) throws XException {
        JPAService jpaService = Services.get().get(JPAService.class);
        List<CoordinatorActionBean> list = jpaService.execute(new CoordJobGetActionsForDatesJPAExecutor(jobId, start, end));
        return list;
    }
}

