/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.FunctionMapper;
import javax.servlet.jsp.el.VariableResolver;
import org.apache.commons.el.ExpressionEvaluatorImpl;
import org.apache.oozie.util.XLog;

public class ELEvaluator {
    private static ThreadLocal<ELEvaluator> current = new ThreadLocal();
    private Context context;
    private ExpressionEvaluator evaluator = new ExpressionEvaluatorImpl();

    public static ELEvaluator getCurrent() {
        return current.get();
    }

    public ELEvaluator() {
        this(new Context());
    }

    public ELEvaluator(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public void setVariable(String name, Object value) {
        this.context.setVariable(name, value);
    }

    public Object getVariable(String name) {
        return this.context.getVariable(name);
    }

    public <T> T evaluate(String expr, Class<T> clazz) throws Exception {
        ELEvaluator existing = current.get();
        try {
            current.set(this);
            Object object = this.evaluator.evaluate(expr, clazz, (VariableResolver)this.context, (FunctionMapper)this.context);
            return (T)object;
        }
        catch (ELException ex) {
            if (ex.getRootCause() instanceof Exception) {
                throw (Exception)ex.getRootCause();
            }
            throw ex;
        }
        finally {
            current.set(existing);
        }
    }

    public static class Context
    implements VariableResolver,
    FunctionMapper {
        private Map<String, Object> vars = new HashMap<String, Object>();
        private Map<String, Method> functions = new HashMap<String, Method>();

        public void setVariables(Map<String, Object> vars) {
            this.vars.putAll(vars);
        }

        public void setVariable(String name, Object value) {
            this.vars.put(name, value);
        }

        public Object getVariable(String name) {
            return this.vars.get(name);
        }

        public void addFunction(String prefix, String functionName, Method method) {
            if ((method.getModifiers() & 9) != 9) {
                throw new IllegalArgumentException(XLog.format("Method[{0}] must be public and static", method));
            }
            prefix = prefix.length() > 0 ? prefix + ":" : "";
            this.functions.put(prefix + functionName, method);
        }

        public Object resolveVariable(String name) throws ELException {
            if (!this.vars.containsKey(name)) {
                throw new ELException(XLog.format("variable [{0}] cannot be resolved", name));
            }
            return this.vars.get(name);
        }

        public Method resolveFunction(String prefix, String name) {
            if (prefix.length() > 0) {
                name = prefix + ":" + name;
            }
            return this.functions.get(name);
        }
    }
}

