/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.XLog;

public class ParamChecker {
    private static final int MAX_NODE_NAME_LEN = 50;

    public static <T> T notNull(T obj, String name) {
        if (obj == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
        return obj;
    }

    public static <T> List<T> notNullElements(List<T> list, String name) {
        ParamChecker.notNull(list, name);
        for (int i = 0; i < list.size(); ++i) {
            ParamChecker.notNull(list.get(i), XLog.format("list [{0}] element [{1}]", name, i));
        }
        return list;
    }

    public static String notEmpty(String str, String name) {
        if (str == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
        if (str.length() == 0) {
            throw new IllegalArgumentException(name + " cannot be empty");
        }
        return str;
    }

    public static List<String> notEmptyElements(List<String> list, String name) {
        ParamChecker.notNull(list, name);
        for (int i = 0; i < list.size(); ++i) {
            ParamChecker.notEmpty(list.get(i), XLog.format("list [{0}] element [{1}]", name, i));
        }
        return list;
    }

    public static String validateActionName(String actionName) {
        ParamChecker.notEmpty(actionName, "action name");
        if (actionName.length() > 50) {
            throw new IllegalArgumentException(XLog.format("name [{0}] must be {1} chars or less", actionName, 50));
        }
        char c = actionName.charAt(0);
        if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_')) {
            throw new IllegalArgumentException(XLog.format("name [{0}], must start with [A-Za-z_]", actionName));
        }
        for (int i = 1; i < actionName.length(); ++i) {
            c = actionName.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c == '-') continue;
            throw new IllegalArgumentException(XLog.format("name [{0}] must be [A-Za-z_][0-9A-Za-z_]*", actionName));
        }
        return actionName;
    }

    public static boolean isValidIdentifier(String token) {
        ParamChecker.notEmpty(token, "identifier");
        for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_')) {
                return false;
            }
            if (i != 0 || c < '0' || c > '9') continue;
            return false;
        }
        return true;
    }

    public static int checkGTZero(int value, String name) {
        if (value <= 0) {
            throw new IllegalArgumentException(XLog.format("parameter [{0}] = [{1}] must be greater than zero", name, value));
        }
        return value;
    }

    public static int checkGEZero(int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException(XLog.format("parameter [{0}] = [{1}] must be greater than or equals zero", name, value));
        }
        return value;
    }

    public static int checkInteger(String val, String name) {
        int ret;
        try {
            ret = Integer.parseInt(val);
        }
        catch (NumberFormatException nex) {
            throw new IllegalArgumentException(XLog.format("parameter [{0}] = [{1}]  must be an integer. Parsing error {2}", name, val, nex));
        }
        return ret;
    }

    public static Date checkUTC(String date, String name) {
        Date ret;
        try {
            ret = DateUtils.parseDateUTC(date);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(XLog.format("parameter [{0}] = [{1}] must be Date in UTC format (yyyy-MM-dd'T'HH:mm'Z'). Parsing error {2}", name, date, ex));
        }
        return ret;
    }

    public static TimeZone checkTimeZone(String tzStr, String name) {
        TimeZone tz;
        try {
            tz = DateUtils.getTimeZone(tzStr);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(XLog.format("parameter [{0}] = [{1}] must be a valid TZ. Parsing error {2}", name, tzStr, ex));
        }
        return tz;
    }

    public static boolean isMember(String item, String[] members, String name) {
        for (int i = 0; i < members.length; ++i) {
            if (!members[i].equals(item)) continue;
            return true;
        }
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < members.length; ++i) {
            buff.append(members[i]).append(", ");
        }
        throw new IllegalArgumentException(XLog.format("parameter [{0}] = [{1}] must be in the list {2}", name, item, buff.toString()));
    }
}

