/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.workflow.lite;

import java.util.List;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.lite.NodeHandler;

public abstract class ActionNodeHandler
extends NodeHandler {
    public static final String OK = "OK";
    public static final String ERROR = "ERROR";

    @Override
    public final boolean enter(NodeHandler.Context context) throws WorkflowException {
        this.start(context);
        return false;
    }

    @Override
    public final String exit(NodeHandler.Context context) throws WorkflowException {
        this.end(context);
        List<String> transitions = context.getNodeDef().getTransitions();
        String signalValue = context.getSignalValue();
        if (OK.equals(signalValue)) {
            return transitions.get(0);
        }
        if (ERROR.equals(signalValue)) {
            return transitions.get(1);
        }
        throw new WorkflowException(ErrorCode.E0722, context.getNodeDef().getName());
    }

    public abstract void start(NodeHandler.Context var1) throws WorkflowException;

    public abstract void end(NodeHandler.Context var1) throws WorkflowException;
}

