/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.workflow.lite;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.workflow.WorkflowApp;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.NodeHandler;

public class LiteWorkflowInstance
implements Writable,
WorkflowInstance {
    private static final String TRANSITION_TO = "transition.to";
    private XLog log;
    private static String PATH_SEPARATOR;
    private static String ROOT;
    private static String TRANSITION_SEPARATOR;
    private LiteWorkflowApp def;
    private Configuration conf;
    private String instanceId;
    private WorkflowInstance.Status status;
    private Map<String, NodeInstance> executionPaths = new HashMap<String, NodeInstance>();
    private Map<String, String> persistentVars = new HashMap<String, String>();
    private Map<String, Object> transientVars = new HashMap<String, Object>();

    protected LiteWorkflowInstance() {
        this.log = XLog.getLog(this.getClass());
    }

    public LiteWorkflowInstance(LiteWorkflowApp def, Configuration conf, String instanceId) {
        this();
        this.def = ParamChecker.notNull(def, "def");
        this.instanceId = ParamChecker.notNull(instanceId, "instanceId");
        this.conf = ParamChecker.notNull(conf, "conf");
        this.refreshLog();
        this.status = WorkflowInstance.Status.PREP;
    }

    @Override
    public synchronized boolean start() throws WorkflowException {
        if (this.status != WorkflowInstance.Status.PREP) {
            throw new WorkflowException(ErrorCode.E0719, new Object[0]);
        }
        this.log.debug(1, "Starting job", new Object[0]);
        this.status = WorkflowInstance.Status.RUNNING;
        this.executionPaths.put(ROOT, new NodeInstance("::start::"));
        return this.signal(ROOT, "::start::");
    }

    @Override
    public synchronized boolean signal(String executionPath, String signalValue) throws WorkflowException {
        ParamChecker.notEmpty(executionPath, "executionPath");
        ParamChecker.notNull(signalValue, "signalValue");
        this.log.debug(1, "Signaling job execution path [{0}] signal value [{1}]", executionPath, signalValue);
        if (this.status != WorkflowInstance.Status.RUNNING) {
            throw new WorkflowException(ErrorCode.E0716, new Object[0]);
        }
        NodeInstance nodeJob = this.executionPaths.get(executionPath);
        if (nodeJob == null) {
            this.status = WorkflowInstance.Status.FAILED;
            this.log.error("invalid execution path [{0}]", executionPath);
        }
        NodeDef nodeDef = null;
        if (!this.status.isEndState() && (nodeDef = this.def.getNode(nodeJob.nodeName)) == null) {
            this.status = WorkflowInstance.Status.FAILED;
            this.log.error("invalid transition [{0}]", nodeJob.nodeName);
        }
        if (!this.status.isEndState()) {
            NodeHandler nodeHandler = this.newInstance(nodeDef.getHandlerClass());
            boolean exiting = true;
            Context context = new Context(nodeDef, executionPath, signalValue);
            if (!nodeJob.started) {
                try {
                    nodeHandler.loopDetection(context);
                    exiting = nodeHandler.enter(context);
                    nodeJob.started = true;
                }
                catch (WorkflowException ex) {
                    this.status = WorkflowInstance.Status.FAILED;
                    throw ex;
                }
            }
            if (exiting) {
                List<String> fullTransitions;
                ArrayList<String> pathsToStart = new ArrayList<String>();
                try {
                    fullTransitions = nodeHandler.multiExit(context);
                    int last = fullTransitions.size() - 1;
                    if (last >= 0) {
                        String transitionTo = LiteWorkflowInstance.getTransitionNode(fullTransitions.get(last));
                        this.persistentVars.put(nodeDef.getName() + "#" + TRANSITION_TO, transitionTo);
                    }
                }
                catch (WorkflowException ex) {
                    this.status = WorkflowInstance.Status.FAILED;
                    throw ex;
                }
                if (context.status == WorkflowInstance.Status.KILLED) {
                    this.status = WorkflowInstance.Status.KILLED;
                    this.log.debug(1, "Completing job, kill node [{0}]", nodeJob.nodeName);
                } else if (context.status == WorkflowInstance.Status.FAILED) {
                    this.status = WorkflowInstance.Status.FAILED;
                    this.log.debug(1, "Completing job, fail node [{0}]", nodeJob.nodeName);
                } else if (context.status == WorkflowInstance.Status.SUCCEEDED) {
                    this.status = WorkflowInstance.Status.SUCCEEDED;
                    this.log.debug(1, "Completing job, end node [{0}]", nodeJob.nodeName);
                } else {
                    for (String fullTransition : fullTransitions) {
                        this.log.debug(1, "Exiting node [{0}] with transition[{1}]", nodeJob.nodeName, fullTransition);
                        String execPathFromTransition = LiteWorkflowInstance.getExecutionPath(fullTransition);
                        String transition = LiteWorkflowInstance.getTransitionNode(fullTransition);
                        this.def.validateTransition(nodeJob.nodeName, transition);
                        NodeInstance nodeJobInPath = this.executionPaths.get(execPathFromTransition);
                        if (nodeJobInPath != null && transition.equals(nodeJobInPath.nodeName)) continue;
                        this.executionPaths.put(execPathFromTransition, new NodeInstance(transition));
                        pathsToStart.add(execPathFromTransition);
                    }
                    for (String pathToStart : pathsToStart) {
                        this.signal(pathToStart, "::synch::");
                    }
                }
            }
        }
        if (this.status.isEndState()) {
            if (this.status == WorkflowInstance.Status.FAILED) {
                List<String> failedNodes = this.terminateNodes(this.status);
                this.log.warn(1, "Workflow completed [{0}], failing [{1}] running nodes", new Object[]{this.status, failedNodes.size()});
            } else {
                List<String> killedNodes = this.terminateNodes(WorkflowInstance.Status.KILLED);
                if (killedNodes.size() > 1) {
                    this.log.warn(1, "Workflow completed [{0}], killing [{1}] running nodes", new Object[]{this.status, killedNodes.size()});
                }
            }
        }
        return this.status.isEndState();
    }

    @Override
    public NodeDef getNodeDef(String executionPath) {
        NodeInstance nodeJob = this.executionPaths.get(executionPath);
        NodeDef nodeDef = null;
        if (nodeJob == null) {
            this.log.error("invalid execution path [{0}]", executionPath);
        } else {
            nodeDef = this.def.getNode(nodeJob.nodeName);
            if (nodeDef == null) {
                this.log.error("invalid transition [{0}]", nodeJob.nodeName);
            }
        }
        return nodeDef;
    }

    @Override
    public synchronized void fail(String nodeName) throws WorkflowException {
        List<String> killedNodes;
        if (this.status.isEndState()) {
            throw new WorkflowException(ErrorCode.E0718, new Object[0]);
        }
        String failedNode = this.failNode(nodeName);
        if (failedNode != null) {
            this.log.warn(1, "Workflow Failed. Failing node [{0}]", failedNode);
        }
        if ((killedNodes = this.killNodes()).size() > 1) {
            this.log.warn(1, "Workflow Failed, killing [{0}] nodes", killedNodes.size());
        }
        this.status = WorkflowInstance.Status.FAILED;
    }

    @Override
    public synchronized void kill() throws WorkflowException {
        if (this.status.isEndState()) {
            throw new WorkflowException(ErrorCode.E0718, new Object[0]);
        }
        this.log.debug(1, "Killing job", new Object[0]);
        List<String> killedNodes = this.killNodes();
        if (killedNodes.size() > 1) {
            this.log.warn(1, "workflow killed, killing [{0}] nodes", killedNodes.size());
        }
        this.status = WorkflowInstance.Status.KILLED;
    }

    @Override
    public synchronized void suspend() throws WorkflowException {
        if (this.status != WorkflowInstance.Status.RUNNING) {
            throw new WorkflowException(ErrorCode.E0716, new Object[0]);
        }
        this.log.debug(1, "Suspending job", new Object[0]);
        this.status = WorkflowInstance.Status.SUSPENDED;
    }

    public boolean isSuspended() {
        return this.status == WorkflowInstance.Status.SUSPENDED;
    }

    @Override
    public synchronized void resume() throws WorkflowException {
        if (this.status != WorkflowInstance.Status.SUSPENDED) {
            throw new WorkflowException(ErrorCode.E0717, new Object[0]);
        }
        this.log.debug(1, "Resuming job", new Object[0]);
        this.status = WorkflowInstance.Status.RUNNING;
    }

    @Override
    public void setVar(String name, String value) {
        if (value != null) {
            this.persistentVars.put(name, value);
        } else {
            this.persistentVars.remove(name);
        }
    }

    @Override
    public Map<String, String> getAllVars() {
        return this.persistentVars;
    }

    @Override
    public void setAllVars(Map<String, String> varMap) {
        this.persistentVars.putAll(varMap);
    }

    @Override
    public String getVar(String name) {
        return this.persistentVars.get(name);
    }

    @Override
    public void setTransientVar(String name, Object value) {
        if (value != null) {
            this.transientVars.put(name, value);
        } else {
            this.transientVars.remove(name);
        }
    }

    public boolean hasTransientVar(String name) {
        return this.transientVars.containsKey(name);
    }

    @Override
    public Object getTransientVar(String name) {
        return this.transientVars.get(name);
    }

    public boolean hasEnded() {
        return this.status.isEndState();
    }

    private List<String> terminateNodes(WorkflowInstance.Status endStatus) {
        ArrayList<String> endNodes = new ArrayList<String>();
        for (Map.Entry<String, NodeInstance> entry : this.executionPaths.entrySet()) {
            if (!entry.getValue().started) continue;
            NodeDef nodeDef = this.def.getNode(entry.getValue().nodeName);
            NodeHandler nodeHandler = this.newInstance(nodeDef.getHandlerClass());
            try {
                if (endStatus == WorkflowInstance.Status.KILLED) {
                    nodeHandler.kill(new Context(nodeDef, entry.getKey(), null));
                } else if (endStatus == WorkflowInstance.Status.FAILED) {
                    nodeHandler.fail(new Context(nodeDef, entry.getKey(), null));
                }
                endNodes.add(nodeDef.getName());
            }
            catch (Exception ex) {
                this.log.warn(1, "Error Changing node state to [{0}] for Node [{1}]", endStatus.toString(), nodeDef.getName(), ex);
            }
        }
        return endNodes;
    }

    private String failNode(String nodeName) {
        String failedNode = null;
        for (Map.Entry<String, NodeInstance> entry : this.executionPaths.entrySet()) {
            String node = entry.getKey();
            NodeInstance nodeInstance = entry.getValue();
            if (!nodeInstance.started || !nodeInstance.nodeName.equals(nodeName)) continue;
            NodeDef nodeDef = this.def.getNode(nodeInstance.nodeName);
            NodeHandler nodeHandler = this.newInstance(nodeDef.getHandlerClass());
            try {
                nodeHandler.fail(new Context(nodeDef, node, null));
                failedNode = nodeDef.getName();
                nodeInstance.started = false;
            }
            catch (Exception ex) {
                this.log.warn(1, "Error failing node [{0}]", nodeDef.getName(), ex);
            }
            return failedNode;
        }
        return failedNode;
    }

    private List<String> killNodes() {
        ArrayList<String> killedNodes = new ArrayList<String>();
        for (Map.Entry<String, NodeInstance> entry : this.executionPaths.entrySet()) {
            String node = entry.getKey();
            NodeInstance nodeInstance = entry.getValue();
            if (!nodeInstance.started) continue;
            NodeDef nodeDef = this.def.getNode(nodeInstance.nodeName);
            NodeHandler nodeHandler = this.newInstance(nodeDef.getHandlerClass());
            try {
                nodeHandler.kill(new Context(nodeDef, node, null));
                killedNodes.add(nodeDef.getName());
            }
            catch (Exception ex) {
                this.log.warn(1, "Error killing node [{0}]", nodeDef.getName(), ex);
            }
        }
        return killedNodes;
    }

    public LiteWorkflowApp getProcessDefinition() {
        return this.def;
    }

    private static String createChildPath(String path, String child) {
        return path + child + PATH_SEPARATOR;
    }

    private static String getParentPath(String path) {
        return (path = path.substring(0, path.length() - 1)).length() == 0 ? null : path.substring(0, path.lastIndexOf(PATH_SEPARATOR) + 1);
    }

    private static String createFullTransition(String executionPath, String transition) {
        return executionPath + TRANSITION_SEPARATOR + transition;
    }

    private static String getExecutionPath(String fullTransition) {
        int index = fullTransition.indexOf(TRANSITION_SEPARATOR);
        if (index == -1) {
            throw new IllegalArgumentException("Invalid fullTransition");
        }
        return fullTransition.substring(0, index);
    }

    private static String getTransitionNode(String fullTransition) {
        int index = fullTransition.indexOf(TRANSITION_SEPARATOR);
        if (index == -1) {
            throw new IllegalArgumentException("Invalid fullTransition");
        }
        return fullTransition.substring(index + 1);
    }

    private NodeHandler newInstance(Class<? extends NodeHandler> handler) {
        return (NodeHandler)ReflectionUtils.newInstance(handler, null);
    }

    private void refreshLog() {
        XLog.Info.get().setParameter("USER", this.conf.get("user.name"));
        XLog.Info.get().setParameter("GROUP", this.conf.get("group.name"));
        XLog.Info.get().setParameter("APP", this.def.getName());
        XLog.Info.get().setParameter("TOKEN", this.conf.get("oozie.wf.log.token", ""));
        XLog.Info.get().setParameter("JOB", this.instanceId);
        this.log = XLog.getLog(this.getClass());
    }

    @Override
    public WorkflowInstance.Status getStatus() {
        return this.status;
    }

    public void setStatus(WorkflowInstance.Status status) {
        this.status = status;
    }

    public void write(DataOutput dOut) throws IOException {
        dOut.writeUTF(this.instanceId);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.conf.writeXml((OutputStream)baos);
        baos.close();
        byte[] array = baos.toByteArray();
        dOut.writeInt(array.length);
        dOut.write(array);
        this.def.write(dOut);
        dOut.writeUTF(this.status.toString());
        dOut.writeInt(this.executionPaths.size());
        for (Map.Entry<String, NodeInstance> entry : this.executionPaths.entrySet()) {
            dOut.writeUTF(entry.getKey());
            dOut.writeUTF(entry.getValue().nodeName);
            dOut.writeBoolean(entry.getValue().started);
        }
        dOut.writeInt(this.persistentVars.size());
        for (Map.Entry<String, Object> entry : this.persistentVars.entrySet()) {
            dOut.writeUTF(entry.getKey());
            dOut.writeUTF((String)entry.getValue());
        }
    }

    public void readFields(DataInput dIn) throws IOException {
        this.instanceId = dIn.readUTF();
        int len = dIn.readInt();
        byte[] array = new byte[len];
        dIn.readFully(array);
        ByteArrayInputStream bais = new ByteArrayInputStream(array);
        this.conf = new XConfiguration(bais);
        this.def = new LiteWorkflowApp();
        this.def.readFields(dIn);
        this.status = WorkflowInstance.Status.valueOf(dIn.readUTF());
        int numExPaths = dIn.readInt();
        for (int x = 0; x < numExPaths; ++x) {
            String path = dIn.readUTF();
            String nodeName = dIn.readUTF();
            boolean isStarted = dIn.readBoolean();
            NodeInstance nodeInstance = new NodeInstance(nodeName);
            nodeInstance.started = isStarted;
            this.executionPaths.put(path, nodeInstance);
        }
        int numVars = dIn.readInt();
        for (int x = 0; x < numVars; ++x) {
            String vName = dIn.readUTF();
            String vVal = dIn.readUTF();
            this.persistentVars.put(vName, vVal);
        }
        this.refreshLog();
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public WorkflowApp getApp() {
        return this.def;
    }

    @Override
    public String getId() {
        return this.instanceId;
    }

    @Override
    public String getTransition(String node) {
        return this.persistentVars.get(node + "#" + TRANSITION_TO);
    }

    public boolean equals(Object o) {
        return o != null && this.getClass().isInstance(o) && ((WorkflowInstance)o).getId().equals(this.instanceId);
    }

    public int hashCode() {
        return this.instanceId.hashCode();
    }

    static {
        ROOT = PATH_SEPARATOR = "/";
        TRANSITION_SEPARATOR = "#";
    }

    private class Context
    implements NodeHandler.Context {
        private NodeDef nodeDef;
        private String executionPath;
        private String exitState;
        private WorkflowInstance.Status status = WorkflowInstance.Status.RUNNING;

        private Context(NodeDef nodeDef, String executionPath, String exitState) {
            this.nodeDef = nodeDef;
            this.executionPath = executionPath;
            this.exitState = exitState;
        }

        @Override
        public NodeDef getNodeDef() {
            return this.nodeDef;
        }

        @Override
        public String getExecutionPath() {
            return this.executionPath;
        }

        @Override
        public String getParentExecutionPath(String executionPath) {
            return LiteWorkflowInstance.getParentPath(executionPath);
        }

        @Override
        public String getSignalValue() {
            return this.exitState;
        }

        @Override
        public String createExecutionPath(String name) {
            return LiteWorkflowInstance.createChildPath(this.executionPath, name);
        }

        @Override
        public String createFullTransition(String executionPath, String transition) {
            return LiteWorkflowInstance.createFullTransition(executionPath, transition);
        }

        @Override
        public void deleteExecutionPath() {
            if (!LiteWorkflowInstance.this.executionPaths.containsKey(this.executionPath)) {
                throw new IllegalStateException();
            }
            LiteWorkflowInstance.this.executionPaths.remove(this.executionPath);
            this.executionPath = LiteWorkflowInstance.getParentPath(this.executionPath);
        }

        public void failJob() {
            this.status = WorkflowInstance.Status.FAILED;
        }

        @Override
        public void killJob() {
            this.status = WorkflowInstance.Status.KILLED;
        }

        @Override
        public void completeJob() {
            this.status = WorkflowInstance.Status.SUCCEEDED;
        }

        @Override
        public Object getTransientVar(String name) {
            return LiteWorkflowInstance.this.getTransientVar(name);
        }

        @Override
        public String getVar(String name) {
            return LiteWorkflowInstance.this.getVar(name);
        }

        @Override
        public void setTransientVar(String name, Object value) {
            LiteWorkflowInstance.this.setTransientVar(name, value);
        }

        @Override
        public void setVar(String name, String value) {
            LiteWorkflowInstance.this.setVar(name, value);
        }

        @Override
        public LiteWorkflowInstance getProcessInstance() {
            return LiteWorkflowInstance.this;
        }
    }

    private static class NodeInstance {
        String nodeName;
        boolean started = false;

        private NodeInstance(String nodeName) {
            this.nodeName = nodeName;
        }
    }
}

