/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.FileProvider;
import org.pentaho.hadoop.shim.HadoopConfigurationFileSystemManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveHadoopShimFileProvider
implements FileProvider {
    private HadoopConfigurationFileSystemManager fsm;
    private String scheme;

    public ActiveHadoopShimFileProvider(HadoopConfigurationFileSystemManager fsm, String scheme) {
        if (fsm == null || scheme == null) {
            throw new NullPointerException();
        }
        this.fsm = fsm;
        this.scheme = scheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject createFileSystem(String scheme, FileObject file, FileSystemOptions fileSystemOptions) throws FileSystemException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        FileProvider p = this.fsm.getActiveFileProvider(scheme);
        Thread.currentThread().setContextClassLoader(p.getClass().getClassLoader());
        try {
            FileObject fileObject = p.createFileSystem(scheme, file, fileSystemOptions);
            return fileObject;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        FileProvider p = this.fsm.getActiveFileProvider(this.scheme);
        Thread.currentThread().setContextClassLoader(p.getClass().getClassLoader());
        try {
            FileObject fileObject = p.findFile(baseFile, uri, fileSystemOptions);
            return fileObject;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public Collection<Capability> getCapabilities() {
        try {
            return this.fsm.getActiveFileProvider(this.scheme).getCapabilities();
        }
        catch (FileSystemException e) {
            return Collections.emptyList();
        }
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        try {
            return this.fsm.getActiveFileProvider(this.scheme).getConfigBuilder();
        }
        catch (FileSystemException e) {
            return null;
        }
    }

    public FileName parseUri(FileName root, String uri) throws FileSystemException {
        return this.fsm.getActiveFileProvider(this.scheme).parseUri(root, uri);
    }
}

