/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon;

import java.util.Arrays;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.impl.DefaultFileSystemManager;
import org.apache.commons.vfs.provider.FileProvider;
import org.pentaho.di.core.annotations.KettleLifecyclePlugin;
import org.pentaho.di.core.lifecycle.KettleLifecycleListener;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.s3.vfs.S3FileProvider;

@KettleLifecyclePlugin(id="AmazonS3FileSystemBootstrap", name="Amazon S3 FileSystem Bootstrap")
public class AmazonS3FileSystemBootstrap
implements KettleLifecycleListener {
    private static Class<?> PKG = AmazonS3FileSystemBootstrap.class;
    private LogChannelInterface log = new LogChannel((Object)AmazonS3FileSystemBootstrap.class.getName());

    public static String getS3FileSystemDisplayText() {
        return BaseMessages.getString(PKG, (String)"S3VfsFileChooserDialog.FileSystemChoice.S3.Label", (String[])new String[0]);
    }

    public void onEnvironmentInit() throws LifecycleException {
        try {
            FileSystemManager fsm = KettleVFS.getInstance().getFileSystemManager();
            if (fsm instanceof DefaultFileSystemManager && !Arrays.asList(fsm.getSchemes()).contains("s3")) {
                ((DefaultFileSystemManager)fsm).addProvider("s3", (FileProvider)new S3FileProvider());
            }
        }
        catch (FileSystemException e) {
            this.log.logError(BaseMessages.getString(PKG, (String)"AmazonSpoonPlugin.StartupError.FailedToLoadS3Driver", (String[])new String[0]));
        }
    }

    public void onEnvironmentShutdown() {
    }
}

