/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cassandra;

import java.util.HashMap;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.KsDef;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.pentaho.cassandra.CassandraColumnMetaData;
import org.pentaho.di.core.Const;

public class CassandraConnection {
    private TTransport m_transport;
    protected Cassandra.Client m_client;
    protected String m_keyspaceName;

    public CassandraConnection(String host, int port) throws Exception {
        this(host, port, null, null, -1);
    }

    public CassandraConnection(String host, int port, int timeout) throws Exception {
        this(host, port, null, null, timeout);
    }

    public CassandraConnection(String host, int port, String username, String password, int timeout) throws Exception {
        TSocket socket = new TSocket(host, port);
        if (timeout > 0) {
            socket.setTimeout(timeout);
        }
        this.m_transport = new TFramedTransport((TTransport)socket);
        TBinaryProtocol protocol = new TBinaryProtocol(this.m_transport);
        this.m_client = new Cassandra.Client((TProtocol)protocol);
        this.m_transport.open();
        if (!Const.isEmpty((String)username) && !Const.isEmpty((String)password)) {
            HashMap<String, String> creds = new HashMap<String, String>();
            creds.put("username", username);
            creds.put("password", password);
            this.m_client.login(new AuthenticationRequest(creds));
        }
    }

    public Cassandra.Client getClient() {
        return this.m_client;
    }

    public KsDef describeKeyspace() throws Exception {
        if (this.m_keyspaceName == null || this.m_keyspaceName.length() == 0) {
            throw new Exception("No keyspace has been set!");
        }
        return this.m_client.describe_keyspace(this.m_keyspaceName);
    }

    public void close() {
        if (this.m_transport != null) {
            this.m_transport.close();
            this.m_transport = null;
            this.m_client = null;
        }
    }

    private void checkOpen() throws Exception {
        if (this.m_transport == null && this.m_client == null) {
            throw new Exception("Connection is closed!");
        }
    }

    public void setKeyspace(String keySpace) throws Exception {
        this.checkOpen();
        this.m_client.set_keyspace(keySpace);
        this.m_keyspaceName = keySpace;
    }

    public CassandraColumnMetaData getColumnFamilyMetaData(String colFam) throws Exception {
        if (this.m_keyspaceName == null) {
            throw new Exception("No keypsace set!");
        }
        CassandraColumnMetaData meta = new CassandraColumnMetaData(this, colFam);
        return meta;
    }
}

