/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.avroinput;

import java.io.IOException;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.avroinput.AvroInputData;
import org.pentaho.di.trans.steps.avroinput.AvroInputMeta;

public class AvroInput
extends BaseStep
implements StepInterface {
    protected AvroInputMeta m_meta;
    protected AvroInputData m_data;

    public AvroInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] currentInputRow = this.getRow();
        if (this.first) {
            this.first = false;
            this.m_data = (AvroInputData)sdi;
            this.m_meta = (AvroInputMeta)smi;
            if (Const.isEmpty((String)this.m_meta.getFilename()) && !this.m_meta.getAvroInField()) {
                throw new KettleException(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.NoAvroFileSpecified", (String[])new String[0]));
            }
            String readerSchema = this.m_meta.getSchemaFilename();
            readerSchema = this.environmentSubstitute(readerSchema);
            String avroFieldName = this.m_meta.getAvroFieldName();
            avroFieldName = this.environmentSubstitute(avroFieldName);
            String schemaFieldName = this.m_meta.getSchemaFieldName();
            schemaFieldName = this.environmentSubstitute(schemaFieldName);
            Object outRowMeta = null;
            outRowMeta = this.getInputRowMeta();
            outRowMeta = outRowMeta != null ? outRowMeta.clone() : new RowMeta();
            int newFieldOffset = outRowMeta.size();
            this.m_data.setOutputRowMeta((RowMetaInterface)outRowMeta);
            this.m_meta.getFields(this.m_data.getOutputRowMeta(), this.getStepname(), null, null, (VariableSpace)this);
            if (this.m_meta.getLookupFields() != null && this.m_meta.getLookupFields().size() > 0 && this.getInputRowMeta() != null && currentInputRow != null) {
                for (AvroInputMeta.LookupField f : this.m_meta.getLookupFields()) {
                    f.init(this.getInputRowMeta(), (VariableSpace)this);
                }
            }
            if (this.m_meta.getAvroInField()) {
                if (this.getInputRowMeta() != null) {
                    this.m_data.initializeFromFieldDecoding(avroFieldName, readerSchema, this.m_meta.getAvroFields(), this.m_meta.getAvroIsJsonEncoded(), newFieldOffset, this.m_meta.getSchemaInField(), schemaFieldName, this.m_meta.getSchemaInFieldIsPath(), this.m_meta.getCacheSchemasInMemory(), this.m_meta.getDontComplainAboutMissingFields(), this.log);
                }
            } else {
                FileObject fileObject = KettleVFS.getFileObject((String)this.m_meta.getFilename(), (VariableSpace)this.getTransMeta());
                this.m_data.establishFileType(fileObject, readerSchema, this.m_meta.getAvroFields(), this.m_meta.getAvroIsJsonEncoded(), newFieldOffset, this.m_meta.getDontComplainAboutMissingFields(), this.log);
            }
        }
        if (!this.m_meta.getAvroInField()) {
            currentInputRow = null;
        } else if (currentInputRow != null && this.m_meta.getLookupFields() != null && this.m_meta.getLookupFields().size() > 0) {
            for (AvroInputMeta.LookupField f : this.m_meta.getLookupFields()) {
                f.setVariable((VariableSpace)this, currentInputRow);
            }
        }
        Object[][] outputRow = null;
        try {
            if (!this.m_meta.getAvroInField() || this.getInputRowMeta() != null) {
                outputRow = this.m_data.avroObjectToKettle(currentInputRow, (VariableSpace)this);
            }
        }
        catch (Exception ex) {
            if (this.getStepMeta().isDoingErrorHandling()) {
                String errorDescriptions = BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Error.ProblemDecodingAvroObject", (String[])new String[]{ex.getMessage()});
                String errorFields = "";
                RowMetaInterface rowMeta = null;
                Object[] currentRow = new Object[]{};
                if (this.m_meta.getAvroInField()) {
                    errorFields = errorFields + this.m_meta.getAvroFieldName();
                    rowMeta = this.getInputRowMeta();
                    currentRow = currentInputRow;
                } else {
                    errorFields = "Data read from file";
                    rowMeta = this.m_data.getOutputRowMeta();
                }
                this.putError(rowMeta, currentRow, 1L, errorDescriptions, errorFields, "AvroInput001");
                if (this.checkFeedback(this.getProcessed())) {
                    this.logBasic(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Message.CheckFeedback", (Object[])new Object[]{this.getProcessed()}));
                }
                return true;
            }
            throw new KettleException(ex.getMessage(), (Throwable)ex);
        }
        if (outputRow != null) {
            for (int i = 0; i < outputRow.length; ++i) {
                this.putRow(this.m_data.getOutputRowMeta(), outputRow[i]);
                if (!this.log.isRowLevel()) continue;
                this.log.logRowlevel(this.toString(), new Object[]{"Outputted row #" + this.getProcessed() + " : " + outputRow});
            }
        } else {
            if (!this.m_meta.getAvroInField()) {
                try {
                    this.logBasic(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Message.ClosingFile", (String[])new String[0]));
                    this.m_data.close();
                }
                catch (IOException ex) {
                    throw new KettleException(ex.getMessage(), (Throwable)ex);
                }
            }
            this.setOutputDone();
            return false;
        }
        if (this.checkFeedback(this.getProcessed())) {
            this.logBasic(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Message.CheckFeedback", (Object[])new Object[]{this.getProcessed()}));
        }
        return true;
    }

    public void setStopped(boolean stopped) {
        if (this.isStopped() && stopped) {
            return;
        }
        super.setStopped(stopped);
        if (stopped && !this.m_meta.getAvroInField()) {
            try {
                this.logBasic(BaseMessages.getString(AvroInputMeta.PKG, (String)"AvroInput.Message.ClosingFile", (String[])new String[0]));
                this.m_data.close();
            }
            catch (IOException ex) {
                this.logError(ex.getMessage(), ex);
            }
        }
    }
}

