/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.avroinput;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.commons.vfs.FileObject;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.avroinput.AvroInputData;
import org.pentaho.di.trans.steps.avroinput.AvroInputMeta;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputMeta;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvroInputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static final Class<?> PKG = AvroInputMeta.class;
    private final AvroInputMeta m_currentMeta;
    private final AvroInputMeta m_originalMeta;
    private CTabFolder m_wTabFolder;
    private CTabItem m_wSourceTab;
    private CTabItem m_wSchemaTab;
    private CTabItem m_wFieldsTab;
    private CTabItem m_wVarsTab;
    private Label m_stepnameLabel;
    private Text m_stepnameText;
    private Button m_sourceInFileBut;
    private Button m_sourceInFieldBut;
    private Label m_defaultSchemaL;
    private Button m_schemaInFieldBut;
    private Label m_schemaInFieldIsPathL;
    private Button m_schemaInFieldIsPathBut;
    private Label m_cacheSchemasL;
    private Button m_cacheSchemasBut;
    private Label m_schemaFieldNameL;
    private CCombo m_schemaFieldNameText;
    private TextVar m_avroFilenameText;
    private Button m_avroFileBrowse;
    private TextVar m_schemaFilenameText;
    private Button m_schemaFileBrowse;
    private CCombo m_avroFieldNameText;
    private Button m_jsonEncodedBut;
    private Button m_missingFieldsBut;
    private Button m_getFields;
    private TableView m_fieldsView;
    private Button m_getLookupFieldsBut;
    private TableView m_lookupView;

    public AvroInputDialog(Shell parent, Object in, TransMeta tr, String name) {
        super(parent, (BaseStepMeta)in, tr, name);
        this.m_currentMeta = (AvroInputMeta)((Object)in);
        this.m_originalMeta = (AvroInputMeta)((Object)this.m_currentMeta.clone());
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.m_currentMeta);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AvroInputDialog.this.m_currentMeta.setChanged();
            }
        };
        this.changed = this.m_currentMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.m_stepnameLabel = new Label((Composite)this.shell, 131072);
        this.m_stepnameLabel.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.StepName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.m_stepnameLabel);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment(0, margin);
        this.m_stepnameLabel.setLayoutData((Object)fd);
        this.m_stepnameText = new Text((Composite)this.shell, 18436);
        this.m_stepnameText.setText(this.stepname);
        this.props.setLook((Control)this.m_stepnameText);
        this.m_stepnameText.addModifyListener(lsMod);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment(0, margin);
        fd.right = new FormAttachment(100, 0);
        this.m_stepnameText.setLayoutData((Object)fd);
        this.m_wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.m_wTabFolder, 5);
        this.m_wTabFolder.setSimple(false);
        this.m_wSourceTab = new CTabItem(this.m_wTabFolder, 0);
        this.m_wSourceTab.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.SourceTab.Title", (String[])new String[0]));
        Composite wSourceComp = new Composite((Composite)this.m_wTabFolder, 0);
        this.props.setLook((Control)wSourceComp);
        FormLayout sourceLayout = new FormLayout();
        sourceLayout.marginWidth = 3;
        sourceLayout.marginHeight = 3;
        wSourceComp.setLayout((Layout)sourceLayout);
        Label fileSourceL = new Label(wSourceComp, 131072);
        this.props.setLook((Control)fileSourceL);
        fileSourceL.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.FileSource.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, margin);
        fd.right = new FormAttachment(middle, -margin);
        fileSourceL.setLayoutData((Object)fd);
        this.m_sourceInFileBut = new Button(wSourceComp, 32);
        this.props.setLook((Control)this.m_sourceInFileBut);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment(0, margin);
        this.m_sourceInFileBut.setLayoutData((Object)fd);
        this.m_sourceInFileBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroInputDialog.this.m_currentMeta.setChanged();
                AvroInputDialog.this.m_sourceInFieldBut.setSelection(!AvroInputDialog.this.m_sourceInFileBut.getSelection());
                AvroInputDialog.this.checkWidgets();
            }
        });
        Label fieldSourceL = new Label(wSourceComp, 131072);
        this.props.setLook((Control)fieldSourceL);
        fieldSourceL.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.FieldSource.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_sourceInFileBut, margin);
        fd.right = new FormAttachment(middle, -margin);
        fieldSourceL.setLayoutData((Object)fd);
        this.m_sourceInFieldBut = new Button(wSourceComp, 32);
        this.props.setLook((Control)this.m_sourceInFieldBut);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.m_sourceInFileBut, margin);
        this.m_sourceInFieldBut.setLayoutData((Object)fd);
        this.m_sourceInFieldBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroInputDialog.this.m_currentMeta.setChanged();
                AvroInputDialog.this.m_sourceInFileBut.setSelection(!AvroInputDialog.this.m_sourceInFieldBut.getSelection());
                AvroInputDialog.this.checkWidgets();
            }
        });
        Label filenameL = new Label(wSourceComp, 131072);
        this.props.setLook((Control)filenameL);
        filenameL.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.Filename.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_sourceInFieldBut, margin);
        fd.right = new FormAttachment(middle, -margin);
        filenameL.setLayoutData((Object)fd);
        this.m_avroFileBrowse = new Button(wSourceComp, 0x1000008);
        this.props.setLook((Control)this.m_avroFileBrowse);
        this.m_avroFileBrowse.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.Button.FileBrowse", (String[])new String[0]));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.m_sourceInFieldBut, 0);
        this.m_avroFileBrowse.setLayoutData((Object)fd);
        this.m_avroFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    String[] fileFilters = new String[]{"*"};
                    String[] fileFilterNames = new String[]{BaseMessages.getString(TextFileInputMeta.class, (String)"System.FileType.AllFiles", (String[])new String[0])};
                    FileObject rootFile = null;
                    FileObject initialFile = null;
                    FileObject defaultInitialFile = null;
                    if (AvroInputDialog.this.m_avroFilenameText.getText() != null) {
                        String fname = AvroInputDialog.this.transMeta.environmentSubstitute(AvroInputDialog.this.m_avroFilenameText.getText());
                        if (!Const.isEmpty((String)fname)) {
                            initialFile = KettleVFS.getFileObject((String)fname);
                            rootFile = initialFile.getFileSystem().getRoot();
                        } else {
                            defaultInitialFile = KettleVFS.getFileObject((String)Spoon.getInstance().getLastFileOpened());
                        }
                    } else {
                        defaultInitialFile = KettleVFS.getFileObject((String)"file:///c:/");
                    }
                    if (rootFile == null) {
                        rootFile = defaultInitialFile.getFileSystem().getRoot();
                    }
                    VfsFileChooserDialog fileChooserDialog = Spoon.getInstance().getVfsFileChooserDialog(rootFile, initialFile);
                    fileChooserDialog.defaultInitialFile = defaultInitialFile;
                    FileObject selectedFile = fileChooserDialog.open(AvroInputDialog.this.shell, null, "hdfs", true, null, fileFilters, fileFilterNames, 0);
                    if (selectedFile != null) {
                        AvroInputDialog.this.m_avroFilenameText.setText(selectedFile.getURL().toString());
                    }
                }
                catch (Exception ex) {
                    AvroInputDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"AvroInputDialog.Error.KettleFileException", (String[])new String[0]), ex);
                    new ErrorDialog(AvroInputDialog.this.shell, AvroInputDialog.this.stepname, BaseMessages.getString((Class)PKG, (String)"AvroInputDialog.Error.KettleFileException", (String[])new String[0]), ex);
                }
            }
        });
        this.m_avroFilenameText = new TextVar((VariableSpace)this.transMeta, wSourceComp, 18496);
        this.props.setLook((Control)this.m_avroFilenameText);
        this.m_avroFilenameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AvroInputDialog.this.m_currentMeta.setChanged();
                AvroInputDialog.this.m_avroFilenameText.setToolTipText(AvroInputDialog.this.transMeta.environmentSubstitute(AvroInputDialog.this.m_avroFilenameText.getText()));
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.m_sourceInFieldBut, margin);
        fd.right = new FormAttachment((Control)this.m_avroFileBrowse, -margin);
        this.m_avroFilenameText.setLayoutData((Object)fd);
        Label avroFieldNameL = new Label(wSourceComp, 131072);
        this.props.setLook((Control)avroFieldNameL);
        avroFieldNameL.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.AvroField.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_avroFilenameText, margin);
        fd.right = new FormAttachment(middle, -margin);
        avroFieldNameL.setLayoutData((Object)fd);
        this.m_avroFieldNameText = new CCombo(wSourceComp, 2048);
        this.props.setLook((Control)this.m_avroFieldNameText);
        this.m_avroFieldNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AvroInputDialog.this.m_currentMeta.setChanged();
                AvroInputDialog.this.m_avroFieldNameText.setToolTipText(AvroInputDialog.this.transMeta.environmentSubstitute(AvroInputDialog.this.m_avroFieldNameText.getText()));
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.m_avroFilenameText, margin);
        fd.right = new FormAttachment(100, 0);
        this.m_avroFieldNameText.setLayoutData((Object)fd);
        Label jsonL = new Label(wSourceComp, 131072);
        this.props.setLook((Control)jsonL);
        jsonL.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.JsonEncoded.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_avroFieldNameText, margin);
        fd.right = new FormAttachment(middle, -margin);
        jsonL.setLayoutData((Object)fd);
        jsonL.setToolTipText(BaseMessages.getString(PKG, (String)"AvroInputDialog.JsonEncoded.TipText", (String[])new String[0]));
        this.m_jsonEncodedBut = new Button(wSourceComp, 32);
        this.props.setLook((Control)this.m_jsonEncodedBut);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.m_avroFieldNameText, margin);
        this.m_jsonEncodedBut.setLayoutData((Object)fd);
        this.m_jsonEncodedBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroInputDialog.this.m_currentMeta.setChanged();
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        wSourceComp.setLayoutData((Object)fd);
        wSourceComp.layout();
        this.m_wSourceTab.setControl((Control)wSourceComp);
        this.m_wSchemaTab = new CTabItem(this.m_wTabFolder, 0);
        this.m_wSchemaTab.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.SchemaTab.Title", (String[])new String[0]));
        Composite wSchemaComp = new Composite((Composite)this.m_wTabFolder, 0);
        this.props.setLook((Control)wSchemaComp);
        FormLayout schemaLayout = new FormLayout();
        schemaLayout.marginWidth = 3;
        schemaLayout.marginHeight = 3;
        wSchemaComp.setLayout((Layout)schemaLayout);
        this.m_defaultSchemaL = new Label(wSchemaComp, 131072);
        this.props.setLook((Control)this.m_defaultSchemaL);
        this.m_defaultSchemaL.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.SchemaFilename.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_defaultSchemaL.setLayoutData((Object)fd);
        this.m_defaultSchemaL.setToolTipText(BaseMessages.getString(PKG, (String)"AvroInputDialog.SchemaFilename.TipText", (String[])new String[0]));
        this.m_schemaFileBrowse = new Button(wSchemaComp, 0x1000008);
        this.props.setLook((Control)this.m_schemaFileBrowse);
        this.m_schemaFileBrowse.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.Button.FileBrowse", (String[])new String[0]));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, 0);
        this.m_schemaFileBrowse.setLayoutData((Object)fd);
        this.m_schemaFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    String[] fileFilters = new String[]{"*"};
                    String[] fileFilterNames = new String[]{BaseMessages.getString(TextFileInputMeta.class, (String)"System.FileType.AllFiles", (String[])new String[0])};
                    FileObject rootFile = null;
                    FileObject initialFile = null;
                    FileObject defaultInitialFile = null;
                    if (AvroInputDialog.this.m_schemaFilenameText.getText() != null) {
                        String fname = AvroInputDialog.this.transMeta.environmentSubstitute(AvroInputDialog.this.m_schemaFilenameText.getText());
                        if (!Const.isEmpty((String)fname)) {
                            initialFile = KettleVFS.getFileObject((String)fname);
                            rootFile = initialFile.getFileSystem().getRoot();
                        } else {
                            defaultInitialFile = KettleVFS.getFileObject((String)Spoon.getInstance().getLastFileOpened());
                        }
                    } else {
                        defaultInitialFile = KettleVFS.getFileObject((String)"file:///c:/");
                    }
                    if (rootFile == null) {
                        rootFile = defaultInitialFile.getFileSystem().getRoot();
                    }
                    VfsFileChooserDialog fileChooserDialog = Spoon.getInstance().getVfsFileChooserDialog(rootFile, initialFile);
                    fileChooserDialog.defaultInitialFile = defaultInitialFile;
                    FileObject selectedFile = fileChooserDialog.open(AvroInputDialog.this.shell, null, "hdfs", true, null, fileFilters, fileFilterNames, 0);
                    if (selectedFile != null) {
                        AvroInputDialog.this.m_schemaFilenameText.setText(selectedFile.getURL().toString());
                    }
                }
                catch (Exception ex) {
                    AvroInputDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"AvroInputDialog.Error.KettleFileException", (String[])new String[0]), ex);
                    new ErrorDialog(AvroInputDialog.this.shell, AvroInputDialog.this.stepname, BaseMessages.getString((Class)PKG, (String)"AvroInputDialog.Error.KettleFileException", (String[])new String[0]), ex);
                }
            }
        });
        this.m_schemaFilenameText = new TextVar((VariableSpace)this.transMeta, wSchemaComp, 18496);
        this.props.setLook((Control)this.m_schemaFilenameText);
        this.m_schemaFilenameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AvroInputDialog.this.m_currentMeta.setChanged();
                AvroInputDialog.this.m_avroFilenameText.setToolTipText(AvroInputDialog.this.transMeta.environmentSubstitute(AvroInputDialog.this.m_schemaFilenameText.getText()));
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment(0, margin);
        fd.right = new FormAttachment((Control)this.m_schemaFileBrowse, -margin);
        this.m_schemaFilenameText.setLayoutData((Object)fd);
        Label schemaInFieldL = new Label(wSchemaComp, 131072);
        this.props.setLook((Control)schemaInFieldL);
        schemaInFieldL.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.SchemaInField.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_schemaFilenameText, margin);
        fd.right = new FormAttachment(middle, -margin);
        schemaInFieldL.setLayoutData((Object)fd);
        this.m_schemaInFieldBut = new Button(wSchemaComp, 32);
        this.props.setLook((Control)this.m_schemaInFieldBut);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.m_schemaFilenameText, margin);
        this.m_schemaInFieldBut.setLayoutData((Object)fd);
        this.m_schemaInFieldBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroInputDialog.this.m_currentMeta.setChanged();
                AvroInputDialog.this.checkWidgets();
            }
        });
        this.m_schemaInFieldIsPathL = new Label(wSchemaComp, 131072);
        this.props.setLook((Control)this.m_schemaInFieldIsPathL);
        this.m_schemaInFieldIsPathL.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.SchemaInFieldIsPath.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_schemaInFieldBut, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_schemaInFieldIsPathL.setLayoutData((Object)fd);
        this.m_schemaInFieldIsPathBut = new Button(wSchemaComp, 32);
        this.props.setLook((Control)this.m_schemaInFieldIsPathBut);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.m_schemaInFieldBut, margin);
        this.m_schemaInFieldIsPathBut.setLayoutData((Object)fd);
        this.m_cacheSchemasL = new Label(wSchemaComp, 131072);
        this.props.setLook((Control)this.m_cacheSchemasL);
        this.m_cacheSchemasL.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.CacheSchemas.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_schemaInFieldIsPathBut, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_cacheSchemasL.setLayoutData((Object)fd);
        this.m_cacheSchemasBut = new Button(wSchemaComp, 32);
        this.props.setLook((Control)this.m_cacheSchemasBut);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.m_schemaInFieldIsPathBut, margin);
        this.m_cacheSchemasBut.setLayoutData((Object)fd);
        this.m_schemaFieldNameL = new Label(wSchemaComp, 131072);
        this.props.setLook((Control)this.m_schemaFieldNameL);
        this.m_schemaFieldNameL.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.SchemaFieldName.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_cacheSchemasBut, margin);
        fd.right = new FormAttachment(middle, -margin);
        this.m_schemaFieldNameL.setLayoutData((Object)fd);
        this.m_schemaFieldNameText = new CCombo(wSchemaComp, 2048);
        this.props.setLook((Control)this.m_schemaFieldNameText);
        this.m_schemaFieldNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AvroInputDialog.this.m_currentMeta.setChanged();
                AvroInputDialog.this.m_schemaFieldNameText.setToolTipText(AvroInputDialog.this.transMeta.environmentSubstitute(AvroInputDialog.this.m_schemaFieldNameText.getText()));
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.m_cacheSchemasBut, margin);
        fd.right = new FormAttachment(100, 0);
        this.m_schemaFieldNameText.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        wSchemaComp.setLayoutData((Object)fd);
        wSchemaComp.layout();
        this.m_wSchemaTab.setControl((Control)wSchemaComp);
        this.m_wFieldsTab = new CTabItem(this.m_wTabFolder, 0);
        this.m_wFieldsTab.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.FieldsTab.Title", (String[])new String[0]));
        Composite wFieldsComp = new Composite((Composite)this.m_wTabFolder, 0);
        this.props.setLook((Control)wFieldsComp);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 3;
        fieldsLayout.marginHeight = 3;
        wFieldsComp.setLayout((Layout)fieldsLayout);
        Label missingFieldsLab = new Label(wFieldsComp, 131072);
        this.props.setLook((Control)missingFieldsLab);
        missingFieldsLab.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.MissingFields.Label", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, margin);
        fd.right = new FormAttachment(middle, -margin);
        missingFieldsLab.setLayoutData((Object)fd);
        this.m_missingFieldsBut = new Button(wFieldsComp, 32);
        this.props.setLook((Control)this.m_missingFieldsBut);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment(0, margin);
        this.m_missingFieldsBut.setLayoutData((Object)fd);
        this.m_getFields = new Button(wFieldsComp, 8);
        this.m_getFields.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.Button.GetFields", (String[])new String[0]));
        this.props.setLook((Control)this.m_getFields);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.m_getFields.setLayoutData((Object)fd);
        this.m_getFields.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroInputDialog.this.getFields();
            }
        });
        this.wPreview = new Button(wFieldsComp, 0x1000008);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.props.setLook((Control)this.wPreview);
        fd = new FormData();
        fd.right = new FormAttachment((Control)this.m_getFields, margin);
        fd.bottom = new FormAttachment(100, 0);
        this.wPreview.setLayoutData((Object)fd);
        this.wPreview.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroInputDialog.this.preview();
            }
        });
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroInputDialog.Fields.FIELD_NAME", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroInputDialog.Fields.FIELD_PATH", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroInputDialog.Fields.FIELD_TYPE", (String[])new String[0]), 2, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroInputDialog.Fields.FIELD_INDEXED", (String[])new String[0]), 1, false)};
        colinf[2].setComboValues(ValueMeta.getTypes());
        this.m_fieldsView = new TableView((VariableSpace)this.transMeta, wFieldsComp, 65538, colinf, 1, lsMod, this.props);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.m_missingFieldsBut, margin * 2);
        fd.bottom = new FormAttachment((Control)this.m_getFields, -margin * 2);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.m_fieldsView.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fd);
        wFieldsComp.layout();
        this.m_wFieldsTab.setControl((Control)wFieldsComp);
        this.m_wVarsTab = new CTabItem(this.m_wTabFolder, 0);
        this.m_wVarsTab.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.VarsTab.Title", (String[])new String[0]));
        Composite wVarsComp = new Composite((Composite)this.m_wTabFolder, 0);
        this.props.setLook((Control)wVarsComp);
        FormLayout varsLayout = new FormLayout();
        varsLayout.marginWidth = 3;
        varsLayout.marginHeight = 3;
        wVarsComp.setLayout((Layout)varsLayout);
        ColumnInfo[] colinf2 = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroInputDialog.Fields.LOOKUP_NAME", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroInputDialog.Fields.LOOKUP_VARIABLE", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroInputDialog.Fields.LOOKUP_DEFAULT_VALUE", (String[])new String[0]), 1, false)};
        this.m_getLookupFieldsBut = new Button(wVarsComp, 0x1000008);
        this.props.setLook((Control)this.m_getLookupFieldsBut);
        this.m_getLookupFieldsBut.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.Button.GetLookupFields", (String[])new String[0]));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, -margin * 2);
        this.m_getLookupFieldsBut.setLayoutData((Object)fd);
        this.m_getLookupFieldsBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroInputDialog.this.getIncomingFields();
            }
        });
        this.m_lookupView = new TableView((VariableSpace)this.transMeta, wVarsComp, 65538, colinf2, 1, lsMod, this.props);
        fd = new FormData();
        fd.top = new FormAttachment(0, margin * 2);
        fd.bottom = new FormAttachment((Control)this.m_getLookupFieldsBut, -margin * 2);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.m_lookupView.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        wVarsComp.setLayoutData((Object)fd);
        wVarsComp.layout();
        this.m_wVarsTab.setControl((Control)wVarsComp);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_stepnameText, margin);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, -50);
        this.m_wTabFolder.setLayoutData((Object)fd);
        this.populateFieldsCombo();
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, (Control)this.m_wTabFolder);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                AvroInputDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                AvroInputDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AvroInputDialog.this.ok();
            }
        };
        this.m_stepnameText.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                AvroInputDialog.this.cancel();
            }
        });
        this.m_wTabFolder.setSelection(0);
        this.setSize();
        this.getData();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void cancel() {
        this.stepname = null;
        this.m_currentMeta.setChanged(this.changed);
        this.dispose();
    }

    protected void ok() {
        if (Const.isEmpty((String)this.m_stepnameText.getText())) {
            return;
        }
        this.stepname = this.m_stepnameText.getText();
        this.setMeta(this.m_currentMeta);
        if (!((Object)((Object)this.m_originalMeta)).equals((Object)this.m_currentMeta)) {
            this.m_currentMeta.setChanged();
            this.changed = this.m_currentMeta.hasChanged();
        }
        this.dispose();
    }

    protected void setMeta(AvroInputMeta avroMeta) {
        Object newField;
        TableItem item;
        int i;
        avroMeta.setFilename(this.m_avroFilenameText.getText());
        avroMeta.setSchemaFilename(this.m_schemaFilenameText.getText());
        avroMeta.setAvroIsJsonEncoded(this.m_jsonEncodedBut.getSelection());
        avroMeta.setAvroInField(this.m_sourceInFieldBut.getSelection());
        avroMeta.setAvroFieldName(this.m_avroFieldNameText.getText());
        avroMeta.setSchemaInField(this.m_schemaInFieldBut.getSelection());
        avroMeta.setSchemaInFieldIsPath(this.m_schemaInFieldIsPathBut.getSelection());
        avroMeta.setCacheSchemasInMemory(this.m_cacheSchemasBut.getSelection());
        avroMeta.setSchemaFieldName(this.m_schemaFieldNameText.getText());
        avroMeta.setDontComplainAboutMissingFields(this.m_missingFieldsBut.getSelection());
        int numNonEmpty = this.m_fieldsView.nrNonEmpty();
        if (numNonEmpty > 0) {
            ArrayList<AvroInputMeta.AvroField> outputFields = new ArrayList<AvroInputMeta.AvroField>();
            for (i = 0; i < numNonEmpty; ++i) {
                item = this.m_fieldsView.getNonEmpty(i);
                newField = new AvroInputMeta.AvroField();
                ((AvroInputMeta.AvroField)newField).m_fieldName = item.getText(1).trim();
                ((AvroInputMeta.AvroField)newField).m_fieldPath = item.getText(2).trim();
                ((AvroInputMeta.AvroField)newField).m_kettleType = item.getText(3).trim();
                if (!Const.isEmpty((String)item.getText(4))) {
                    ((AvroInputMeta.AvroField)newField).m_indexedVals = AvroInputMeta.indexedValsList(item.getText(4).trim());
                }
                outputFields.add((AvroInputMeta.AvroField)newField);
            }
            avroMeta.setAvroFields(outputFields);
        }
        if ((numNonEmpty = this.m_lookupView.nrNonEmpty()) > 0) {
            ArrayList<AvroInputMeta.LookupField> varFields = new ArrayList<AvroInputMeta.LookupField>();
            for (i = 0; i < numNonEmpty; ++i) {
                item = this.m_lookupView.getNonEmpty(i);
                newField = new AvroInputMeta.LookupField();
                boolean add = false;
                ((AvroInputMeta.LookupField)newField).m_fieldName = item.getText(1).trim();
                if (!Const.isEmpty((String)item.getText(2))) {
                    ((AvroInputMeta.LookupField)newField).m_variableName = item.getText(2).trim();
                    add = true;
                    if (!Const.isEmpty((String)item.getText(3))) {
                        ((AvroInputMeta.LookupField)newField).m_defaultValue = item.getText(3).trim();
                    }
                }
                if (!add) continue;
                varFields.add((AvroInputMeta.LookupField)newField);
            }
            avroMeta.setLookupFields(varFields);
        }
    }

    protected void getFields() {
        if (!Const.isEmpty((String)this.m_schemaFilenameText.getText())) {
            String sName = this.m_schemaFilenameText.getText();
            sName = this.transMeta.environmentSubstitute(sName);
            try {
                Schema s = AvroInputData.loadSchema(sName);
                List<AvroInputMeta.AvroField> schemaFields = AvroInputData.getLeafFields(s);
                this.setTableFields(schemaFields);
            }
            catch (Exception ex) {
                this.logError(BaseMessages.getString(PKG, (String)("AvroInputDialog.Error.KettleFileException " + sName), (String[])new String[0]), ex);
                new ErrorDialog(this.shell, this.stepname, BaseMessages.getString(PKG, (String)("AvroInputDialog.Error.KettleFileException " + sName), (String[])new String[0]), ex);
            }
        } else {
            String avroFileName = this.m_avroFilenameText.getText();
            avroFileName = this.transMeta.environmentSubstitute(avroFileName);
            try {
                Schema s = AvroInputData.loadSchemaFromContainer(avroFileName);
                List<AvroInputMeta.AvroField> schemaFields = AvroInputData.getLeafFields(s);
                this.setTableFields(schemaFields);
            }
            catch (Exception ex) {
                this.logError(BaseMessages.getString(PKG, (String)"AvroInput.Error.UnableToLoadSchemaFromContainerFile", (String[])new String[0]), ex);
                new ErrorDialog(this.shell, this.stepname, BaseMessages.getString(PKG, (String)"AvroInput.Error.UnableToLoadSchemaFromContainerFile", (String[])new String[]{avroFileName}), ex);
            }
        }
    }

    protected void setTableFields(List<AvroInputMeta.AvroField> fields) {
        this.m_fieldsView.clearAll();
        for (AvroInputMeta.AvroField f : fields) {
            TableItem item = new TableItem(this.m_fieldsView.table, 0);
            if (!Const.isEmpty((String)f.m_fieldName)) {
                item.setText(1, f.m_fieldName);
            }
            if (!Const.isEmpty((String)f.m_fieldPath)) {
                item.setText(2, f.m_fieldPath);
            }
            if (!Const.isEmpty((String)f.m_kettleType)) {
                item.setText(3, f.m_kettleType);
            }
            if (f.m_indexedVals == null || f.m_indexedVals.size() <= 0) continue;
            item.setText(4, AvroInputMeta.indexedValsList(f.m_indexedVals));
        }
        this.m_fieldsView.removeEmptyRows();
        this.m_fieldsView.setRowNums();
        this.m_fieldsView.optWidth(true);
    }

    protected void setVariableTableFields(List<AvroInputMeta.LookupField> fields) {
        this.m_lookupView.clearAll();
        for (AvroInputMeta.LookupField f : fields) {
            TableItem item = new TableItem(this.m_lookupView.table, 0);
            if (!Const.isEmpty((String)f.m_fieldName)) {
                item.setText(1, f.m_fieldName);
            }
            if (!Const.isEmpty((String)f.m_variableName)) {
                item.setText(2, f.m_variableName);
            }
            if (Const.isEmpty((String)f.m_defaultValue)) continue;
            item.setText(3, f.m_defaultValue);
        }
        this.m_lookupView.removeEmptyRows();
        this.m_lookupView.setRowNums();
        this.m_lookupView.optWidth(true);
    }

    protected void getData() {
        if (!Const.isEmpty((String)this.m_currentMeta.getFilename())) {
            this.m_avroFilenameText.setText(this.m_currentMeta.getFilename());
        }
        if (!Const.isEmpty((String)this.m_currentMeta.getSchemaFilename())) {
            this.m_schemaFilenameText.setText(this.m_currentMeta.getSchemaFilename());
        }
        if (!Const.isEmpty((String)this.m_currentMeta.getAvroFieldName())) {
            this.m_avroFieldNameText.setText(this.m_currentMeta.getAvroFieldName());
        }
        this.m_jsonEncodedBut.setSelection(this.m_currentMeta.getAvroIsJsonEncoded());
        this.m_sourceInFieldBut.setSelection(this.m_currentMeta.getAvroInField());
        if (!this.m_currentMeta.getAvroInField()) {
            this.m_sourceInFileBut.setSelection(true);
        }
        this.m_schemaInFieldBut.setSelection(this.m_currentMeta.getSchemaInField());
        this.m_schemaInFieldIsPathBut.setSelection(this.m_currentMeta.getSchemaInFieldIsPath());
        this.m_cacheSchemasBut.setSelection(this.m_currentMeta.getCacheSchemasInMemory());
        this.m_missingFieldsBut.setSelection(this.m_currentMeta.getDontComplainAboutMissingFields());
        if (!Const.isEmpty((String)this.m_currentMeta.getSchemaFieldName())) {
            this.m_schemaFieldNameText.setText(this.m_currentMeta.getSchemaFieldName());
        }
        if (this.m_currentMeta.getAvroFields() != null && this.m_currentMeta.getAvroFields().size() > 0) {
            this.setTableFields(this.m_currentMeta.getAvroFields());
        }
        if (this.m_currentMeta.getLookupFields() != null && this.m_currentMeta.getLookupFields().size() > 0) {
            this.setVariableTableFields(this.m_currentMeta.getLookupFields());
        }
        this.checkWidgets();
    }

    private void checkWidgets() {
        boolean sifile = this.m_sourceInFileBut.getSelection();
        this.m_avroFilenameText.setEnabled(sifile);
        this.m_avroFileBrowse.setEnabled(sifile);
        boolean sifield = this.m_sourceInFieldBut.getSelection();
        if (sifield) {
            this.m_sourceInFileBut.setSelection(!sifield);
        }
        this.m_avroFilenameText.setEnabled(!sifield);
        this.m_avroFileBrowse.setEnabled(!sifield);
        this.m_avroFieldNameText.setEnabled(sifield);
        this.wPreview.setEnabled(this.m_sourceInFileBut.getSelection());
        if (sifile) {
            this.m_schemaInFieldBut.setSelection(false);
        }
        this.m_schemaInFieldBut.setEnabled(!sifile);
        boolean sField = this.m_schemaInFieldBut.getSelection();
        this.m_schemaInFieldIsPathL.setEnabled(sField);
        this.m_schemaInFieldIsPathBut.setEnabled(sField);
        this.m_cacheSchemasL.setEnabled(sField);
        this.m_cacheSchemasBut.setEnabled(sField);
        this.m_schemaFieldNameL.setEnabled(sField);
        this.m_schemaFieldNameText.setEnabled(sField);
        if (sField) {
            this.m_defaultSchemaL.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.DefaultSchemaFilename.Label", (String[])new String[0]));
        } else {
            this.m_defaultSchemaL.setText(BaseMessages.getString(PKG, (String)"AvroInputDialog.SchemaFilename.Label", (String[])new String[0]));
        }
    }

    private void preview() {
        AvroInputMeta tempMeta = new AvroInputMeta();
        this.setMeta(tempMeta);
        TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)tempMeta, (String)this.m_stepnameText.getText());
        this.transMeta.getVariable("Internal.Transformation.Filename.Directory");
        previewMeta.getVariable("Internal.Transformation.Filename.Directory");
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"CsvInputDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AvroInputDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.m_stepnameText.getText()}, new int[]{previewSize});
            progressDialog.open();
            Trans trans = progressDialog.getTrans();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.m_stepnameText.getText(), progressDialog.getPreviewRowsMeta(this.m_stepnameText.getText()), progressDialog.getPreviewRows(this.m_stepnameText.getText()), loggingText);
            prd.open();
        }
    }

    private void getIncomingFields() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                BaseStepDialog.getFieldsFromPrevious((RowMetaInterface)r, (TableView)this.m_lookupView, (int)1, (int[])new int[]{1}, null, (int)-1, (int)-1, null);
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void populateFieldsCombo() {
        StepMeta stepMeta = this.transMeta.findStep(this.stepname);
        if (stepMeta != null) {
            try {
                RowMetaInterface rowMeta = this.transMeta.getPrevStepFields(stepMeta);
                if (rowMeta != null && rowMeta.size() > 0) {
                    this.m_avroFieldNameText.removeAll();
                    this.m_schemaFieldNameText.removeAll();
                    for (int i = 0; i < rowMeta.size(); ++i) {
                        ValueMetaInterface vm = rowMeta.getValueMeta(i);
                        String fieldName = vm.getName();
                        this.m_avroFieldNameText.add(fieldName);
                        this.m_schemaFieldNameText.add(fieldName);
                    }
                }
            }
            catch (KettleException ex) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ex));
            }
        }
    }
}

